
% This function projects on intersection of Groupwise-Sparse Ball while all variables are positive and maximum allowed value for group is one
% Inputs:
%     x : original point
%     G : and integer-valued vector with the same size as x that specifies groupwise sparsity. G(i) is an integer number specifying group index of of the
%         i'th variable
%     lambda: this is a value that specifies upper bound for the group-wise sparsity
%     prjFcn: It is a function handler for projection on the truncated simplex
%
%       Written by  Kayhan  Batmanghelich
%                   March 2012
%                   Section of Biomedical Image Analysis (SBIA)
%                   University of Pennsylvania


function xp = ProjectionOnGroupSparseUnitBox(x,G,lambda,prjFcn)
      % some initialization and sanity checks
      G = double(G) ;
      numGrp = max(G) ;
      % first project on the positive orthant
      x_org = x ;
      x(x < 0) = 0 ;
      [val, grpVals] = grpNorm(x,G) ;
      xp = x ;
      if (val > lambda)
          xp = ProjectionOnSet(x,G,lambda,prjFcn) ;
          xp = xp' ;
      end   
end

function xp = ProjectionOnSet(x0,G,lambda,prjFcn)
    x = x0 ;
    xp = zeros(size(x0)) ;
    numGrp = max(G) ;
    [val, grpVals] = grpNorm(double(x0),G) ;
    grp_prj = prjFcn(grpVals,lambda) ;
    for cnt=1:numGrp
        if (grpVals(cnt)>0)
          xp(G==cnt) = grp_prj(cnt)/grpVals(cnt)*x(G==cnt) ;
        end
    end
end

function [val, grpVals] = grpNorm2(x,G)
    numGrp = max(G) ;
    x2 = x.*x ;
    grpVals = zeros(numGrp,1) ;
    for cnt=1:numGrp
        grpVals(cnt) = sqrt(1/sum(G==cnt)*sum(x2(G==cnt))) ;
    end
    val = sum(grpVals) ;
end
