/** 
 * @file MainPipeline.h
 * @brief Creates and executes the ITK pipeline
 * @author Matthew McCormick (thewtex)
 * @version 
 * @date 2009-07-01
 */

#ifndef _READMEDICALIMAGEPIPELINE_H
#define _READMEDICALIMAGEPIPELINE_H

#include "itkImageFileReader.h"
#include "itkImageRegionConstIterator.h"
#include <iostream>


#include "mex.h" 

template<typename TImageType>
void ReadFile(std::string filename, typename TImageType::Pointer image)
{
  typedef itk::ImageFileReader<TImageType> ReaderType;
  typename ReaderType::Pointer reader = ReaderType::New();
 
  reader->SetFileName(filename);
  reader->Update();
 
  image->Graft(reader->GetOutput());
  
}

class ReadMedicalImagePipeline
{
public:
  ReadMedicalImagePipeline(char* filepath);
  ~ReadMedicalImagePipeline() ;


  /** 
   * @brief Creates and copies the resulting image and its location information to the given
   * double pointers.  Transpose to address C/Fortran column/row memory
   * ordering.
   * 
   * @param image
   * @param origin
   * @param spacing
   */
  void CopyAndTranspose(double* image, double* origin=0, double* spacing=0, double* direction=0);

  /** 
   * @brief get the size of the transposed output image
   * 
   * @param m rows 
   * @param n columns 
   */
  //void GetSize(size_t& m, size_t& n, size_t& s);

  // main MATLAB types
  mwSize m_numDimensions ;
  mwSize *m_dims ;

  // main itk types
  //typedef double PixelType;
  //const static unsigned int Dimension = 3;
  //typedef itk::Image<PixelType, Dimension> ImageType;
  

protected:
  // filter types
  //typedef itk::ImageFileReader<ImageType> ReaderType;
  //ReaderType::Pointer m_reader;
  typedef itk::ImageIOBase::IOComponentType ScalarComponentType;
  ScalarComponentType m_componentType ;

  typedef itk::ImageIOBase::IOPixelType   PixelType ;
  PixelType   m_pixelType ;  


  char* m_filepath;
  

};

#endif // _READMEDICALIMAGEPIPELINE_H
