% This function normalizes data according to the options. If the optiond
% has "normalizeParams" as a field, it uses that otherwise it normalize it
% according to the mode
%
%       Written by  Kayhan  Batmanghelich
%                   March 2012
%                   Section of Biomedical Image Analysis (SBIA)
%                   University of Pennsylvania


function [V,normalizeParams] = normalizeData(V,opt)
    if isfield(opt,'normalizeParams')
        normalizeParams = opt.normalizeParams ;
    else
        normalizeParams = [] ;
    end
    switch opt.nrm_mode,
        case 0,
            % do nothing
        case 1,  % z-score
            if isfield(opt,'normalizeParams')
                V_ave = normalizeParams.V_ave  ;
                V_std = normalizeParams.V_std  ;
            else
                for ii=1:size(V,3)
                  V_ave(:,:,ii) = mean(V(:,:,ii),2) ;
                  V_std(:,:,ii) = std(V(:,:,ii),0,2) ;
                  V_std(V_std==0) = 1 ;
                end
                normalizeParams.V_ave = V_ave ;
                normalizeParams.V_std = V_std ;
            end
            for ii=1:size(V,3)
                V(:,:,ii) = V(:,:,ii) - repmat(V_ave(:,:,ii),1,size(V(:,:,ii),2)) ;
                V(:,:,ii) = V(:,:,ii)./repmat(V_std(:,:,ii),1,size(V(:,:,ii),2)) ; 
            end
        case 2,  % between [0,1]
            if isfield(opt,'normalizeParams')
                v_min = normalizeParams.v_min ;
                v_max = normalizeParams.v_max ;
                v_scale = normalizeParams.v_scale ;
            else
                for ii=1:size(V,3)
                  v_min(:,:,ii) = min(V(:,:,ii),[],2) ;
                  v_max(:,:,ii) = max(V(:,:,ii),[],2) ;
                  v_scale(:,:,ii) = v_max(:,:,ii) - v_min(:,:,ii) ;
                  v_scale(v_scale==0) = 1 ;
                end
                normalizeParams.v_min = v_min ;
                normalizeParams.v_max = v_max ;
                normalizeParams.v_scale = v_scale ;
            end
            for ii=1:size(V,3)
                V(:,:,ii) = V(:,:,ii) - repmat(v_min(:,:,ii),1,size(V(:,:,ii),2)) ;
                V(:,:,ii) = V(:,:,ii)./ repmat(v_scale(:,:,ii),1,size(V(:,:,ii),2)) ;
            end
        case 3,
            if isfield(opt,'normalizeParams')
                sc = normalizeParams.sc ;
            else
                for ii=1:size(V,3)
                  sc(ii) = min(max(V(:,:,ii))) ;
                end
                normalizeParams.sc = sc ;
            end
            for ii=1:size(V,3)
              V(:,:,ii) = V(:,:,ii)/sc(ii)*opt.nrm_scale ;
            end
        otherwise,
            error('unknown normalization mode !') ;         
    end
end
