% Digits_GenDisc_tradeOffCurve   [option Name]   [option Value]    
%   
%   [option Name]           [option Value]                                        obligatory ?           
%------------------------------------------------------------------------------------------------
%   InputFile               a full path to a .mat file                               YES                  
%   ResultFile              a full path to a .mat file                               YES   
%   lambda_gen              a real value (lambda generative)                         YES
%   lambda_disc             a real value (discriminative generative)                 YES
%   lambda_const            a real value (sparsity ratio)                            YES
%   num_basis               number of basis vectors                                  YES
%   
%
%   Description
%--------------------------------------------------------------------- 
%   InputFile                    a MATLAB file containing options and input data and experiment information for cross-validation
%
%   ResultFile                   a MATLAB file containing results including basis and cross validation results
%
%   


function Digits_GenDisc_tradeOffCurve(varargin)
         % parse options
         Args = parseArguments(varargin) ;
         

         % load data and option MAT file
         fprintf('input file : %s \n ',Args.InputFile) ;
         fprintf('output file : %s \n ',Args.ResultFile) ;

         load(Args.InputFile) ;
         
         ConstVars.r = Args.num_basis ;
         ConstVars.lambda_gen = Args.lambda_gen ;                  % weight for Frobinous norm
         ConstVars.lambda_disc = Args.lambda_disc ;                 % weight for the loss function
         ConstVars.lambda_const = Args.lambda_const ;            % RHS of the sparseness term
         
         
         AccMatrix_Internal = zeros(expOption.numRepeat,expOption.numFolds) ;
         AccMatrix_Constant = zeros(expOption.numRepeat,expOption.numFolds) ;
         resultsCell = cell(expOption.numRepeat,expOption.numFolds) ;
         for expCnt=1:expOption.numRepeat
             for foldCnt=1:expOption.numFolds
                 Data.V = V(:,expOption.TrainIndex{expCnt,foldCnt}) ;
                 Data.y = imgLabels(expOption.TrainIndex{expCnt,foldCnt}) ;
                 ConstVars.N = size(Data.V,2) ;
                 % create constant matrices
                 Data.W0 = rand(ConstVars.D,ConstVars.r) ;
                 Data.W0 = Data.W0./repmat(sum(Data.W0),ConstVars.D,1)*ConstVars.lambda_const/2 ;   % to make initialization feasible 
                 Data.H0 = rand(ConstVars.r,ConstVars.N) ;
                 Data.w0 = randn(ConstVars.r,1) ;

                 %[B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                 [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek2(Data,ConstVars) ;

                 
                 % extract train features
                 featureTrain = (V(:,expOption.TrainIndex{expCnt,foldCnt})'*B) ;
                 yTrain = imgLabels(expOption.TrainIndex{expCnt,foldCnt}) ;
                 featureTest = (V(:,expOption.TestIndex{expCnt,foldCnt})'*B) ;
                 yTest = imgLabels(expOption.TestIndex{expCnt,foldCnt}) ;
                
                 if (ConstVars.lambda_disc > 0) 
                    % training a model
                    %svm_opt = ['-s 2   -e 0.0001   -B 1   -c ' num2str(ConstVars.lambda_disc)  ' '] ;
                    svm_opt = ['-s 4   -e 0.0001   -B 1   -c ' num2str(ConstVars.lambda_disc)  ' '] ;
                    svm_opt = [svm_opt  '  ' ] ;
                    modelInternal = train(yTrain,sparse(featureTrain),svm_opt) ;  
                    [~, accInternal, ~] = predict(yTest, sparse(featureTest), modelInternal) ;
                  else
                    accInternal = 0 ; 
                  end
                 
                 %svm_opt = ['-s 2   -e 0.0001   -B 1   -c 1 '   ] ;
                 svm_opt = ['-s 4   -e 0.0001   -B 1   -c 1 '   ] ;
                 svm_opt = [svm_opt  '  ' ] ;
                 modelConstant = train(yTrain,sparse(featureTrain),svm_opt) ;   
                 
                 % prediction for test
                 [~, accConstant, ~] = predict(yTest, sparse(featureTest), modelConstant) ;
                 
                 % put the result together
                 results.B = B ;
                 results.w = w ;
                 results.Report = Report ;
                 AccMatrix_Internal(expCnt,foldCnt) = accInternal ;
                 AccMatrix_Constant(expCnt,foldCnt) = accConstant ;
                
                 resultsCell{expCnt,foldCnt} = results ; 

                 fprintf(' **Report** (expCnt,foldCnt) = (%d,%d)  .... Done \n',expCnt,foldCnt) ;
                                  
             end
         end
         
         % save results
         save(Args.ResultFile,'resultsCell','AccMatrix_Internal','AccMatrix_Constant') ;
                   
end



% this function 
function Options = parseArguments(argOpt)
        numArgs = size(argOpt) ;
        % check for the required arguments
        Options = []  ;
        cnt = 1 ;
        % collect all options into a data structure
        while  (true)
            if (cnt > numArgs)
              break ;
            end
            optName = argOpt{cnt} ;
            if ~(isstr(optName))
                usage() ;
                error('option name must be string !! ') ;
            end
            if ((cnt+1) > numArgs)
                usage() ;
                error(['You probably forgot value for this option : ' optName ' ']) ;
            end
            optVal = argOpt{cnt+1} ;
            Options.(optName) = optVal ;
            cnt = cnt + 2 ;
        end
        
        %  Now we check 
        % checking input file
        if ~isfield(Options,'InputFile')
            usage() ;
            error('you may forgot to provide "InputFile" option ! It is a mandatory option !!! ') ;      
        end         
        
        % checking Result file
        if ~isfield(Options,'ResultFile')
            usage() ;
            error('you may forgot to provide "ResultFile" option ! It is a mandatory option !!! ') ;      
        end         
        
        % checking lambda_gen option
        if ~isfield(Options,'lambda_gen')
            usage() ;
            error('you may forgot to provide "lambda_gen" option ! It is a mandatory option !!! ') ;
        else
            if isdeployed()
                try 
                    Options.lambda_gen = str2num(Options.lambda_gen) ;     
                catch exception
                    disp(exception.message);
                    usage() ;
                    error('lambda_gen must be a number (e.g. 1001) !!! ')  ;
                end
            else
                if ~isnumeric(Options.lambda_gen)
                    usage() ;
                    error('lambda_gen must be a number (e.g. 1001) !!!  ')  ;
                end
            end 
        end
        
        % checking lambda_disc option
        if ~isfield(Options,'lambda_disc')
            usage() ;
            error('you may forgot to provide "lambda_disc" option ! It is a mandatory option !!! ') ;
        else
            if isdeployed()
                try 
                    Options.lambda_disc = str2num(Options.lambda_disc) ;     
                catch exception
                    disp(exception.message);
                    usage() ;
                    error('lambda_disc must be a number (e.g. 1001) !!! ')  ;
                end
            else
                if ~isnumeric(Options.lambda_disc)
                    usage() ;
                    error('lambda_disc must be a number (e.g. 1001) !!!  ')  ;
                end
            end 
        end
        
        % checking lambda_const option
        if ~isfield(Options,'lambda_const')
            usage() ;
            error('you may forgot to provide "lambda_const" option ! It is a mandatory option !!! ') ;
        else
            if isdeployed()
                try 
                    Options.lambda_const = str2num(Options.lambda_const) ;     
                catch exception
                    disp(exception.message);
                    usage() ;
                    error('lambda_const must be a number (e.g. 1001) !!! ')  ;
                end
            else
                if ~isnumeric(Options.lambda_const)
                    usage() ;
                    error('lambda_const must be a number (e.g. 1001) !!!  ')  ;
                end
            end 
        end
        
        % checking num_basis option
        if ~isfield(Options,'num_basis')
            usage() ;
            error('you may forgot to provide "num_basis" option ! It is a mandatory option !!! ') ;
        else
            if isdeployed()
                try 
                    Options.num_basis = str2num(Options.num_basis) ;     
                    if  (Options.num_basis~=round(Options.num_basis))
                        error('num_basis must be a natural number !!!!') ;
                    end
                catch exception
                    disp(exception.message);
                    usage() ;
                    error('num_basis must be a number (e.g. 1001) !!! ')  ;
                end
            else
                if ~isnumeric(Options.num_basis)
                    usage() ;
                    error('num_basis must be a number (e.g. 1001) !!!  ')  ;
                end
                if  (Options.num_basis~=round(Options.num_basis))
                    error('num_basis must be a natural number !!!!') ;
                end
            end 
        end
        
        
        %  print Option on stdout just for fun !
        Options 
       
end

% how to use this executable 
function usage()
        fprintf('to be written later .... \n') ;
end


