%% Initialization
clear
close all
clc
addpath('/sbia/home/batmangn/code/Projects/GONDOLA-build/bin')
addpath('/sbia/home/batmangn/code/Projects/GONDOLA-build/lib')
addpath('/sbia/home/batmangn/Software/mosek/6/toolbox/r2009b')
addpath('/sbia/home/batmangn/code/Projects/GONDOLA/src')
addpath('/sbia/home/batmangn/Software/liblinear-1.8/matlab')

USPSDataPath = '../data/uspsDigits' ;

% general variables for problem 
global ZSBT ;
ZSBT = 1e-20 ;   %zero substituite
MAXITR = 30 ;
tol =  1e-3 ;
r = 20      ;
N1 = 100    ;
N2 = 100    ;
N3 = 100    ;
ConstVars.numClasses = 3 ;
ConstVars.classWeight = [1/N1 ; 1/N2 ; 1/N3] ;
ConstVars.nullWeight = 1/(N1 + N2 + N3) ;
N = N1 + N2 + N3    ;
D = 256 ;
ConstVars.r = r ;                           % number of basis vectors
ConstVars.N = N ;                           % Number of samples to be used for training
ConstVars.lambda_gen = 256/(N*D)*0.1 ;                  % weight for Frobinous norm
ConstVars.lambda_disc = 0.5 ;                 % weight for the loss function
ConstVars.lambda_const = 16*16*0.2 ;            % RHS of the sparseness term
ConstVars.lambda_stab = 0.01 ;                 % regularizer for the coefficients
ConstVars.MAXITR = MAXITR  ;                % MAXITR for optimization 
ConstVars.ZSBT = ZSBT ;                     % zero substituite
ConstVars.tol = tol ;                       % tolerance for optimization

% Dataset information
FeatureFilename = 'usps_4_7.mat' ;
DataFcnHandler = @uspsdigits ;
ConstVars.digitsList = {4,7,6} ;
ConstVars.classID = {'4','7','6'} ;
ConstVars.numfolds = 2 ; 
ConstVars.foldnum = 1 ;
ConstVars.numSampleList  = {N1,N2,N2} ;	% number of images to be used to derive basis vectors
ConstVars.downsampleFlag = false ;
ConstVars.Datapath = USPSDataPath ;
ConstVars.pathTodata = USPSDataPath ;
ConstVars.reExtractFeature = true ;
ConstVars.FeatureFilename = FeatureFilename ;
ConstVars.D1 = 16 ;    % x: original image size
ConstVars.D2 = 16 ;    % y: original image size
ConstVars.D = D ;
ConstVars.DownSampleRatio = 1 ;
ConstVars.numChannels = 1 ;
ConstVars.saveAfterEachIteration = false ;
ConstVars.randSeed = 0 ;


% options for the Bsolver 
ConstVars.BSolver_opt.BBMethod = 3 ; 

% optimizer parameter
%ConstVars.BBSolverPath = BBSolverPath;
%ConstVars.mosekPath = mosekPath;
%ConstVars.LibLinearPath = LibLinearPath ;
ConstVars.Monitor_Bsol = true ;   % this options monitors the solution for B and if it increases (instead of decrease), returns it back to the old B
ConstVars.Monitor_Csol = true ;   % this options monitors the solution for C and if it increases (instead of decrease), returns it back to the old C

if ConstVars.reExtractFeature
    [V,IndicesForBasis, IndicesForTrain,IndicesForTest] = feval(DataFcnHandler,ConstVars) ;   
    Data.V = V ;
    Data.y = [ones(N1,1) ; 2*ones(N2,1); 3*ones(N3,1)] ;
    save(ConstVars.FeatureFilename,'ConstVars','Data')
else
    load(ConstVars.FeatureFilename,'ConstVars','Data')
end

% create constant matrices
Data.W0 = rand(D,r) ;
Data.W0 = Data.W0./repmat(sum(Data.W0),D,1)*ConstVars.lambda_const/2 ;   % to make initialization feasible 
Data.H0 = rand(r,N) ;
Data.w0 = randn(r,1) ;

[B,C,w,Report] = MultiChannel_SingleView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
figure;plot(Report.Obj_Hist) ;
figure;nmf_ShowBasis(B,ConstVars) ;
figure;plot(Report.Terms_Hist(1,:))
figure;plot(Report.Terms_Hist(2,:))
figure;plot(Report.Terms_Hist(3,:))
Report.Obj_Hist(end)
% report of sparsity based on Hoyer's definition
sp = 1/(sqrt(D) - 1)*(sqrt(D) - sum(B)./sum(B.^2)) ;
mean(sp)

