function    moduleTester(testNum)
       switch testNum
           case 1   % testing box-projection module
               nRepeat = 200 ;
               dim = 500 ;
               lambda = dim*0.2 ;
               eHis = zeros(nRepeat,1) ;
               for  cnt=1:nRepeat
                   u = 10*rand(dim,1) ;
                   cvx_begin
                       variable x(dim)
                       minimize ( (u-x)'*(u-x) )
                       subject to
                             x >= zeros(dim,1)
                             x <= ones(dim,1)
                             x'*ones(dim,1) <= lambda
                   cvx_end
                   xp = ProjectionOnUnitBoxSimplex(u,lambda) ;
                   e = norm(xp - x) ;
                   eHis(cnt) = e ;
               end
               mean(eHis)
               max(eHis)
           case 2    % test C spg solver
               nRepeat = 20 ;
               N = 200 ;
               r = 30 ;
               D = 100 ;
               eHis = zeros(nRepeat,1) ;
               errHis = zeros(nRepeat,1) ;
               minXHis = zeros(nRepeat,2) ;
               f0Hist = zeros(nRepeat,1) ;
               lambda_gen =  10 ;
               lambda_stab = 0.01 ;
               for  cnt=1:nRepeat
                   V = rand(D,N) ;
                   B = rand(D,r) ;
                   w = randn(r,1) ;
                   C0 = rand(r,N) ;
                   [rows,cols,vals] = blockDiag(B'*B,N,0) ;
                   rows = rows + 1 ;    % +1 must be added because C index from zero and MATLAB index from 1
                   cols = cols + 1 ;    % +1 must be added because C index from zero and MATLAB index from 1
                   A = sparse(rows,cols,vals) ;
                   Q = lambda_gen*2*A ;            % it has to be multiplied by 2 because MOSEK has extra 0.5 in its objective
                   Q = Q + lambda_stab*2*speye(r*N) ;
                   % linear term
                   K = V'*B ;
                   [rows,cols,vals] = blockDiag(double(K),N,0) ;
                   rows = rows + 1 ;    % +1 must be added because C index from zero and MATLAB index from 1
                   cols = cols + 1 ;    % +1 must be added because C index from zero and MATLAB index from 1
                   A = sparse(rows,cols,vals) ;
                   tmpeye = speye(N) ;
                   e = -2*tmpeye(:)'*A ;                % linear term. It is equal to  -2*trace(V' B C).
                   e = lambda_gen*e' ;
                   BBMethod = 3 ;
            
                   f = @(x)(0.5*x'*Q*x + e'*x) ;
                   g = @(x)(Q*x + e) ;
                   projFcn = @(x)(max(x,0))  ;
                   x0  = projFcn(C0(:)) ;
                   sol = spg(double(x0), f, g, BBMethod, projFcn,[],[]) ;
                   C = sparse( reshape(sol.par,r,N) );
                   %cvx_begin
                   %      variable   X(r,N)
                   %      minimize( norm(V - B*X,'fro')  )
                   %      subject to
                   %            X(:) >= 0
                   %cvx_end
                   % constraints  (no constraint in this case)
                   blx   = sparse(r*N,1);
                   bux   = [];
                   % linear equality constraints
                   a = speye(r*N) ;
                   blc = [] ;
                   buc = [] ;
                   % Optimize the problem.
                   %[res] = mskqpopt(Q,e,a,blc,buc,blx,bux);
                   prob.c = e ;
                   prob.a = a ;
                   prob.bux = bux ;
                   prob.blx = blx ;
                   prob.buc = buc ;
                   prob.blc = blc ;
                   [prob.qosubi, prob.qosubj, prob.qoval] = find(tril(Q)) ;
                   [rcode,res] = mosekopt('minimize',prob);
                   X = reshape(res.sol.itr.xx,r,N) ;
                   e = norm(X(:) - C(:),inf) ;
                   eHis(cnt) = e ;
                   errHis(cnt) = [f(C(:)) - f(X(:))] ;
                   minXHis(cnt,:) = [min(C(:))   min(X(:)) ]  ;
                   f0Hist(cnt) = f(x0) ;
               end
               eHis 
               errHis
               minXHis
               
           otherwise
               error('this test number is not defined !!!') ;
       end
end