% Read image list in a COMPARE format
%
%       Written by  Kayhan  Batmanghelich
%                   March 2012
%                   Section of Biomedical Image Analysis (SBIA)
%                   University of Pennsylvania


function    [V,y,Dim] = ReadDataFromCOMPAREConfigFile(options)
    %
    addpath(pwd)
    
    nrm_mode =  options.nrm_mode ;
    trainList =  options.Datapath ;
    DownSampleRatio = options.DownSampleRatio ;
    
    [imgList, y, Dim, numTissues, dataRoot] = readImgList(trainList) ;
    y(y==-1) = 2 ;
    [V, Dim] = readImg(imgList,DownSampleRatio) ;
    %V = normalize(V,nrm_mode) ;
end


% read image from List
function [V, Dim] = readImg(imgList,DownSampleRatio) 
    % find out the size of the tensor for memory allocation
    fn = imgList{1,1} ; 
    %img = analyze75read(fn) ;
    [img,hdr] = readMedicalImage(fn) ;
    % check if it is 4D image (fMRI image) or not
    if (ndims(img)==3)   % 3D image
      Dim = size(img) ; 
      if (DownSampleRatio>1)
          xx1 = linspace(1,size(img,1),size(img,1)) ;
          yy1 = linspace(1,size(img,2),size(img,2)) ;
          zz1 = linspace(1,size(img,3),size(img,3)) ;
          xx2 = linspace(1,size(img,1),size(img,1)/DownSampleRatio) ;
          yy2 = linspace(1,size(img,2),size(img,2)/DownSampleRatio) ;
          zz2 = linspace(1,size(img,3),size(img,3)/DownSampleRatio) ;
          [XX1,YY1,ZZ1] = meshgrid(yy1,xx1,zz1) ;
          [XX2,YY2,ZZ2] = meshgrid(yy2,xx2,zz2) ;
          img2 = interp3(XX1,YY1,ZZ1,double(img),XX2,YY2,ZZ2) ;
          img = img2 ;
          Dim = size(img2) ;
      end
      V = zeros([length(img(:)) size(imgList,1)  size(imgList,2)]) ;
      % read in the data into the tensor
      %V = [] ;
      for jj=1:size(imgList,2)
          for ii=1:size(imgList,1)
              fn = imgList{ii,jj} ;
              [img,hdr] = readMedicalImage(fn) ;
              %img = analyze75read(fn) ;
              %Dim = size(img) ;
              if (DownSampleRatio>1)
                xx1 = linspace(1,size(img,1),size(img,1)) ;
                yy1 = linspace(1,size(img,2),size(img,2)) ;
                zz1 = linspace(1,size(img,3),size(img,3)) ;
                xx2 = linspace(1,size(img,1),size(img,1)/DownSampleRatio) ;
                yy2 = linspace(1,size(img,2),size(img,2)/DownSampleRatio) ;
                zz2 = linspace(1,size(img,3),size(img,3)/DownSampleRatio) ;
                [XX1,YY1,ZZ1] = meshgrid(yy1,xx1,zz1) ;
                [XX2,YY2,ZZ2] = meshgrid(yy2,xx2,zz2) ;
                img2 = interp3(XX1,YY1,ZZ1,double(img),XX2,YY2,ZZ2) ;
                img = img2 ;
                %Dim = size(img2) ;
              end
              %V = [V double(img(:))] ;
              V(:,ii,jj) = double(img(:)) ;
          end
      end
    elseif (ndims(img)==4)    %fMRI images
      Dim = size(img) ; 
      if (size(imgList,2)~=1) 
         error('If you provide 4D image, there must be only one image per line; i.e. number tissue must be one !! ') ;
      end
      if (DownSampleRatio>=1)
          [XX1,YY1,ZZ1,TT1] = ndgrid( 1:Dim(1), 1:Dim(2), 1:Dim(3), 1:Dim(4));
          [XX2,YY2,ZZ2,TT2] = ndgrid( 1:DownSampleRatio:Dim(1), 1:DownSampleRatio:Dim(2), 1:DownSampleRatio:Dim(3), 1:Dim(4));
          V = zeros([size(XX2,1)*size(XX2,2)*size(XX2,3)    size(imgList,1)  Dim(4)],'single') ;    % we use float format to save some memory
          Dim = [size(XX2,1) size(XX2,2)  size(XX2,3) ]  ;   % update this variable, I need it later on
      else
          error('Upsampling is not supported, read the documentation !!!!') ;
          %V = zeros([size(img,1)*size(img,2)*size(img,3)    size(imgList,1)  Dim(4)],'single') ;    % we use float format to save some memory
          %Dim = [size(XX2,1)  size(XX2,2)  size(XX2,3) ]  ;   % update this variable, I need it later on
      end
      for ii=1:size(imgList,1)
          fn = imgList{ii,1} ;
          [img,hdr] = readMedicalImage(fn) ;
          img = single(img) ;
          if (DownSampleRatio>1)
             fprintf('Interpolating an image : [%s]  .......',fn) ;
             img2 = interpn(XX1,YY1,ZZ1,TT1,img,XX2,YY2,ZZ2,TT2) ;
             img = single(img2) ;
             fprintf('Done ! \n') ;
          end 
          V(:,ii,:) = reshape(img,[size(V,1) 1 size(V,3)]) ;
      end
    else   % images that 5D and beyond are not supported
       error('images in the list must be either 3D or 4D. Other dimensionalities are not supported !!!') ;
    end
end

% 
function V = normalize(V,mode)
    switch mode,
        case 0,
            % do nothing
        case 1,  % z-score
            for ii=1:length(V,3)
              V_ave = mean(V(:,:,ii),2) ;
              V_std = std(V(:,:,ii),0,2) ;
              V(:,:,ii) = V(:,:,ii) - repmat(V_ave,1,size(V(:,:,ii),2)) ;
              V(:,:,ii) = V(:,:,ii)./repmat(V_std,1,size(V(:,:,ii),2)) ; 
            end
        case 2,  % between [0,1]
            for ii=1:length(V,3)
              v_min     = min(V(:,:,ii),[],2) ;
              V(:,:,ii) = V(:,:,ii) - repmat(v_min,1,size(V(:,:,ii),2)) ;
              v_max     = max(V(:,:,ii),[],2) ;
              v_max(v_max==0) = 1 ;
              V(:,:,ii)   = V(:,:,ii)./ repmat(v_max,1,size(V(:,:,ii),2));
            end
        otherwise,
            error('unknown normalization mode !') ;
            
    end
end



