% this function is just to read COMPARE image list and provide dimension, number of tissue and datarooot
%
%       Written by  Kayhan  Batmanghelich
%                   March 2012
%                   Section of Biomedical Image Analysis (SBIA)
%                   University of Pennsylvania


function [imgList, labels, Dim, numTissues, dataRoot] = readImgList(ListFN) 
    fid = fopen(ListFN,'r') ;
    tline = fgetl(fid) ;
    numImg = sscanf(tline, '%d  %d ') ;
    numTissues = numImg(2) ; 
    numImg = numImg(1) ;
    tline = fgetl(fid) ;
    Dim = sscanf(tline, '%d %d %d') ;
    dataRoot = fgetl(fid) ;
    
    while 1,
        tline = fgetl(fid) ;
        if ~(strcmp('',tline))
            break ;
        end
    end    
    
    templateStruct = [] ;
    for ii=1:numTissues
      templateStruct = [templateStruct '%s '] ;
    end
    templateStruct = [templateStruct '%d'] ; 

    labels = [] ;
    imgList = cell(1,numTissues) ;
    ii = 1 ;
    while 1
        % check for the possible file extensions: .img, .hdr, .gz, .nii
        idx = strfind(tline,'.img') ; 
        if isempty(idx)
            idx1 = strfind(tline,'.hdr') ; 
            idx2 = strfind(tline,'.nii.gz') ; 
            idx3 = strfind(tline,'.nii') ; 
            if (isempty(idx1) && isempty(idx2) && isempty(idx3) )
                error('Are you sure about the extensions of the files you have provided in the list? only .img/.hdr/.nii/.nii.gz are supported !!!') ;
            end
            if ~isempty(idx1)
                idx = idx1 ;     
            elseif ~isempty(idx2)
                idx = idx2 ;     
            else
                idx = idx3 ;     
            end
        end
            
        if (length(idx)~=numTissues)  % sanity check!
              error('are you sure the list file is more than a single channel image !!!') ;
        end
        tmpList = textscan(tline,templateStruct) ;  
        l = tmpList{end} ; 
        for jj=1:numTissues
          imgList{ii,jj} = [ dataRoot '/' tmpList{jj}{1}] ; 
        end
        %for jj=1:numTissues
        %  [fn,count,errmsg,nextIdx] = sscanf(tline(nextIdx:end),'%s',1) ;
        %  tline = tline(nextIdx:end) 
        %  imgList{ii,jj} =  [ dataRoot '/' fn] ;
        %end
        %l = sscaf(tline(nextIdx:end),'%d') ;
        %l = str2double(tline(strfind(tline,'.img')+4:end)) ;
        %imgList{end+1} = [ dataRoot '/' fn] ;
        labels = [labels; l]  ;
        tline = fgetl(fid);
        ii = ii + 1 ;
        if ~ischar(tline),   break,   end     
    end
    %imgList 
    fclose(fid) ;
    
end



