% this function decides what to with the file based on file extension
%
%       Written by  Kayhan  Batmanghelich
%                   March 2012
%                   Section of Biomedical Image Analysis (SBIA)
%                   University of Pennsylvania

function    [img,hdr] = readMedicalImage(fn)
             try   
                abs_fn = absolutepath(fn,'') ;
                [img, origin, spacing] = readmedicalimage_gateway(abs_fn) ;
                hdr.PixelDimensions = spacing ;
                hdr.Dimensions = size(img) ;
                hdr.origin = origin ;
             catch exception
                disp(exception.message);
                fprintf('problem with reading input images :  \n') ; 
                fprintf(['******* fail to read  this file : '  fn  ' \n' ])
             end
end




%%%%%%%%%%%%%%%%%%%%%%%  OLD readMedicalImage function
% function    [img,hdr] = readMedicalImage(fn)
%             [pathstr, name, ext] = fileparts(fn) ;
%             if ( (isequal(ext,'.hdr')) || (isequal(ext,'.img')) )    % it assumes that it is a analyze75 image
%                 img = analyze75read(fn) ;
%                 hdr = analyze75info(fn) ;
%             elseif (isequal(ext,'.gz'))    % it assumes that it is a compressed nii image
%                 img_struct = load_untouch_nii_gz(fn) ;
%                 img = img_struct.img ; 
%                 hdr.Format = 'Nifti' ;
%                 hdr.PixelDimensions = [ img_struct.hdr.dime.pixdim(2:4) 1 ] ;
%                 hdr.Dimensions = img_struct.hdr.dime.dim(2:5) ;
%             elseif (isequal(ext,'.nii'))    % it assumes that it is a uncompressed nii image
%                 img_struct = load_untouch_nii(fn) ;
%                 img = img_struct.img ; 
%                 hdr.Format = 'Nifti' ;
%                 hdr.PixelDimensions = [ img_struct.hdr.dime.pixdim(2:4) 1 ] ;
%                 hdr.Dimensions = img_struct.hdr.dime.dim(2:5) ;
%             else
%                   error(['unknown medical image format: ' ext ]) ;
%             end
% end
