% This function is used to save basis vector as NIFTI images
%
%       Written by  Kayhan  Batmanghelich
%                   March 2012
%                   Section of Biomedical Image Analysis (SBIA)
%                   University of Pennsylvania


function  saveBasis_asImages(ConstVars)
          FeatureFilename = ConstVars.FeatureFilename ;
          if ~exist(FeatureFilename)
              error('The resutl MAT file does not exist, Are you sure you the algorithm ran correctly !!') ;
          end
          load(FeatureFilename,'B') ;
          numChan = size(B,3) ;
          numBasis = size(B,2) ;
          dims = [ConstVars.D1   ConstVars.D2   ConstVars.D3] ;
          trainList =  ConstVars.Datapath ;
          DownSampleRatio = ConstVars.DownSampleRatio ;
          FeatureFilename = ConstVars.FeatureFilename ;
          % read the first image to find out the origin and spacing
          imgList = readImgList(trainList) ;
          %[orgImg,hdr] = readMedicalImage(imgList{1,1}) ;
          abs_fn = absolutepath(imgList{1,1},'') ;
          [orgImg, origin, PixelDimensions, direction] = readmedicalimage_gateway(abs_fn) ;
          orgDirect = reshape(direction,[sqrt(length(direction)) sqrt(length(direction))])' ;
          orgDirect = orgDirect(1:3,1:3) ;    % if the image 4D, we only case about 3D domain
          orgDirect = orgDirect' ;   % converting MATLAB indexing to VNL indexing
          orgDims = [ size(orgImg,1) size(orgImg,2)  size(orgImg,3) ] ;
          origin = origin(1:3) ; 
          spacing = [PixelDimensions(1)  PixelDimensions(2)   PixelDimensions(3) ] ; 
          pathStr =  fileparts(FeatureFilename) ;
          for  chanCnt=1:numChan
               for  rCnt=1:numBasis
                    fn = sprintf('%s/basisImg-Chan%d-Col%d.nii',pathStr,chanCnt,rCnt) ;
                    fprintf('writing the basis -> %s  <- ..... ',fn) ;
                    img =  reshape(full(double(B(:,rCnt,chanCnt))), dims ) ;
                    img = fixImgDimension(img,orgDims,ConstVars) ; 
                    writemedicalimage_gateway(fn, img, origin,spacing,orgDirect(:),'float') ;
                    fprintf('Done !\n') ;
               end
          end
end 


% this function takes care of down-sampling  up-sampling of the original and down-sampled image
function  img = fixImgDimension(img,orgDims,opt)
          DownSampleRatio = opt.DownSampleRatio ;
          if  (DownSampleRatio > 1)
              xx1 = linspace(1,orgDims(1),orgDims(1)) ;
              yy1 = linspace(1,orgDims(2),orgDims(2)) ;
              zz1 = linspace(1,orgDims(3),orgDims(3)) ;
              xx2 = linspace(1,orgDims(1),orgDims(1)/DownSampleRatio) ;
              yy2 = linspace(1,orgDims(2),orgDims(2)/DownSampleRatio) ;
              zz2 = linspace(1,orgDims(3),orgDims(3)/DownSampleRatio) ;
              [XX1,YY1,ZZ1] = meshgrid(yy1,xx1,zz1) ;
              [XX2,YY2,ZZ2] = meshgrid(yy2,xx2,zz2) ;
              img2 = interp3(XX2,YY2,ZZ2,double(img),XX1,YY1,ZZ1) ;
              img = img2 ; 
          elseif (DownSampleRatio == 1)
               if  (size(img)~=orgDims)    % how is that possible !!!
                   error('saveBasis_asImages: downsample is one but original image does not match with basis vector !!') ;
               end
          else
             error('saveBasis_asImages: why down-sampling is more than one, does not make sense !!') ;
          end
end

