%% Initialization
clear
%close all
clc
addpath('/sbia/home/batmangn/code/Projects/GONDOLA-build/bin')
addpath('/sbia/home/batmangn/code/Projects/GONDOLA-build/lib')
addpath('/sbia/home/batmangn/Software/mosek/6/toolbox/r2009b')
addpath('/sbia/home/batmangn/code/Projects/GONDOLA/src')
addpath('/sbia/home/batmangn/Software/liblinear-1.8/matlab')

USPSDataPath = '../data/uspsDigits' ;

% general variables for problem 
global ZSBT ;
ZSBT = 1e-20 ;   %zero substituite
MAXITR = 30 ;
tol =  1e-3 ;
D = 256 ;
ConstVars.lambda_stab = 0.01 ;                 % regularizer for the coefficients
ConstVars.MAXITR = MAXITR  ;                % MAXITR for optimization 
ConstVars.ZSBT = ZSBT ;                     % zero substituite
ConstVars.tol = tol ;                       % tolerance for optimization

% Dataset information
FeatureFilename = 'usps_4_7.mat' ;
DataFcnHandler = @uspsdigits ;
ConstVars.digitsList = {3,5,6,7,8,9} ;   %ConstVars.digitsList = {6,8,9} ;
ConstVars.classID = {'3','5','6','7','8','9'} ;  %ConstVars.classID = {'6','8','9'} ;
ConstVars.numfolds = 2 ; 
ConstVars.foldnum = 1 ;
Ni = 200    ;  % number of samples from each class
ConstVars.numClasses = length(ConstVars.digitsList) ;
N = 0    ;
for classCnt=1:ConstVars.numClasses
    ConstVars.classWeight(classCnt) = 1/Ni ;
    N = N + Ni ;
    ConstVars.numSampleList{classCnt}  = Ni ;	% number of images to be used to derive basis vectors
end
ConstVars.N = N ;   
ConstVars.nullWeight = 1/N ;
ConstVars.downsampleFlag = false ;
ConstVars.Datapath = USPSDataPath ;
ConstVars.pathTodata = USPSDataPath ;
ConstVars.reExtractFeature = true ;
ConstVars.FeatureFilename = FeatureFilename ;
ConstVars.D1 = 16 ;    % x: original image size
ConstVars.D2 = 16 ;    % y: original image size
ConstVars.D = ConstVars.D1*ConstVars.D2 ;
ConstVars.DownSampleRatio = 1 ;
ConstVars.numChannels = 1 ;
ConstVars.saveAfterEachIteration = false ;
ConstVars.randSeed = 0 ;


% options for the Bsolver 
ConstVars.BSolver_opt.BBMethod = 3 ; 

% optimizer parameter
ConstVars.Monitor_Bsol = false ;   % this options monitors the solution for B and if it increases (instead of decrease), returns it back to the old B
ConstVars.Monitor_Csol = false ;   % this options monitors the solution for C and if it increases (instead of decrease), returns it back to the old C

[V,~, ~,~] = feval(DataFcnHandler,ConstVars) ;   
imgLabels = [] ;
for  classCnt=1:ConstVars.numClasses
     imgLabels = [imgLabels ;  classCnt*ones(Ni,1)  ];
end

% creating experiment options
expOption.numRepeat = 10 ;
expOption.numFolds = 10 ;
expOption.TrainIndex = cell(expOption.numRepeat,expOption.numFolds,1) ;
expOption.TestIndex = cell(expOption.numRepeat,expOption.numFolds,1) ;

for expCnt=1:expOption.numRepeat
    randIdx = randperm(ConstVars.N) ;    
    X = V(:,randIdx) ;
    y = imgLabels(randIdx) ;
    for foldCnt=1:expOption.numFolds
        tmpIdx = linspace(0,ConstVars.N,expOption.numFolds+1) ;
        start_index = tmpIdx(foldCnt) + 1 ;
        end_index = tmpIdx(foldCnt + 1) ;
        expOption.TestIndex{expCnt,foldCnt} = randIdx(start_index:end_index) ;
        expOption.TrainIndex{expCnt,foldCnt} = setdiff(randIdx,expOption.TestIndex{expCnt,foldCnt}) ;
    end
end

%save('option6-8-9.mat','V','imgLabels','expOption','ConstVars') ;
save('option3-5-6-7-8-9.mat','V','imgLabels','expOption','ConstVars') ;


