%  This function generate simulated data based on the requested pattern
%
% 
%   [option Name]           [option Value]                                           obligatory ?           
%------------------------------------------------------------------------------------------------------------------------------------------
%   InputList               a full path to the list of input images file              YES (if EffectCode=?)             
%   OutputFile              a full path to a MATLAB file that stores the results      YES
%   MaskImg                 a full path to a mask file                                YES   
%   EffectCode              specify effect code                                       YES
% 
%  simulateBrainEffect   InputList  50CNImageList.lst   OutputFile  result_case1.mat  MaskImg  jakonAtlas.nii.gz    EffectCode    1      




function   simulateBrainEffect(effectCode,matResFn)
           % parse options
           %Args = parseArguments(varargin) ;
           effectCode = str2num(effectCode) ;
           fprintf('effect Code : %d \n',effectCode) ;
           fprintf('matResFn : %s \n',matResFn) ;
 
           % effects
           %effectCode = 2 ;
           switch (effectCode)
              case 1      % simulation on the 3 x 3 box
                   numExpRepeat = 1 ;       % number of repeat for the experiment
                   numSamples = 100 ;
                   noise_std = 0.2 ;
                   blockSz = 10 ;
                   baseMaxVariation = 2 ;
                   baseImgIntensity = 10 ;
                   %lambda_disc_list_coarse = [5e-40   0.00005 0.0005  0.005 0.05 0.06 0.15 0.25 0.37 0.48  0.8 0.85 0.9 2 5 50 500 5e10] ;
                   %lambda_disc_list_fine = linspace(0.1,0.55,20) ;
                   lambda_disc_list_coarse = [5e-40   0.00005 0.0001 0.0005  0.001 0.005 0.05 0.5 5 50 500 5e10] ;
                   
                   
                   A_mean = 4 ;    % avearage of effect A
                   A_std = 0.1 ;   % standard deviation of effect A
                   A_chance = 0.5 ;  % chance of occurance of effect A
                   B_mean = 4 ;    % avearage of effect B
                   B_std = 0.1 ;   % standard deviation of effect B
                   B_chance = 0.5 ;  % chance of occurance of effect B
                   baseImg = [1  4  7 ;...
                              2  5  8 ; ...
                              3  6  9  ] * baseMaxVariation / 9;
                   A_region = [1  1  0; ...
                               1  0  0;...
                               0  0  0] ;
                   B_region = [0  0  0; ...
                               0  0  1;...
                               0  1  1] ;
                          
                   d_matrix_coarse = [] ;
                   d_matrix_fine = [] ;
                   for repCnt=1:numExpRepeat
                       X = zeros((3*blockSz)^2,numSamples)  ;
                       y = zeros(numSamples,1) ;
                       N1 = 0 ;
                       N2 = 0 ;
                       cnt = 1 ;
                       % abnormal group
                       while (cnt<=numSamples/2)
                           noiseImg = noise_std*rand(3*blockSz) ;
                           s_A =  rand < A_chance  ;   %  selector of A_region
                           m_A =  A_mean + A_std*randn ;   % magnitude of the effect in the region A
                           s_B =  rand < B_chance  ;  %  selector of A_region
                           m_B =  B_mean + B_std*randn ;   % magnitude of the effect in the region B
                           noiseImg = noise_std*randn(3*blockSz) ;
                           img = kron(baseImg,ones(blockSz)) + ...
                               kron(A_region,ones(blockSz))*s_A*m_A + ...
                               kron(B_region,ones(blockSz))*s_B*m_B + ...
                               noiseImg ;
                           if ((s_A) || (s_B))    % no effect, it is normal
                               X(:,cnt) = img(:) ;
                               y(cnt) = 1  ;
                               N1 = N1 + 1 ;
                               cnt = cnt + 1;
                           end
                       end
                       % normal group
                       while (cnt<=numSamples)
                           noiseImg = noise_std*randn(3*blockSz) ;
                           img = kron(baseImg,ones(blockSz)) + ...
                               noiseImg ;
                           X(:,cnt) = img(:) ;
                           y(cnt) = 2  ;
                           N2 = N2 + 1 ;
                           cnt = cnt + 1;
                       end
                       N = numSamples ;
                       D = (3*blockSz)^2 ;
                       ConstVars.N = N ;
                       ConstVars.D = D ;
                       ConstVars.r = 10 ;
                       ConstVars.lambda_gen =  10^1 /(N*D) ;                  % weight for Frobinous norm
                       ConstVars.lambda_disc = 0.08;                 % weight for the loss function
                       ConstVars.lambda_const = D*0.3 ;            % RHS of the sparseness term
                       ConstVars.lambda_stab = 0.01 ;                 % regularizer for the coefficients
                       ConstVars.nullWeight = 1/N ;
                       ConstVars.FeatureFilename = matResFn ;
                       ConstVars.D1 = 3*blockSz ;    % x: original image size
                       ConstVars.D2 = 3*blockSz ;    % y: original image size
                       ConstVars.DownSampleRatio = 1 ;
                       ConstVars.numChannels = 1 ;
                       ConstVars.saveAfterEachIteration = false ;
                       ConstVars.randSeed = 0 ;
                       ConstVars.MAXITR = 60  ;                % MAXITR for optimization
                       ConstVars.ZSBT = 1e-20 ;                     % zero substituite
                       ConstVars.tol = 1e-3 ;                       % tolerance for optimization
                       % options for the Bsolver
                       ConstVars.BSolver_opt.BBMethod = 3 ;
                       % optimizer parameter
                       ConstVars.Monitor_Bsol = false ;   % this options monitors the solution for B and if it increases (instead of decrease), returns it back to the old B
                       ConstVars.Monitor_Csol = false ;   % this options monitors the solution for C and if it increases (instead of decrease), returns it back to the old C
                       ConstVars.numClasses = 2 ;
                       ConstVars.classWeight(1) = 1/N1 ;
                       ConstVars.classWeight(2) = 1/N2 ;
                       ConstVars.numSampleList{1}  = N1 ;	% number of images to be used to derive basis vectors
                       ConstVars.numSampleList{2}  = N2 ;	% number of images to be used to derive basis vectors
                       
                       % Same preprocessing as Stan Li et al
                       minval = min(X);
                       X = X - ones(size(X,1),1)*minval;
                       maxval = max(X);
                       X = (X*255) ./ (ones(size(X,1),1)*maxval);
                       
                       % Additionally, this is required to avoid having any exact zeros:
                       % (divergence objective cannot handle them!)
                       X = max(X,1e-4);
                       
                       % Finally, divide by 10000 to avoid too large values for nmfsc algorithm
                       %X = X/10000;
                       
                       Data.V = X ;
                       Data.y = y ;
                       ConstVars.N = size(Data.V,2) ;
                       % create constant matrices
                       Data.W0 = rand(ConstVars.D,ConstVars.r) ;
                       Data.W0 = Data.W0./repmat(sum(Data.W0),ConstVars.D,1)*ConstVars.lambda_const/2 ;   % to make initialization feasible
                       Data.H0 = rand(ConstVars.r,ConstVars.N) ;
                       Data.w0 = randn(ConstVars.r,1) ;
                       
                       IA = kron(A_region,ones(blockSz)) ;
                       IB = kron(B_region,ones(blockSz)) ;
                       d_list_coarse = [] ;
                       for lambda_disc = lambda_disc_list_coarse
                           ConstVars.lambda_disc = lambda_disc
                           [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                           dA = min( sum((B-repmat(IA(:),1,ConstVars.r)).^2)  );
                           dB = min( sum((B-repmat(IB(:),1,ConstVars.r)).^2)  );
                           d_list_coarse = [d_list_coarse; dA + dB] ;
                       end
                       d_matrix_coarse = [d_matrix_coarse  d_list_coarse] ;
                       
                       %d_list_fine = [] ;
                       %for lambda_disc = lambda_disc_list_fine
                       %    ConstVars.lambda_disc = lambda_disc
                       %    [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                       %    dA = min( sum((B-repmat(IA(:),1,ConstVars.r)).^2)  );
                       %    dB = min( sum((B-repmat(IB(:),1,ConstVars.r)).^2)  );
                       %    d_list_fine = [d_list_fine; dA + dB] ;
                       %end
                       %d_matrix_fine = [d_matrix_fine  d_list_fine] ;
                       
                   end
                   plot(log(lambda_disc_list_coarse(1:end-2)),d_list_coarse(1:end-2))
                   %plot(log(lambda_disc_list),d_list_coarse)
                   
                   %close all
                   %figure;plot(Report.Obj_Hist) ;
                   %figure;nmf_ShowBasis(B,ConstVars) ;
                   %figure;plot(Report.Terms_Hist(1,:))
                   %figure;plot(Report.Terms_Hist(2,:))
                   %figure;plot(Report.Terms_Hist(3,:))
                   %Report.Obj_Hist(end)
                   %figure;imagesc(reshape(B*abs(w(1:end-1)),[3*blockSz 3*blockSz]))
              case 2
                   numExpRepeat = 10 ;       % number of repeat for the experiment
                   numSamples = 100 ;
                   noise_max = 0.01 ;
                   blockSz = 10 ;
                   lambda_disc_list_coarse = [5e-10   0.00005 0.0005  0.005 0.05 0.5 5 50 500 5e10] ;
                   effect_mean_list = [0.1  0.5  1  2   ] ;
                   
                   distr_type = 'uniform' ;   % if uniform, it uses uniform distribution and A_mean is used as maximum
                   
                   A_std = 0.1 ;   % standard deviation of effect A
                   A_chance = 0.5 ;  % chance of occurance of effect A
                   B_std = 0.1 ;   % standard deviation of effect B
                   B_chance = 0.5 ;  % chance of occurance of effect B
                   b1_mean = 2 ;   % mean coeff for b1
                   b1_std = 0.1 ;   % standard deviation of effect b1
                   b2_mean = 2 ;   % mean effect of coeff for b2
                   b2_std = 0.1 ;   % standard deviation of effect b2
                   b3_mean = 2 ;   % mean effect of coeff for b3
                   b3_std = 0.1 ;   % standard deviation of effect b3
                   normal_b1 = [1  0  0 ;...
                                1  0  0 ; ...
                                1  0  0  ] ;   % normal basis : 1
                   normal_b2 = [0  1  0 ;...
                                0  1  0 ; ...
                                0  1  0  ] ;   % normal basis : 2
                   normal_b3 = [0  0  1 ;...
                                0  0  1 ; ...
                                0  0  1  ] ;   % normal basis : 3
                   A_region = [1  1  0; ...
                               1  0  0;...
                               0  0  0] ;
                   B_region = [0  0  0; ...
                               0  0  1;...
                               0  1  1] ;
                          
                   d_tensor_coarse = zeros(length(effect_mean_list),numExpRepeat,length(lambda_disc_list_coarse))  ;
                   d_tensor_fine = [] ;
                   for effCnt=1:length(effect_mean_list)
                       A_mean = effect_mean_list(effCnt) ;    % avearage of effect A
                       B_mean = effect_mean_list(effCnt) ;    % avearage of effect B
                       for repCnt=1:numExpRepeat
                           X = zeros((3*blockSz)^2,numSamples)  ;
                           y = zeros(numSamples,1) ;
                           N1 = 0 ;
                           N2 = 0 ;
                           cnt = 1 ;
                           % abnormal group
                           while (cnt<=numSamples/2)
                               p = rand(3,1); p = (p > min(p)) ;
                               s_1 = p(1) ;
                               s_2 = p(2) ;
                               s_3 = p(3) ;
                               if strcmp(distr_type,'uniform')
                                   m_1 =  b1_mean*rand  ;   % magnitude of the effect in the b1
                                   m_2 =  b2_mean*rand ;   % magnitude of the effect in the b2
                                   m_3 =  b3_mean*rand ;   % magnitude of the effect in the b3
                                   m_A =  A_mean*rand  ;   % magnitude of the effect in the region A
                                   m_B =  B_mean*rand  ;   % magnitude of the effect in the region B
                               elseif strcmp(distr_type,'gaussian')
                                   m_1 =  b1_std*randn + b1_mean ;   % magnitude of the effect in the b1
                                   m_2 =  b2_std*randn + b2_mean ;   % magnitude of the effect in the b2
                                   m_3 =  b3_std*randn + b3_mean ;   % magnitude of the effect in the b3
                                   m_A =  A_std*randn + A_mean ;   % magnitude of the effect in the region A
                                   m_B =  B_std*randn + B_mean ;   % magnitude of the effect in the region B
                               end
                               
                               s_A =  rand < A_chance  ;   %  selector of A_region
                               s_B =  rand < B_chance  ;  %  selector of A_region
                               noiseImg = noise_max*rand(3*blockSz) ;
                               img = kron(normal_b1,ones(blockSz))*s_1*m_1 + ...
                                   kron(normal_b2,ones(blockSz))*s_2*m_2 + ...
                                   kron(normal_b3,ones(blockSz))*s_3*m_3 + ...
                                   kron(A_region,ones(blockSz))*s_A*m_A + ...
                                   kron(B_region,ones(blockSz))*s_B*m_B + ...
                                   noiseImg ;
                               if ((s_A) || (s_B))    % no effect, it is normal
                                   X(:,cnt) = img(:) ;
                                   y(cnt) = 1  ;
                                   N1 = N1 + 1 ;
                                   cnt = cnt + 1;
                               end
                           end
                           % normal group
                           while (cnt<=numSamples)
                               noiseImg = noise_max*rand(3*blockSz) ;
                               img = kron(normal_b1,ones(blockSz))*s_1*m_1 + ...
                                   kron(normal_b2,ones(blockSz))*s_2*m_2 + ...
                                   kron(normal_b3,ones(blockSz))*s_3*m_3 + ...
                                   noiseImg ;
                               X(:,cnt) = img(:) ;
                               y(cnt) = 2  ;
                               N2 = N2 + 1 ;
                               cnt = cnt + 1;
                           end
                           N = numSamples ;
                           D = (3*blockSz)^2 ;
                           ConstVars.N = N ;
                           ConstVars.D = D ;
                           ConstVars.r = 10 ;
                           ConstVars.lambda_gen =  10^1 /(N*D) ;                  % weight for Frobinous norm
                           ConstVars.lambda_disc = 0.08;                 % weight for the loss function
                           ConstVars.lambda_const = D*0.3 ;            % RHS of the sparseness term
                           ConstVars.lambda_stab = 0.01 ;                 % regularizer for the coefficients
                           ConstVars.nullWeight = 1/N ;
                           ConstVars.FeatureFilename = matResFn ;
                           ConstVars.D1 = 3*blockSz ;    % x: original image size
                           ConstVars.D2 = 3*blockSz ;    % y: original image size
                           ConstVars.DownSampleRatio = 1 ;
                           ConstVars.numChannels = 1 ;
                           ConstVars.saveAfterEachIteration = false ;
                           ConstVars.randSeed = repCnt ;
                           ConstVars.MAXITR = 60  ;                % MAXITR for optimization
                           ConstVars.ZSBT = 1e-20 ;                     % zero substituite
                           ConstVars.tol = 1e-3 ;                       % tolerance for optimization
                           % options for the Bsolver
                           ConstVars.BSolver_opt.BBMethod = 3 ;
                           % optimizer parameter
                           ConstVars.Monitor_Bsol = false ;   % this options monitors the solution for B and if it increases (instead of decrease), returns it back to the old B
                           ConstVars.Monitor_Csol = false ;   % this options monitors the solution for C and if it increases (instead of decrease), returns it back to the old C
                           ConstVars.numClasses = 2 ;
                           ConstVars.classWeight(1) = 1/N1 ;
                           ConstVars.classWeight(2) = 1/N2 ;
                           ConstVars.numSampleList{1}  = N1 ;	% number of images to be used to derive basis vectors
                           ConstVars.numSampleList{2}  = N2 ;	% number of images to be used to derive basis vectors
                           
                           % Same preprocessing as Stan Li et al
                           minval = min(X);
                           X = X - ones(size(X,1),1)*minval;
                           maxval = max(X);
                           X = (X*255) ./ (ones(size(X,1),1)*maxval);
                           
                           % Additionally, this is required to avoid having any exact zeros:
                           % (divergence objective cannot handle them!)
                           %X = max(X,1e-4);
                           
                           % Finally, divide by 10000 to avoid too large values for nmfsc algorithm
                           %X = X/10000;
                           
                           Data.V = X ;
                           Data.y = y ;
                           ConstVars.N = size(Data.V,2) ;
                           % create constant matrices
                           Data.W0 = rand(ConstVars.D,ConstVars.r) ;
                           Data.W0 = Data.W0./repmat(sum(Data.W0),ConstVars.D,1)*ConstVars.lambda_const/2 ;   % to make initialization feasible
                           Data.H0 = rand(ConstVars.r,ConstVars.N) ;
                           Data.w0 = randn(ConstVars.r,1) ;
                           
                           IA = kron(A_region,ones(blockSz)) ;
                           IB = kron(B_region,ones(blockSz)) ;
                           d_list_coarse = [] ;
                           for lambda_disc = lambda_disc_list_coarse
                               ConstVars.lambda_disc = lambda_disc
                               [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                               dA = min( sum((B-repmat(IA(:),1,ConstVars.r)).^2)  );
                               dB = min( sum((B-repmat(IB(:),1,ConstVars.r)).^2)  );
                               d_list_coarse = [d_list_coarse; dA + dB] ;
                           end
                           %d_matrix_coarse = [d_matrix_coarse  d_list_coarse] ;
                           d_tensor_coarse(effCnt,repCnt,:) = d_list_coarse(:) ;
                           
                           %d_list_fine = [] ;
                           %for lambda_disc = lambda_disc_list_fine
                           %    ConstVars.lambda_disc = lambda_disc
                           %    [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                           %    dA = min( sum((B-repmat(IA(:),1,ConstVars.r)).^2)  );
                           %    dB = min( sum((B-repmat(IB(:),1,ConstVars.r)).^2)  );
                           %    d_list_fine = [d_list_fine; dA + dB] ;
                           %end
                           %d_matrix_fine = [d_matrix_fine  d_list_fine] ;
                           
                       end
                       %figure
                       %plot(log(lambda_disc_list_coarse),mean(d_matrix_coarse,2),...
                       %                '--rs','LineWidth',2,...
                       %                'MarkerEdgeColor','k',...
                       %                'MarkerFaceColor','g',...
                       %                'MarkerSize',10)
                       %axis([-20   20  0  20 ])
                       %grid on
                       %figure
                       %errorbar(log(lambda_disc_list_coarse),mean(d_matrix_coarse,2),std(d_matrix_coarse,[],2),...
                       %                '--rs','LineWidth',2,...
                       %                'MarkerEdgeColor','k',...
                       %                'MarkerFaceColor','g',...
                       %                'MarkerSize',10)
                       %axis([-50   20  0  20 ])
                       %grid on
                       save(ConstVars.FeatureFilename,'d_tensor_coarse','ConstVars','lambda_disc_list_coarse','effect_mean_list') ;
                   end
                   
              case 3
                   numExpRepeat = 50 ;       % number of repeat for the experiment
                   numSamples = 100 ;
                   noise_max = 0.01 ;
                   blockSz = 10 ;
                   lambda_disc_list_coarse = [5e-10   0.00005 0.0005  0.005 0.05 0.5 5 50 500 5e10] ;
                   effect_mean_list = [0.1  0.5  1  2   ] ;
                   
                   distr_type = 'uniform' ;   % if uniform, it uses uniform distribution and A_mean is used as maximum
                   
                   A_std = 0.1 ;   % standard deviation of effect A
                   A_chance = 0.5 ;  % chance of occurance of effect A
                   B_std = 0.1 ;   % standard deviation of effect B
                   B_chance = 0.5 ;  % chance of occurance of effect B
                   b1_mean = 2 ;   % mean coeff for b1
                   b1_std = 0.1 ;   % standard deviation of effect b1
                   b2_mean = 2 ;   % mean effect of coeff for b2
                   b2_std = 0.1 ;   % standard deviation of effect b2
                   b3_mean = 2 ;   % mean effect of coeff for b3
                   b3_std = 0.1 ;   % standard deviation of effect b3
                   normal_b1 = [1  0  0 ;...
                                1  0  0 ; ...
                                1  0  0  ] ;   % normal basis : 1
                   normal_b2 = [0  1  0 ;...
                                0  1  0 ; ...
                                0  1  0  ] ;   % normal basis : 2
                   normal_b3 = [0  0  1 ;...
                                0  0  1 ; ...
                                0  0  1  ] ;   % normal basis : 3
                   A_region = [1  1  1; ...
                               0  0  0;...
                               0  0  0] ;
                   B_region = [0  0  0; ...
                               0  0  0;...
                               1  1  1] ;
                          
                   d_tensor_coarse = zeros(length(effect_mean_list),numExpRepeat,length(lambda_disc_list_coarse))  ;
                   d_tensor_fine = [] ;
                   for effCnt=1:length(effect_mean_list)
                       A_mean = effect_mean_list(effCnt) ;    % avearage of effect A
                       B_mean = effect_mean_list(effCnt) ;    % avearage of effect B
                       for repCnt=1:numExpRepeat
                           X = zeros((3*blockSz)^2,numSamples)  ;
                           y = zeros(numSamples,1) ;
                           N1 = 0 ;
                           N2 = 0 ;
                           cnt = 1 ;
                           % abnormal group
                           while (cnt<=numSamples/2)
                               p = rand(3,1); p = (p > min(p)) ;
                               s_1 = p(1) ;
                               s_2 = p(2) ;
                               s_3 = p(3) ;
                               if strcmp(distr_type,'uniform')
                                   m_1 =  b1_mean*rand  ;   % magnitude of the effect in the b1
                                   m_2 =  b2_mean*rand ;   % magnitude of the effect in the b2
                                   m_3 =  b3_mean*rand ;   % magnitude of the effect in the b3
                                   m_A =  A_mean*rand  ;   % magnitude of the effect in the region A
                                   m_B =  B_mean*rand  ;   % magnitude of the effect in the region B
                               elseif strcmp(distr_type,'gaussian')
                                   m_1 =  b1_std*randn + b1_mean ;   % magnitude of the effect in the b1
                                   m_2 =  b2_std*randn + b2_mean ;   % magnitude of the effect in the b2
                                   m_3 =  b3_std*randn + b3_mean ;   % magnitude of the effect in the b3
                                   m_A =  A_std*randn + A_mean ;   % magnitude of the effect in the region A
                                   m_B =  B_std*randn + B_mean ;   % magnitude of the effect in the region B
                               end
                               
                               s_A =  rand < A_chance  ;   %  selector of A_region
                               s_B =  rand < B_chance  ;  %  selector of A_region
                               noiseImg = noise_max*rand(3*blockSz) ;
                               img = kron(normal_b1,ones(blockSz))*s_1*m_1 + ...
                                   kron(normal_b2,ones(blockSz))*s_2*m_2 + ...
                                   kron(normal_b3,ones(blockSz))*s_3*m_3 + ...
                                   kron(A_region,ones(blockSz))*s_A*m_A + ...
                                   kron(B_region,ones(blockSz))*s_B*m_B + ...
                                   noiseImg ;
                               if ((s_A) || (s_B))    % no effect, it is normal
                                   X(:,cnt) = img(:) ;
                                   y(cnt) = 1  ;
                                   N1 = N1 + 1 ;
                                   cnt = cnt + 1;
                               end
                           end
                           % normal group
                           while (cnt<=numSamples)
                               noiseImg = noise_max*rand(3*blockSz) ;
                               img = kron(normal_b1,ones(blockSz))*s_1*m_1 + ...
                                   kron(normal_b2,ones(blockSz))*s_2*m_2 + ...
                                   kron(normal_b3,ones(blockSz))*s_3*m_3 + ...
                                   noiseImg ;
                               X(:,cnt) = img(:) ;
                               y(cnt) = 2  ;
                               N2 = N2 + 1 ;
                               cnt = cnt + 1;
                           end
                           N = numSamples ;
                           D = (3*blockSz)^2 ;
                           ConstVars.N = N ;
                           ConstVars.D = D ;
                           ConstVars.r = 10 ;
                           ConstVars.lambda_gen =  10^1 /(N*D) ;                  % weight for Frobinous norm
                           ConstVars.lambda_disc = 0.08;                 % weight for the loss function
                           ConstVars.lambda_const = D*0.3 ;            % RHS of the sparseness term
                           ConstVars.lambda_stab = 0.01 ;                 % regularizer for the coefficients
                           ConstVars.nullWeight = 1/N ;
                           ConstVars.FeatureFilename = matResFn ;
                           ConstVars.D1 = 3*blockSz ;    % x: original image size
                           ConstVars.D2 = 3*blockSz ;    % y: original image size
                           ConstVars.DownSampleRatio = 1 ;
                           ConstVars.numChannels = 1 ;
                           ConstVars.saveAfterEachIteration = false ;
                           ConstVars.randSeed = repCnt ;
                           ConstVars.MAXITR = 60  ;                % MAXITR for optimization
                           ConstVars.ZSBT = 1e-20 ;                     % zero substituite
                           ConstVars.tol = 1e-3 ;                       % tolerance for optimization
                           % options for the Bsolver
                           ConstVars.BSolver_opt.BBMethod = 3 ;
                           % optimizer parameter
                           ConstVars.Monitor_Bsol = false ;   % this options monitors the solution for B and if it increases (instead of decrease), returns it back to the old B
                           ConstVars.Monitor_Csol = false ;   % this options monitors the solution for C and if it increases (instead of decrease), returns it back to the old C
                           ConstVars.numClasses = 2 ;
                           ConstVars.classWeight(1) = 1/N1 ;
                           ConstVars.classWeight(2) = 1/N2 ;
                           ConstVars.numSampleList{1}  = N1 ;	% number of images to be used to derive basis vectors
                           ConstVars.numSampleList{2}  = N2 ;	% number of images to be used to derive basis vectors
                           
                           % Same preprocessing as Stan Li et al
                           minval = min(X);
                           X = X - ones(size(X,1),1)*minval;
                           maxval = max(X);
                           X = (X*255) ./ (ones(size(X,1),1)*maxval);
                           
                           % Additionally, this is required to avoid having any exact zeros:
                           % (divergence objective cannot handle them!)
                           %X = max(X,1e-4);
                           
                           % Finally, divide by 10000 to avoid too large values for nmfsc algorithm
                           %X = X/10000;
                           
                           Data.V = X ;
                           Data.y = y ;
                           ConstVars.N = size(Data.V,2) ;
                           % create constant matrices
                           Data.W0 = rand(ConstVars.D,ConstVars.r) ;
                           Data.W0 = Data.W0./repmat(sum(Data.W0),ConstVars.D,1)*ConstVars.lambda_const/2 ;   % to make initialization feasible
                           Data.H0 = rand(ConstVars.r,ConstVars.N) ;
                           Data.w0 = randn(ConstVars.r,1) ;
                           
                           IA = kron(A_region,ones(blockSz)) ;
                           IB = kron(B_region,ones(blockSz)) ;
                           d_list_coarse = [] ;
                           for lambda_disc = lambda_disc_list_coarse
                               ConstVars.lambda_disc = lambda_disc
                               [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                               dA = min( sum((B-repmat(IA(:),1,ConstVars.r)).^2)  );
                               dB = min( sum((B-repmat(IB(:),1,ConstVars.r)).^2)  );
                               d_list_coarse = [d_list_coarse; dA + dB] ;
                           end
                           %d_matrix_coarse = [d_matrix_coarse  d_list_coarse] ;
                           d_tensor_coarse(effCnt,repCnt,:) = d_list_coarse(:) ;
                           
                           %d_list_fine = [] ;
                           %for lambda_disc = lambda_disc_list_fine
                           %    ConstVars.lambda_disc = lambda_disc
                           %    [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                           %    dA = min( sum((B-repmat(IA(:),1,ConstVars.r)).^2)  );
                           %    dB = min( sum((B-repmat(IB(:),1,ConstVars.r)).^2)  );
                           %    d_list_fine = [d_list_fine; dA + dB] ;
                           %end
                           %d_matrix_fine = [d_matrix_fine  d_list_fine] ;
                           
                       end
                       %figure
                       %plot(log(lambda_disc_list_coarse),mean(d_matrix_coarse,2),...
                       %                '--rs','LineWidth',2,...
                       %                'MarkerEdgeColor','k',...
                       %                'MarkerFaceColor','g',...
                       %                'MarkerSize',10)
                       %axis([-20   20  0  20 ])
                       %grid on
                       %figure
                       %errorbar(log(lambda_disc_list_coarse),mean(d_matrix_coarse,2),std(d_matrix_coarse,[],2),...
                       %                '--rs','LineWidth',2,...
                       %                'MarkerEdgeColor','k',...
                       %                'MarkerFaceColor','g',...
                       %                'MarkerSize',10)
                       %axis([-50   20  0  20 ])
                       %grid on
                       save(ConstVars.FeatureFilename,'d_tensor_coarse','ConstVars','lambda_disc_list_coarse','effect_mean_list') ;
                   end
 

              case 4
                   numExpRepeat = 30 ;       % number of repeat for the experiment
                   numSamples = 100 ;
                   numTestSamples = 100 ;
                   noise_max = 0.01 ;
                   blockSz = 10 ;
                   lambda_disc_list_coarse = [5e-10   0.00005 0.0005  0.005 0.05 0.5 5 50 500 5e10] ;
                   effect_mean_list = [0.1  0.5  1  2   ] ;
                   
                   distr_type = 'uniform' ;   % if uniform, it uses uniform distribution and A_mean is used as maximum
                   
                   A_std = 0.1 ;   % standard deviation of effect A
                   A_chance = 0.5 ;  % chance of occurance of effect A
                   B_std = 0.1 ;   % standard deviation of effect B
                   B_chance = 0.5 ;  % chance of occurance of effect B
                   b1_mean = 2 ;   % mean coeff for b1
                   b1_std = 0.1 ;   % standard deviation of effect b1
                   b2_mean = 2 ;   % mean effect of coeff for b2
                   b2_std = 0.1 ;   % standard deviation of effect b2
                   b3_mean = 2 ;   % mean effect of coeff for b3
                   b3_std = 0.1 ;   % standard deviation of effect b3
                   normal_b1 = [1  0  0 ;...
                                1  0  0 ; ...
                                1  0  0  ] ;   % normal basis : 1
                   normal_b2 = [0  1  0 ;...
                                0  1  0 ; ...
                                0  1  0  ] ;   % normal basis : 2
                   normal_b3 = [0  0  1 ;...
                                0  0  1 ; ...
                                0  0  1  ] ;   % normal basis : 3
                   A_region = [1  1  1; ...
                               0  0  0;...
                               0  0  0] ;
                   B_region = [0  0  0; ...
                               0  0  0;...
                               1  1  1] ;
                          
                   d_tensor_coarse = zeros(length(effect_mean_list),numExpRepeat,length(lambda_disc_list_coarse))  ;
                   acc_tensor_coarse = zeros(length(effect_mean_list),numExpRepeat,length(lambda_disc_list_coarse))  ;
                   d_tensor_fine = [] ;
                   for effCnt=1:length(effect_mean_list)
                       A_mean = effect_mean_list(effCnt) ;    % avearage of effect A
                       B_mean = effect_mean_list(effCnt) ;    % avearage of effect B
                       for repCnt=1:numExpRepeat
                           X = zeros((3*blockSz)^2,numSamples)  ;
                           y = zeros(numSamples,1) ;
                           N1 = 0 ;
                           N2 = 0 ;
                           cnt = 1 ;
                           % abnormal group
                           while (cnt<=numSamples/2)
                               p = rand(3,1); p = (p > min(p)) ;
                               s_1 = p(1) ;
                               s_2 = p(2) ;
                               s_3 = p(3) ;
                               if strcmp(distr_type,'uniform')
                                   m_1 =  b1_mean*rand  ;   % magnitude of the effect in the b1
                                   m_2 =  b2_mean*rand ;   % magnitude of the effect in the b2
                                   m_3 =  b3_mean*rand ;   % magnitude of the effect in the b3
                                   m_A =  A_mean*rand  ;   % magnitude of the effect in the region A
                                   m_B =  B_mean*rand  ;   % magnitude of the effect in the region B
                               elseif strcmp(distr_type,'gaussian')
                                   m_1 =  b1_std*randn + b1_mean ;   % magnitude of the effect in the b1
                                   m_2 =  b2_std*randn + b2_mean ;   % magnitude of the effect in the b2
                                   m_3 =  b3_std*randn + b3_mean ;   % magnitude of the effect in the b3
                                   m_A =  A_std*randn + A_mean ;   % magnitude of the effect in the region A
                                   m_B =  B_std*randn + B_mean ;   % magnitude of the effect in the region B
                               end
                               
                               s_A =  rand < A_chance  ;   %  selector of A_region
                               s_B =  rand < B_chance  ;  %  selector of A_region
                               noiseImg = noise_max*rand(3*blockSz) ;
                               img = kron(normal_b1,ones(blockSz))*s_1*m_1 + ...
                                   kron(normal_b2,ones(blockSz))*s_2*m_2 + ...
                                   kron(normal_b3,ones(blockSz))*s_3*m_3 + ...
                                   kron(A_region,ones(blockSz))*s_A*m_A + ...
                                   kron(B_region,ones(blockSz))*s_B*m_B + ...
                                   noiseImg ;
                               if ((s_A) || (s_B))    % no effect, it is normal
                                   X(:,cnt) = img(:) ;
                                   y(cnt) = 1  ;
                                   N1 = N1 + 1 ;
                                   cnt = cnt + 1;
                               end
                           end 
                           % normal group
                           while (cnt<=numSamples)
                               noiseImg = noise_max*rand(3*blockSz) ;
                               img = kron(normal_b1,ones(blockSz))*s_1*m_1 + ...
                                   kron(normal_b2,ones(blockSz))*s_2*m_2 + ...
                                   kron(normal_b3,ones(blockSz))*s_3*m_3 + ...
                                   noiseImg ;
                               X(:,cnt) = img(:) ;
                               y(cnt) = 2  ;
                               N2 = N2 + 1 ;
                               cnt = cnt + 1;
                           end
                           %--------------   generating test data : BEGIN
                           cnt = 1 ;
                           XTest = zeros((3*blockSz)^2,numTestSamples) ;
                           yTest  = zeros(numTestSamples,1) ;
                           N1Test = 0 ;
                           N2Test = 0 ;
                           while (cnt<=numTestSamples/2)
                               p = rand(3,1); p = (p > min(p)) ;
                               s_1 = p(1) ;
                               s_2 = p(2) ;
                               s_3 = p(3) ;
                               if strcmp(distr_type,'uniform')
                                   m_1 =  b1_mean*rand  ;   % magnitude of the effect in the b1
                                   m_2 =  b2_mean*rand ;   % magnitude of the effect in the b2
                                   m_3 =  b3_mean*rand ;   % magnitude of the effect in the b3
                                   m_A =  A_mean*rand  ;   % magnitude of the effect in the region A
                                   m_B =  B_mean*rand  ;   % magnitude of the effect in the region B
                               elseif strcmp(distr_type,'gaussian')
                                   m_1 =  b1_std*randn + b1_mean ;   % magnitude of the effect in the b1
                                   m_2 =  b2_std*randn + b2_mean ;   % magnitude of the effect in the b2
                                   m_3 =  b3_std*randn + b3_mean ;   % magnitude of the effect in the b3
                                   m_A =  A_std*randn + A_mean ;   % magnitude of the effect in the region A
                                   m_B =  B_std*randn + B_mean ;   % magnitude of the effect in the region B
                               end
                               
                               s_A =  rand < A_chance  ;   %  selector of A_region
                               s_B =  rand < B_chance  ;  %  selector of A_region
                               noiseImg = noise_max*rand(3*blockSz) ;
                               img = kron(normal_b1,ones(blockSz))*s_1*m_1 + ...
                                   kron(normal_b2,ones(blockSz))*s_2*m_2 + ...
                                   kron(normal_b3,ones(blockSz))*s_3*m_3 + ...
                                   kron(A_region,ones(blockSz))*s_A*m_A + ...
                                   kron(B_region,ones(blockSz))*s_B*m_B + ...
                                   noiseImg ;
                               if ((s_A) || (s_B))    % no effect, it is normal
                                   XTest(:,cnt) = img(:) ;
                                   yTest(cnt) = 1  ;
                                   N1Test = N1Test + 1 ;
                                   cnt = cnt + 1;
                               end
                           end 
                           % normal group
                           while (cnt<=numTestSamples)
                               noiseImg = noise_max*rand(3*blockSz) ;
                               img = kron(normal_b1,ones(blockSz))*s_1*m_1 + ...
                                   kron(normal_b2,ones(blockSz))*s_2*m_2 + ...
                                   kron(normal_b3,ones(blockSz))*s_3*m_3 + ...
                                   noiseImg ;
                               XTest(:,cnt) = img(:) ;
                               yTest(cnt) = 2  ;
                               N2Test = N2Test + 1 ;
                               cnt = cnt + 1;
                           end
                           %--------------   generating test data : END
                           N = numSamples ;
                           D = (3*blockSz)^2 ;
                           ConstVars.N = N ;
                           ConstVars.D = D ;
                           ConstVars.r = 10 ;
                           ConstVars.lambda_gen =  10^1 /(N*D) ;                  % weight for Frobinous norm
                           ConstVars.lambda_disc = 0.08;                 % weight for the loss function
                           ConstVars.lambda_const = D*0.3 ;            % RHS of the sparseness term
                           ConstVars.lambda_stab = 0.01 ;                 % regularizer for the coefficients
                           ConstVars.nullWeight = 1/N ;
                           ConstVars.FeatureFilename = matResFn ;
                           ConstVars.D1 = 3*blockSz ;    % x: original image size
                           ConstVars.D2 = 3*blockSz ;    % y: original image size
                           ConstVars.DownSampleRatio = 1 ;
                           ConstVars.numChannels = 1 ;
                           ConstVars.saveAfterEachIteration = false ;
                           ConstVars.randSeed = repCnt ;
                           ConstVars.MAXITR = 60  ;                % MAXITR for optimization
                           ConstVars.ZSBT = 1e-20 ;                     % zero substituite
                           ConstVars.tol = 1e-3 ;                       % tolerance for optimization
                           % options for the Bsolver
                           ConstVars.BSolver_opt.BBMethod = 3 ;
                           % optimizer parameter
                           ConstVars.Monitor_Bsol = false ;   % this options monitors the solution for B and if it increases (instead of decrease), returns it back to the old B
                           ConstVars.Monitor_Csol = false ;   % this options monitors the solution for C and if it increases (instead of decrease), returns it back to the old C
                           ConstVars.numClasses = 2 ;
                           ConstVars.classWeight(1) = 1/N1 ;
                           ConstVars.classWeight(2) = 1/N2 ;
                           ConstVars.numSampleList{1}  = N1 ;	% number of images to be used to derive basis vectors
                           ConstVars.numSampleList{2}  = N2 ;	% number of images to be used to derive basis vectors
                           
                           % Same preprocessing as Stan Li et al
                           minval = min(X);
                           X = X - ones(size(X,1),1)*minval;
                           XTest = XTest - ones(size(XTest,1),1)*minval;
                           maxval = max(X);
                           X = (X*255) ./ (ones(size(X,1),1)*maxval);
                           XTest = (XTest*255) ./ (ones(size(XTest,1),1)*maxval);

                           
                           % Additionally, this is required to avoid having any exact zeros:
                           % (divergence objective cannot handle them!)
                           %X = max(X,1e-4);
                           
                           % Finally, divide by 10000 to avoid too large values for nmfsc algorithm
                           %X = X/10000;
                           
                           Data.V = X ;
                           Data.y = y ;
                           ConstVars.N = size(Data.V,2) ;
                           % create constant matrices
                           Data.W0 = rand(ConstVars.D,ConstVars.r) ;
                           Data.W0 = Data.W0./repmat(sum(Data.W0),ConstVars.D,1)*ConstVars.lambda_const/2 ;   % to make initialization feasible
                           Data.H0 = rand(ConstVars.r,ConstVars.N) ;
                           Data.w0 = randn(ConstVars.r,1) ;
                           
                           IA = kron(A_region,ones(blockSz)) ;
                           IB = kron(B_region,ones(blockSz)) ;
                           d_list_coarse = [] ;
                           acc_list_coarse = [] ;
                           for lambda_disc = lambda_disc_list_coarse
                               ConstVars.lambda_disc = lambda_disc
                               [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                               % compute distance between actual effect and computed basis
                               dA = min( sum((B-repmat(IA(:),1,ConstVars.r)).^2)  );
                               dB = min( sum((B-repmat(IB(:),1,ConstVars.r)).^2)  );
                               d_list_coarse = [d_list_coarse; dA + dB] ;
                               % compute cross validation accuracy
                               model = train(y, sparse(X'*B), '-c 1');
                               [predict_label, accuracy, dec_values] = predict(yTest, sparse(XTest'*B), model);
                               acc_list_coarse = [acc_list_coarse; accuracy]  
                           end
                           %d_matrix_coarse = [d_matrix_coarse  d_list_coarse] ;
                           d_tensor_coarse(effCnt,repCnt,:) = d_list_coarse(:) ;
                           acc_tensor_coarse(effCnt,repCnt,:) = acc_list_coarse(:) ;

                           
                           %d_list_fine = [] ;
                           %for lambda_disc = lambda_disc_list_fine
                           %    ConstVars.lambda_disc = lambda_disc
                           %    [B,C,w,Report] = MultiChannel_MultiView_BoxedSparsity_spg_Mosek(Data,ConstVars) ;
                           %    dA = min( sum((B-repmat(IA(:),1,ConstVars.r)).^2)  );
                           %    dB = min( sum((B-repmat(IB(:),1,ConstVars.r)).^2)  );
                           %    d_list_fine = [d_list_fine; dA + dB] ;
                           %end
                           %d_matrix_fine = [d_matrix_fine  d_list_fine] ;
                           
                       end
                       %figure
                       %plot(log(lambda_disc_list_coarse),mean(d_matrix_coarse,2),...
                       %                '--rs','LineWidth',2,...
                       %                'MarkerEdgeColor','k',...
                       %                'MarkerFaceColor','g',...
                       %                'MarkerSize',10)
                       %axis([-20   20  0  20 ])
                       %grid on
                       %figure
                       %errorbar(log(lambda_disc_list_coarse),mean(d_matrix_coarse,2),std(d_matrix_coarse,[],2),...
                       %                '--rs','LineWidth',2,...
                       %                'MarkerEdgeColor','k',...
                       %                'MarkerFaceColor','g',...
                       %                'MarkerSize',10)
                       %axis([-50   20  0  20 ])
                       %grid on
                       save(ConstVars.FeatureFilename,'acc_tensor_coarse','d_tensor_coarse','ConstVars','lambda_disc_list_coarse','effect_mean_list') ;
                   end

              otherwise

           end

end


% it computes distance between basis matrix and binary image
function  [d,Idx] = computeDist(B,I)
       minVal = inf ;
       for cnt=1:size(B,2)
           if (minVal > norm(double(B(:,cnt) > graythresh(B(:,cnt))) - I(:)) )
               minVal = norm(double(B(:,cnt) > graythresh(B(:,cnt))) - I(:)) ;
               d = norm(double(B(:,cnt) > graythresh(B(:,cnt))) - I(:)) ;
               Idx = cnt ;
           elseif (minVal == norm(double(B(:,cnt) > graythresh(B(:,cnt))) - I(:)) )
                if (norm(double(B(:,Idx) - I(:)) > norm(B(:,cnt)) - I(:)))
                    d = norm(double(B(:,cnt) > graythresh(B(:,cnt))) - I(:)) ;
                    Idx = cnt ;
                end
           end
       end
       
end
