/*******************************************************


This program performs image registration.

last modified : Apr 7 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program change x,y.\n");
  printf("\n%s inputdeformationfield outputdeformationfield -d X,Y,Z [-S] -[a|d]\n", filename);
  printf("\n");
}

main(int argc, char *argv[])
{
  char inputdeformationfield[180], outputdeformationfield[180];
  char type;
  Deformation_Field *idf;  

  float original_distance, threshold;
  
  int x, y, z, c, XX, YY, ZZ, k, xx, yy, zz, sw;
  int do_smooth;

  float ok, okok, maxv;

  FPoint FP, zero;
  Points *hood;

  int width = 10;

  sw = 0;

  threshold = 100.0;
  do_smooth = 0;
  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputdeformationfield, argv[1]); 
      strcpy(outputdeformationfield, argv[2]);

      c=getopt(argc-2,argv+2,"d:Si:");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'S':
	      sw = 1;
	      break;
	    case 'i':
	      sscanf(optarg, "%c", &type);
	      break;
	    default:
	      printf("option error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:Si:");
	}
    }

  printf("begin program\n");
  printf("%d %d %d\n", XX, YY, ZZ);

  idf = new_deformationfield(XX,YY,ZZ);

  read_deformationfield_with_switch(idf, inputdeformationfield, sw);

  if (type=='a')
    {
      for (z=0;z<idf->Z;z++)
	for (y=0;y<idf->Y;y++)
	  for (x=0;x<idf->X;x++)
	    {
	      idf->point[z][y][x].X = idf->point[z][y][x].X - x;
	      idf->point[z][y][x].Y = idf->point[z][y][x].Y - y;
	      idf->point[z][y][x].Z = idf->point[z][y][x].Z - z;
	    }    
    }
  else if (type=='d')
    {
      for (z=0;z<idf->Z;z++)
	for (y=0;y<idf->Y;y++)
	  for (x=0;x<idf->X;x++)
	    {
	      idf->point[z][y][x].X = idf->point[z][y][x].X + x;
	      idf->point[z][y][x].Y = idf->point[z][y][x].Y + y;
	      idf->point[z][y][x].Z = idf->point[z][y][x].Z + z;
	    }    
    }
  else
    {
      printf("what are you doing?\n");
      printf("I am existing\n");
      exit(0);
    }

  write_deformationfield_with_switch(idf, outputdeformationfield, sw);

  free_deformationfield(idf);
}

