#include "dfieldio.h"


/********************************************************************************************************************************/      

int LoadDeformationFieldCartesianComponents3D(char *fname, 
                                              float **f,
                                              float **g,
                                              float **e,
                                                                                          int r,
                                                                                          int c,
                                                                                          int s)
{
        int i,j,k,rcs=r*c*s;
        float ftemp;
        float gtemp;
        float etemp;
        FILE *infile = NULL;
        
    (*f)=(float *)calloc(rcs,sizeof(float));
    (*g)=(float *)calloc(rcs,sizeof(float));
    (*e)=(float *)calloc(rcs,sizeof(float));
    if ((infile=fopen(fname,"rb"))==NULL)
    {
        fprintf(stderr,"cannot open file %s for reading.\n",fname);
        fprintf(stderr,"data not read.\n");
        return 0;
    }
    
    i=0;
    while ((fread(&ftemp,sizeof(float),1,infile)>0)&&(fread(&gtemp,sizeof(float),1,infile)>0)&&(fread(&etemp,sizeof(float),1,infile)>0)&&(i<rcs))
    {
        (*f)[i]=ftemp;
        (*g)[i]=gtemp;
        (*e)[i]=etemp;
        i++;
    }
/*      for (i=0;i<r*c*s;i++) 
    {
        fread(&temp,sizeof(float),1,infile);
                (*f)[i]=temp;
                fread(&temp,sizeof(float),1,infile);
                (*g)[i]=temp;
                fread(&temp,sizeof(float),1,infile);
                (*e)[i]=temp;
        }
        fclose(infile);*/
        return 1;
}
        
/********************************************************************************************************************************/      

int SaveDeformationFieldCartesianComponents3D(char *fname, 
                                              float *f,
                                              float *g,
                                              float *e,
                                                                                      int r,
                                                                                      int c,
                                                                                      int s)
{
        int i,j,k;
        float temp;
        FILE *outfile = NULL;
        
        if ((outfile=fopen(fname,"wb"))==NULL)
    {
        fprintf(stderr,"error: cannot open file %s for writing.\n",fname);
        fprintf(stderr,"file not written.\n");
        return 0;
    }
    
        for (i=0;i<r*c*s;i++) {
        temp=f[i];
                fwrite(&temp,sizeof(float),1,outfile);
                /* if (VERBOSITY) printf("%7.4f\n",temp); */
                temp=g[i];
                fwrite(&temp,sizeof(float),1,outfile);
                /* if (VERBOSITY) printf("%7.4f\n",temp); */
                temp=e[i];
                fwrite(&temp,sizeof(float),1,outfile);
                /* if (VERBOSITY) printf("%7.4f\n",temp); */
        }
        fclose(outfile);
        return 1;
}
        
