#!/usr/bin/perl

use Getopt::Std;

#get arguments list
$argc=@ARGV;

if ($argc < 2){
   &showUsage ;
}

my $opt_string = 'M:F:I:s:ShV:D:';

getopts( "$opt_string");

if($opt_h){
  &showUsage;
  }

if ($opt_D){
    $ModelFolder = $opt_D;
}
else
{
    $ModelFolder = "./";
}

if ($opt_V){
    $std = $opt_V;
    $stdoption = "-V"." ${std}";
}
else
{
    print "you dont have -V\n";
    $stdoption=" ";
}

print "$stdoption\n";
print "$std\n";


if ($opt_I){
    $InputField = $opt_I;
}
else
{
    print "You need input deformationfield -I\n";
    exit(0);
}

if ($opt_M){
    $ModelName = $opt_M;
    $have_ModelName = 1;
}
else
{
    print "You have to input base name of the Model, use -M Model_Name please\n";
    print "I am using the default value read from the train file\n";
    $have_ModelName = 0;
}    

if ($opt_F){
    $OutField = $opt_F;
}
else
{
    print "-F is a must, it indicates the output field name, exiting\n";
    exit(1);
}

if ($opt_s){
    $summary_file = $opt_s;
    $summary_file = "$ModelFolder"."/"."${summary_file}"
}
else
{
    print "No summary file! use -s please\n";
    exit (1);
}

$Switch = 0;
if ($opt_S){
    $Switch = 1;
}

open(SUMMARY, "<$summary_file")||die("could not read file $summary_file\n");
$filenames = "";
$index = 1;

while($line = <SUMMARY>)
{
    chop($line);
    if (($index == 4)||($index==6)||($index==8)||($index==10)||($index==12)){
	if ($index==4)
	{
	    $filenames = "$line";
	}
	else
	{
	    $filenames = "$filenames"."&"."$line";
	}
    }

    if ($index==14){
	if ($have_ModelName==0){
	    $ModelName = "$line";
	}
    }

    #template name
    if ($index==18){  
	if ($have_templateimage==0){
	    $templateimage = "$line";
	}
    }
    
    #template size
    if ($index==20){
	$OSize = $line;
    # current do nothing;
    }

    #cut size
    if ($index==22){
	$cutsize = $line;
    }

    #small size
    if ($index==24){
    # do nothing
    }

    #small template
    if ($index==26){
	$small_template=$line;
    }

    #Switch
#    if ($index==27)
#    {
#	$Switch=$line;
#    }

    $index = $index + 1;
}
close(SUMMARY);

($filenamelist, $fieldfilenamelist, $wptfilenamelist, $jakfilenamelist, $jakwptfilenamelist) = split('&', $filenames);

$filenamelist = "$ModelFolder"."/"."$filenamelist";
$fieldfilenamelist = "$ModelFolder"."/"."$fieldfilenamelist";
$wptfilenamelist = "$ModelFolder"."/"."$wptfilenamelist";
$jakfilenamelist = "$ModelFolder"."/"."$jakfilenamelist";
$jakwptfilenamelist = "$ModelFolder"."/"."$jakwptfilenamelist";

open(FILE, "<$wptfilenamelist")||die("could not read file $wptfilenamelist\n");
$index = 1;
while (($line = <FILE>)&&($index<3)){
    chop($line);
    $fieldwptfile = $line;
    $index = $index + 1;
}
close(FILE);

$fieldwptinforfile = "$fieldwptfile".".infor";
$OutFieldInfor = "$OutField".".wpt.infor";
#print "cp $fieldwptinforfile $OutFieldInfor\n";

$fieldwptinforfile = "$ModelFolder"."/"."$fieldwptinforfile";
system("cp -f $fieldwptinforfile $OutFieldInfor");

open(FILE, "<$fieldwptinforfile")||die("could not read file $fieldwptinforfile\n");
$index = 1;
while ($line=<FILE>){
    chop($line);
    if ($index == 2){
	$data = $line;
	@strings = split(' ', $data);
	($nXX, $nYY, $nZZ) = split(',', $strings[2]);
    }
    if ($index == 4){
	$data = $line;
	@strings = split(' ', $data);
	($XX, $YY, $ZZ) = split(',', $strings[2]);	
    }
    $index = $index + 1;
}
close(FILE);

($BX, $EX, $BY, $EY, $BZ, $EZ) = split(',', $cutsize);

$XX=$EX - $BX + 1;
$YY=$EY - $BY + 1;
$ZZ=$EZ - $BZ + 1;

# Note, the codes from here to the end of this program should be iteratively performed, however here we only use one iteration

print "LinuxCutDeformationField ${InputField} ${InputField}.smooth -d $OSize -s $cutsize\n";		
system("LinuxCutDeformationField ${InputField} ${InputField}.smooth -d $OSize -s $cutsize >> /dev/null");

if ($Switch == 1)
{
    print "LinuxSmoothDeformationField ${InputField}.smooth ${InputField}.smooth -d $XX,$YY,$ZZ -S -T 100 -w 2 -m .3\n";
    system("LinuxSmoothDeformationField ${InputField}.smooth ${InputField}.smooth -d $XX,$YY,$ZZ -S -T 100 -w 2 -m .3 >> /dev/null");
    print "LinuxResaveDeformationField ${InputField}.smooth ${InputField}.smooth -d $XX,$YY,$ZZ\n";
    system("LinuxResaveDeformationField ${InputField}.smooth ${InputField}.smooth -d $XX,$YY,$ZZ >> /dev/null");
}
else
{
    print "LinuxSmoothDeformationField ${InputField}.smooth ${InputField}.smooth -d $XX,$YY,$ZZ -T 100 -w 2 -m .3\n";
    system("LinuxSmoothDeformationField ${InputField}.smooth ${InputField}.smooth -d $XX,$YY,$ZZ -T 100 -w 2 -m .3 >> /dev/null");
}

print "LinuxWaveletPacketTransformOfDeformation ${InputField}.smooth ${OutField}.wpt -d $XX,$YY,$ZZ -l 2\n";
system("LinuxWaveletPacketTransformOfDeformation ${InputField}.smooth ${OutField}.wpt -d $XX,$YY,$ZZ -l 2 ");

print "This will take 20~30 minutes\n";

print "LinuxPCAWPTsSimulate $wptfilenamelist $ModelName -o ${OutField}.wpt -p 1 -I ${OutField}.wpt ${stdoption} -D ${ModelFolder} \n";
system("LinuxPCAWPTsSimulate $wptfilenamelist $ModelName -o ${OutField}.wpt -p 1 -I ${OutField}.wpt ${stdoption} -D ${ModelFolder}");

print "LinuxInverseWaveletPacketTransformOfDeformation ${OutField}.wpt ${OutField}\n";
system("LinuxInverseWaveletPacketTransformOfDeformation ${OutField}.wpt ${OutField} >> /dev/null");

print "LinuxSmoothDeformationField ${OutField} ${OutField} -d $XX,$YY,$ZZ -m .7\n";
system("LinuxSmoothDeformationField ${OutField} ${OutField} -d $XX,$YY,$ZZ -m .7 >> /dev/null");

print "LinuxRecoverDeformationField ${OutField} ${OutField} -d $OSize -s $cutsize -G\n";
system("LinuxRecoverDeformationField ${OutField} ${OutField} -d $OSize -s $cutsize -G >> /dev/null");

if ($Switch == 1)
{
    print "LinuxResaveDeformationField ${OutField} ${OutField} -d $OSize\n";
    system("LinuxResaveDeformationField ${OutField} ${OutField} -d $OSize ");    
}

system("rm -f ${OutField}.smooth");
system("rm -f ${OutField}.wpt");
system("rm -f ${OutField}.wpt.infor");

print "done, contact: zhong.xue@uphs.upenn.edu\n\n";

sub showUsage{
    print "This program regularizes an input deformation field using SMD:\n\n";    
    print "Notice that the statistical models have to be trained using LinuxTrainSSD.pl prior to using this program.\n\n";
    print "Usage: $0 [options]\n\n";
    print "-h                   : print this help\n\n";
    print "Inputs:\n\n";
    print "-M basename for Model: the base(prefix) filename of the WPCA models\n";
    print "-s summary_file      : the summary file generated by LinuxTrainSSD\n";
    print "-I deformation_field : input deformationfield\n\n";
    print "-S                   : input is a HAMMER field\n\n";
    print "-V std               : standard std ratial requirment, 1, 4, 9, 20 etc\n";
    print "-D ModelFolder       : the absolute path of the model files\n";
    print "Outputs:\n\n";
    print "-F simulated_field   : the output simulated deformation field\n";
    print "\n\n";
    print "xuez\@uphs.upenn.edu\n";

    exit(1);
} 
