/* this program generates the multi-resolution images

Jon Z. Xue

Jan 10 2002
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s inputptsfile outputptsfile [options]\n", filename);
  printf("-s <int,int,int,int,int,int>\n");
  printf("\n");
}

main(int argc, char *argv[])
{
  char  inputfilename[180], outputfilename[180];

  FPoints *ipts;

  char ch1, ch2, ch, chs;
  int direction,ok;
  int use_original;
  int value;
  int XX,YY,ZZ,x,y,z;
  int bx,by,bz,ex,ey,ez;

  int do_newsize, newsize;

  int one, two, vary;
  int change, reverse;
  int c;
  int threshold;

  ok = 0;
  change = 0;
  reverse = 0;
  do_newsize = 0;

  if (argc<3)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilename, argv[1]); 
      strcpy(outputfilename, argv[2]); 

      c=getopt(argc-2,argv+2,"s:");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 's':
	      sscanf(optarg, "%d,%d,%d,%d,%d,%d", &bx,&ex,&by,&ey,&bz,&ez);
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"s:");
	}
    }
  
  ipts = read_fpoints(inputfilename);

  for (x=0;x<ipts->Num;x++)
    {
      ipts->point[x].X = ipts->point[x].X - bx;
      ipts->point[x].Y = ipts->point[x].Y - by;
      ipts->point[x].Z = ipts->point[x].Z - bz;
    }

  write_fpoints(ipts, outputfilename);
}








