/*******************************************************

This program generates the target volume used for generating the atrophy.

April 2004.

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program generates the target volume.\n");
  printf("\n%s inputsegmentedimage outputtargetvolume -d X,Y,Z -p X,Y,Z -V vx,vy,vz -r radius -R atrophy_rate [-G|W]\n", filename);
  printf("default options: X=256, Y=256 Z=196, r=10, R=.5\n");
  printf("\n");
}

main(int argc, char *argv[])
{
  char inputfile[80], deformationfield[80], outputfile[80], tmpfile[80];

  int XX,YY,ZZ;
  int nx, ny, nz;

  int BX,EX,BY,EY,BZ,EZ;
  int length;
  int c;
  int xxx,yyy,zzz;
  int number,nonzeronumber;
  int x,y,z;
  int radius;
  int p_input;

  float rate;
  float vx, vy, vz;

  Point P,p,C;

  DBox *img, *nimg, *tvol, *timg;
  Deformation_Field *df;
  int gray_only, white_only, both;

  FILE *fp;

  radius = 10;
  XX = 256;
  YY = 256;
  ZZ = 196;
  rate = .5;

  vx = .9375;
  vy = .9375;
  vz = 1.5;

  p_input = 0;

  both = 1;
  white_only = 0;
  gray_only = 0;

  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfile, argv[1]); 
      strcpy(outputfile, argv[2]);

      c=getopt(argc-2,argv+2,"d:p:r:R:V:GW");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'p':
	      p_input = 1;
	      sscanf(optarg, "%d,%d,%d", &P.X, &P.Y, &P.Z);
	      break;
	    case 'r':
	      radius = atoi(optarg);
	      break;
	    case 'R':
	      sscanf(optarg, "%f", &rate);
	      break;
	    case 'G':
	      both = 0;
	      gray_only = 1;
	      break;
	    case 'W':
	      both = 0;
	      white_only = 1;
	      break;
	    case 'V':
	      sscanf(optarg, "%f,%f,%f", &vx, &vy, &vz);
	      break;	   
	    default:
	      printf("option error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:p:r:R:V:WG");
	}
    }

  if ((gray_only)&&(white_only))
    both = 1;
  
  if (p_input==0)
    {
      printf("you need to input the point position\n");
      exit(0);
    }

  img = new_dbox(XX,YY,ZZ);
  //  timg = new_dbox(XX,YY,ZZ);

  printf("I am reading file %s\n", inputfile);
  read_dbox(img, inputfile, "byte");  

  /*
  printf("I am filtering the image\n");
  for (z=0;z<img->Z;z++)
    for (y=0;y<img->Y;y++)
      for (x=0;x<img->X;x++)
	{
	  number = 0;
	  nonzeronumber = 0;
	  for (zzz=-1;zzz<2;zzz++)
	    for (yyy=-1;yyy<2;yyy++)
	      for (xxx=-1;xxx<2;xxx++)
		{
		  nx = x + xxx;
		  ny = y + yyy;
		  nz = z + zzz;
		  number ++;
		  if ((nx>=0)&&(ny>=0)&&(nz>=0)&&(nx<XX)&&(ny<YY)&&(nz<ZZ))
		    if (img->box[nz][ny][nx] !=0)
		      nonzeronumber ++;
		}
	  if ((float)nonzeronumber/(float)number < 0.2)
	    timg->box[z][y][x] = 0;
	  else
	    timg->box[z][y][x] = img->box[z][y][x];
	}

  copy_dbox(timg, img);
  free_dbox(timg);
  */
  // get a smaller tvol
  
  BX = 0;
  BY = 0;
  BZ = 0;
  EX = XX-1;
  EY = YY-1;
  EZ = ZZ-1;

  number = 0;
  while (number==0)
    {
      for (y=0;y<img->Y;y++)
	for (x=0;x<img->X;x++)
	  if (img->box[BZ][y][x]!=0)
	    {
	      number ++;
	      break;
	    }
      BZ++;
    }
  BZ = BZ-3;
  if (BZ<0)
    BZ = 0;

  number = 0;
  while (number==0)
    {
      for (z=0;z<img->Z;z++)
	for (x=0;x<img->X;x++)
	  if (img->box[z][BY][x]!=0)
	    {
	      number ++;
	      break;
	    }
      BY++;
    }
  BY = BY-3;
  if (BY<0)
    BY = 0;

  number = 0;
  while (number==0)
    {
      for (y=0;y<img->Y;y++)
	for (z=0;z<img->Z;z++)
	  if (img->box[z][y][BX]!=0)
	    {
	      number ++;
	      break;
	    }
      BX++;
    }
  BX = BX-3;
  if (BX<0)
    BX = 0;
  
  number = 0;
  while (number==0)
    {
      for (y=0;y<img->Y;y++)
	for (x=0;x<img->X;x++)
	  if (img->box[EZ][y][x]!=0)
	    {
	      number ++;
	      break;
	    }
      EZ--;
    }
  EZ = EZ+3;
  if (EZ>=ZZ)
    EZ = ZZ-1;

  number = 0;
  while (number==0)
    {
      for (z=0;z<img->Z;z++)
	for (x=0;x<img->X;x++)
	  if (img->box[z][EY][x]!=0)
	    {
	      number ++;
	    }
      EY--;
    }
  EY = EY+3;
  if (EY>=YY)
    EY = YY-1;

  number = 0;
  while (number==0)
    {
      for (y=0;y<img->Y;y++)
	for (z=0;z<img->Z;z++)
	  if (img->box[z][y][EX]!=0)
	    {
	      number ++;
	    }
      EX--;
    }
  EX = EX+3;
  if (EX>=XX)
    EX = XX-1;
  
  printf("new image size is %d-%d, %d-%d, %d-%d\n", BX,EX,BY,EY,BZ,EZ);

  fp = fopen("smallsize.txt", "w");
  fprintf(fp, "%d,%d,%d\n", XX,YY,ZZ);
  fprintf(fp, "%d,%d,%d,%d,%d,%d\n", BX,EX,BY,EY,BZ,EZ);
  fclose(fp);

  nimg = new_dbox(EX-BX+1, EY-BY+1, EZ-BZ+1);
  tvol = new_dbox(EX-BX,EY-BY,EZ-BZ);

  for (z=0;z<nimg->Z;z++)
    for (y=0;y<nimg->Y;y++)
      for (x=0;x<nimg->X;x++)
	{
	  nx = x+BX;
	  ny = y+BY;
	  nz = z+BZ;
	  if ((nx>=0)&&(ny>=0)&&(nz>=0)&&(nx<XX)&&(ny<YY)&&(nz<ZZ))
	    nimg->box[z][y][x] = img->box[z+BZ][y+BY][x+BX];
	  else
	    {
	      printf("error\n");
	      exit(0);
	    }
	}

  for (z=0;z<tvol->Z;z++)
    for (y=0;y<tvol->Y;y++)
      for (x=0;x<tvol->X;x++)
	{
	  number = 0;
	  for (zzz=0;zzz<2;zzz++)
	    for (yyy=0;yyy<2;yyy++)
	      for (xxx=0;xxx<2;xxx++)
		{
		  if (nimg->box[z+zzz][y+yyy][x+xxx]>10.0)
		    number ++;
		}

	  if ((number>=4)&&(nimg->box[z][y][x]>10.0))
	    tvol->box[z][y][x] = 1;
	  else
	    tvol->box[z][y][x] = 0;
	}
  
  P.X = P.X - BX;
  P.Y = P.Y - BY;
  P.Z = P.Z - BZ;

  C.X = P.X - .5;
  C.Y = P.Y - .5;
  C.Z = P.Z - .5;

  printf("radius = %d\n", radius);

  for (z=P.Z-radius;z<=P.Z+radius;z++)
    for (y=P.Y-radius;y<=P.Y+radius;y++)
      for (x=P.X-radius;x<=P.X+radius;x++)
	{
	  p.X = x;
	  p.Y = y;
	  p.Z = z;
	  if ((x>=0)&&(y>=0)&&(z>=0)&&(x<tvol->X)&&(y<tvol->Y)&&(z<tvol->Z))
	    if (distance_3d_voxelsize(p,C,vx,vy,vz)<(float)radius)
	      {
		//	      printf("here\n");
		if (tvol->box[z][y][x]!=0)
		  {
		    if (both)
		      {
			tvol->box[z][y][x] = rate;
		      }
		    else
		      {
			if (gray_only)
			  {
			    number = 0;
			    for (zzz=-1;zzz<2;zzz++)
			      for (yyy=-1;yyy<2;yyy++)
				for (xxx=-1;xxx<2;xxx++)
				  {
				    nx = x + xxx;
				    ny = y + yyy;
				    nz = z + zzz;
				    if ((nx>=0)&&(ny>=0)&&(nz>=0)&&(nx<nimg->X)&&(ny<nimg->Y)&&(nz<nimg->Z))
				      if (nimg->box[nz][ny][nx]==150)
					number ++;
				  }
			    if (number>=7)
			      tvol->box[z][y][x] = rate;			  			
			  }
			if (white_only)
			  {
			    
			    number = 0;
			    for (zzz=-1;zzz<2;zzz++)
			      for (yyy=-1;yyy<2;yyy++)
				for (xxx=-1;xxx<2;xxx++)
				  {
				    nx = x + xxx;
				    ny = y + yyy;
				    nz = z + zzz;
				    if ((nx>=0)&&(ny>=0)&&(nz>=0)&&(nx<nimg->X)&&(ny<nimg->Y)&&(nz<nimg->Z))
				      if (nimg->box[nz][ny][nx]==250)
				      number ++;
				  }
			    if (number>=7)
			      tvol->box[z][y][x] = rate;			  						    
			  }
		      }
		  }
	      }
	}
  
  df = new_deformationfield(nimg->X, nimg->Y, nimg->Z);
  for (z=0;z<df->Z;z++)
    for (y=0;y<df->Y;y++)
      for (x=0;x<df->X;x++)
	{
	  df->point[z][y][x].X = x;
	  df->point[z][y][x].Y = y;
	  df->point[z][y][x].Z = z;
	}

  sprintf(tmpfile, "%s.small.img", inputfile);
  printf("writing new image %s\n", tmpfile);
  write_dbox(nimg, tmpfile, "byte", 1);
  sprintf(deformationfield, "%s.small.fld", inputfile);
  write_deformationfield_with_switch(df, deformationfield,1);

  printf("writing new target image %s\n", outputfile);
  write_dbox(tvol, outputfile, "float", 1);

  printf("fine, end\nzxue@rad.upenn.edu");
}




