#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s pointfilename outputfilename(smatrix) [options]\n", filename);
  printf("-d <int,int,int>\n");
  printf("\n");
}

main(int argc, char *argv[])
{

  SparseMatrix *sM, *sM1, *sMM, *sMMM;
  sMCol *smc;
  FPoints *fpts;
  Points *pts;

  int c;
  int XX,YY,ZZ,i;
  char inputfilename[200], outputfilename[200];

  if (argc<2)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilename, argv[1]); 
      strcpy(outputfilename, argv[2]); 

      c=getopt(argc-2,argv+2,"d:");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:");
	}
    }
 
  fpts = read_fpoints(inputfilename);
  if (reorder_fpoints(fpts))
    {
      printf("points reordered\n");
    }
  //    write_fpoints(fpts, inputfilename);
  display_fpoints(fpts);

  pts = new_points(fpts->Num);
  for (i=0;i<pts->Num;i++)
    {
      pts->point[i].X = (int) floorf(fpts->point[i].X + .5);
      pts->point[i].Y = (int) floorf(fpts->point[i].Y + .5);
      pts->point[i].Z = (int) floorf(fpts->point[i].Z + .5);
    }

  printf("new sM\n");
  sM = determine_matrix_pts(pts,XX,YY,ZZ);

  printf("new sM1\n");
  sM1 = determine_matrix(XX/2,YY/2,ZZ/2);

  printf("combining sM1\n");
  sMM = combine_smatrix(sM1);

  printf("making index of sMM\n");
  smc = make_index(sMM);

  printf("sM x sMM\n");
  sMMM = smatrix_time_smatrix(sM, sMM, smc);

  printf("now writing result to file\n");
  write_smatrix(sMMM, outputfilename, XX,YY,ZZ);
  printf("fine end\n");
}

