/* this program generates the multi-resolution images

Jon Z. Xue

Jan 10 2002
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s imagefile [options]\n", filename);
  printf("-d <int,int,int>\n");
  printf("-b|f\n");
  printf("\n");
}

main(int argc, char *argv[])
{
  char  inputfilename[180], outputfilename[180];
  DBox *oimg;
  char format[20];

  int c;
  int BX,EX,BY,EY,BZ,EZ;
  int XX,YY,ZZ;

  strcpy(format, "byte");
  if (argc<2)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilename, argv[1]); 

      c=getopt(argc-1,argv+1,"d:bf");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'f':
	      strcpy(format, "float");
	      break;
	    case 'b':
	      strcpy(format, "byte");
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-1,argv+1,"d:bf");
	}
    }
  
  oimg = new_dbox(XX,YY,ZZ);
  read_dbox(oimg, inputfilename, format);
  get_a_smaller_size(oimg, &BX,&EX,&BY,&EY,&BZ,&EZ);
  printf("%d,%d,%d,%d,%d,%d", BX,EX,BY,EY,BZ,EZ);
}








