/*******************************************************

This program performs image registration.

last modified : Apr 7 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program transfer an image to another according to the global transformation.\n");
  printf("\n");
  printf("Given Image A and Image B, T is the global transformation between A and B\n");
  printf("i.e.\n");
  printf("B = T(A)   ----> y = A(x - Tx) + Ty\n, where x is a point in A and y is a piont in B\n");
  printf("\n");
  printf("Given T and A, the process to calculate Image B=T(A) is forward transformation\n");
  printf("Given T and B, the process to calculate Image A=T^(-1)(B) is backward transformation\n");
  printf("\nUsage");
  printf("\n%s input.img global.trans.file output.img -d X,Y,Z [-D X,Y,Z] [-S] [-F]\n", filename);
  printf("\n");
  printf("-d int,int,int : input image size\n");
  printf("-D int,int,int : output image size, default is the same with -d\n");
  printf("-F             : forward transforamtion, default is backward transformation\n");
  printf("-I             : do interpolation\n");
  printf("\n");
}

main(int argc, char *argv[])
{
  char inputfile[180], transformation[180], outputfile[180];

  int XX,YY,ZZ;
  int oXX,oYY,oZZ;
  int c;
  int x,y,z;
  int have_od;
  int nx, ny, nz;
  int sw;
  int is_forward;
  int i,j;
  int do_interpolation;

  float vector0, vector1, vector2;
  float tmp0, tmp1, tmp2;

  Transformation T;
  Matrix *IA;

  DBox *iimg, *oimg;

  have_od = 0;

  XX = 256, YY = 256, ZZ = 176;

  sw = 0;
  do_interpolation = 0;
  is_forward = 0;
  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfile, argv[1]); 
      strcpy(transformation, argv[2]);
      strcpy(outputfile, argv[3]);

      c=getopt(argc-3,argv+3,"d:D:SFI");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'D':
	      sscanf(optarg, "%d,%d,%d", &oXX, &oYY, &oZZ);
	      have_od = 1;
	      break;
	    case 'S':
	      sw = 1;
	      break;
	    case 'F':
	      is_forward = 1;
	      break;
	    case 'I':
	      do_interpolation = 1;
	      break;
	    default:
	      printf("option error\n");
	      break;
	    }
	  c=getopt(argc-3,argv+3,"d:D:SFI");
	}
    }

  if (!have_od)
    {
      oXX = XX;
      oYY = YY;
      oZZ = ZZ;
    }

  iimg = new_dbox(XX,YY,ZZ);
  oimg = new_dbox(oXX,oYY,oZZ);

  read_dbox(iimg, inputfile, "byte");

  T = read_transformation(transformation);

  display_transformation(T);

  IA = (Matrix *) calloc (1, sizeof(Matrix));
  new_matrix(IA, 3,3);
  Mat_Inverse(T.A, IA);

  if (!is_forward)  // if the transformation is not forward, i.e. backward
    for (z=0;z<oZZ;z++)
      for (y=0;y<oYY;y++)
	for (x=0;x<oXX;x++)
	  {
	    vector0 = x - T.Tx[0];
	    vector1 = y - T.Tx[1];
	    vector2 = z - T.Tx[2];
	    
	    tmp0 = T.A->data[0][0] * vector0 + T.A->data[0][1] * vector1 + T.A->data[0][2] * vector2 + T.Ty[0];
	    tmp1 = T.A->data[1][0] * vector0 + T.A->data[1][1] * vector1 + T.A->data[1][2] * vector2 + T.Ty[1];
	    tmp2 = T.A->data[2][0] * vector0 + T.A->data[2][1] * vector1 + T.A->data[2][2] * vector2 + T.Ty[2];
	    
	    if (do_interpolation)
	      oimg->box[z][y][x] = interpolate_dbox(iimg, tmp0, tmp1, tmp2);	      
	    else
	      {
		nx = (int)floor(tmp0+.5);
		ny = (int)floor(tmp1+.5);
		nz = (int)floor(tmp2+.5);
		if ((nx>=0)&&(ny>=0)&&(nz>=0)&&(nx<iimg->X)&&(ny<iimg->Y)&&(nz<iimg->Z))
		  oimg->box[z][y][x] = iimg->box[nz][ny][nx];
	      }
	  }
  else // if the transformation is forward transformation
    {
      for (z=0;z<oZZ;z++)
	for (y=0;y<oYY;y++)
	  for (x=0;x<oXX;x++)
	    {
	      vector0 = x - T.Ty[0];
	      vector1 = y - T.Ty[1];
	      vector2 = z - T.Ty[2];
	      
	      tmp0 = IA->data[0][0] * vector0 + IA->data[0][1] * vector1 + IA->data[0][2] * vector2 + T.Tx[0];
	      tmp1 = IA->data[1][0] * vector0 + IA->data[1][1] * vector1 + IA->data[1][2] * vector2 + T.Tx[1];
	      tmp2 = IA->data[2][0] * vector0 + IA->data[2][1] * vector1 + IA->data[2][2] * vector2 + T.Tx[2];
	      
	      if (do_interpolation)
		oimg->box[z][y][x] = interpolate_dbox(iimg, tmp0, tmp1, tmp2);	      
	      else
		{
		  nx = (int)floor(tmp0+.5);
		  ny = (int)floor(tmp1+.5);
		  nz = (int)floor(tmp2+.5);
		  //		      printf("%d %d %d --> %d %d %d\n", x,y,z, (int)floor(tmp0+.5),(int)floor(tmp1+.5),(int)floor(tmp2+.5));
		  //		      getchar();
		  
		  if ((nx>=0)&&(ny>=0)&&(nz>=0)&&(nx<iimg->X)&&(ny<iimg->Y)&&(nz<iimg->Z))
		    oimg->box[z][y][x] = iimg->box[nz][ny][nx];
		}		  		  
	    }	  
    }
  
  write_dbox(oimg, outputfile, "byte", 1);
  
  printf("fine, end\n");
}




