/*******************************************************

This program performs image registration.

last modified : Aug 18 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>


extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this does PCA analysis of deformations (fav files)\n\n");
  printf("inputs:\n\n%s filenamelist.txt output_base_filename -p percentage\n\n", filename);
  printf("\n");
}

main(int argc, char *argv[])
{
  char inputfilelist[180];

  char **filename, deformationfield[180], **filename_infor;
  char maskfilename[180];
  char tempfilename[180];
  char tempstring[180];
  int length;

  DBox *bmask;

  FILE *fp, *gfp;

  FPoint FP, zero;

  int file_number;
  int i;
  int XX,YY,ZZ;
  int x, y, z;
  int xx,yy,zz;
  int c;
  int smooth;
  int usemodel;
  int sw;
  int update_mask;
  int have_mask;

  int **sizearray;
  int **steparray;
  int szx, szy, szz, szxyz;

  int pcaindex;
  int index;

  float tempx, tempy, tempz;
  float percent;
  double total, subtotal;

  char nouse1[200], nouse2[200], nouse3[200];

  Deformation_Field *df, *cdf;

  DBox *simg, *oimg;

  Matrix *Data, *Phi;
  Vector *lambda, *AX;

  Vector *bX, *nX;

  smooth = 0;
  sw = 0;
  
  zero.X = 0.0;
  zero.Y = 0.0;
  zero.Z = 0.0;
  
  update_mask = 0;
  have_mask = 0;
  percent = 0.91;
  
  //  printf("begin\n");
  strcpy(tempstring, "DEFPCA");
  
  if (argc<2)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilelist, argv[1]); 
      strcpy(tempstring, argv[2]); 

      c=getopt(argc-2,argv+2,"p:");
      while (c!=-1)
	{
	  switch(c)
	    {
	    case 'p':
	      sscanf(optarg, "%f", &percent);
	      break;
	    default:
	      break;
	    }	  
	  c=getopt(argc-2,argv+2,"p:");
	}
    }

  //  printf("reading file\n");

  fp = fopen(inputfilelist, "rt");
  if (fp==NULL)
    {
      printf("file does not exist\n");
      exit(0);
    }
  else
    {
      printf("file opened\n");
    }
  
  fscanf(fp, "%d\n", &file_number);
  //  printf("file number = %d\n", file_number);
  
  filename = (char **) calloc(file_number, sizeof(char *));
  filename_infor = (char **) calloc(file_number, sizeof(char *));
  sizearray = (int **) calloc(file_number, sizeof(int *));
  steparray = (int **) calloc(file_number, sizeof(int *));
  for (i=0;i<file_number;i++)
    {
      printf("%d\n", i);
      filename[i] = (char *) calloc(180, sizeof(char));
      filename_infor[i] = (char *) calloc(180, sizeof(char));
      sizearray[i] = (int *) calloc(3, sizeof(int));
      steparray[i] = (int *) calloc(3, sizeof(int));
    }

  for (i=0;i<file_number;i++)
    {
      fscanf(fp, "%s\n", filename[i]);
      sprintf(filename_infor[i], "%s.infor", filename[i]);
      printf("%s, %s\n", filename[i], filename_infor[i]);
    }

  fclose(fp);

  for (i=0;i<file_number;i++)
    {
      fp = fopen(filename_infor[i], "rt");

      fscanf(fp, "%s %s\n", nouse1, nouse2);
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &(sizearray[i][0]), &(sizearray[i][1]), &(sizearray[i][2]));
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &(steparray[i][0]), &(steparray[i][1]), &(steparray[i][2]));
      printf("%d %d %d %d %d %d\n", sizearray[i][0], sizearray[i][1], sizearray[i][2], steparray[i][0], steparray[i][1], steparray[i][2]);
      fclose(fp);
    }

  szx = steparray[0][0];
  szy = steparray[0][1];
  szz = steparray[0][2];

  szx /= 2;
  szy /= 2;
  szz /= 2;

  XX = sizearray[0][0];
  YY = sizearray[0][1];
  ZZ = sizearray[0][2];

  printf("%d %d %d %d %d %d\n", XX,YY,ZZ,szx,szy,szz);

  pcaindex = 0;

  Data = (Matrix *) calloc (1, sizeof(Matrix));
  Phi = (Matrix *) calloc (1, sizeof(Matrix));
  lambda = (Vector *) calloc (1, sizeof(Vector));
  AX = (Vector *) calloc (1, sizeof(Vector));
 
  szxyz = szx*szy*szz * 3;

  //  nX = new_vector(szxyz);

  new_matrix(Data, szxyz, file_number);

  for (z=0;z<ZZ;z+=szz)
    for (y=0;y<YY;y+=szy)
      for (x=0;x<XX;x+=szx)
	{
	  printf("I am calculating PCA for block no. %d\n", pcaindex);

	  printf("reading data\n");

	  for (i=0;i<file_number;i++)
	    {
	      printf("file no. : %d\r", i);
	      fflush(stdout);

	      fp = fopen(filename[i], "rb");

	      index = 0;

	      for (zz=z;zz<z+szz;zz++)
		for (yy=y;yy<y+szy;yy++)
		  {
		    fseek(fp, (zz* XX * YY + yy * XX + x)*12, SEEK_SET);
		    for (xx=x;xx<x+szx;xx++)
		      {
			fread(&tempx, sizeof(float), 1, fp);
			fread(&tempy, sizeof(float), 1, fp);
			fread(&tempz, sizeof(float), 1, fp);
			
			Data->data[index*3][i] = (double)tempx;
			Data->data[index*3+1][i] = (double)tempy;
			Data->data[index*3+2][i] = (double)tempz;
			
			index ++;
		      }
		  }

	      fclose(fp);
	    }

	  //	  Mat_Print(DataX);
	  //	  getchar();
	  
	  printf("doing PCA, on matrix size %dx%d\n", szxyz, file_number);

	  if (pcaindex==0)
	    {
	      PrincipalComponentAnalysis(Data, Phi, lambda, AX);
	    }
	  else
	    {
	      PrincipalComponentAnalysis_NoNewMemory(Data, Phi, lambda, AX);
	    }

	  display_vector(lambda);

	  total = 0.0;
	  for(i=0;i<lambda->size;i++)
	    {
	      total += lambda->value[i];
	    }

	  subtotal = 0.0;
	  for(i=0;i<lambda->size;i++)
	    {
	      subtotal += lambda->value[i];
	      if (subtotal>total*percent)
		{
		  i=i+1;
		  break;
		}
	    }

	  sprintf(tempfilename, "%s_%d.model", tempstring, pcaindex);
	  
	  gfp = fopen(tempfilename, "wb");
	  
	  if (gfp==NULL)
	    {
	      printf("writing file error\n");
	      exit(0);
	    }

	  printf("I am getting the first %d components\n", i);

	  fwrite(&szxyz, sizeof(int), 1, gfp);
	  fwrite(&i, sizeof(int), 1, gfp);
	  
	  for (xx=0;xx<szxyz;xx++)
	    for (yy=0;yy<i;yy++)
	      {
		tempx = Phi->data[xx][yy];		
		fwrite(&tempx, sizeof(float), 1, gfp);
	      }	  	  

	  for (xx=0;xx<i;xx++)
	    {
	      tempx = lambda->value[xx];
	      fwrite(&(tempx), sizeof(float), 1, gfp);
	    }

	  for (xx=0;xx<szxyz;xx++)
	    {
	      tempx = AX->value[xx];
	      fwrite(&(tempx), sizeof(float), 1, gfp);
	    }

	  bX = new_vector(i);

	  for (zz=0;zz<file_number;zz++)
	    {
	      for (xx=0;xx<bX->size;xx++)
		{
		  bX->value[xx] = 0.0;
		}
	      
	      for (xx=0;xx<bX->size;xx++)
		{
		  for (yy=0;yy<szxyz;yy++)
		    {
		      bX->value[xx] += Phi->data[yy][xx] * (Data->data[yy][zz] - AX->value[yy]);
		    }
		}

	      for (xx=0;xx<bX->size;xx++)
		{
		  tempx = bX->value[xx];
		  fwrite(&tempx, sizeof(float), 1, gfp);
		}

	    }

	  free_vector(bX);
	  
	  fclose(gfp);

	  //	  PrincipalComponentAnalysis(Matrix *Samples, Matrix *Phi, Vector *lambda, Vector *AX);

	  pcaindex ++;
	}

  printf("step 1, end\npls run step 2...4 programs");
}




