/* this program generates the multi-resolution images

Jon Z. Xue

Jan 10 2002
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s imagefile outputfile [options]\n", filename);
  printf("-d <int,int,int>\n");
  printf("-s <int,int,int,int,int,int>\n");
  printf("-b|f\n");
  printf("-C : Cut\n");
  printf("-R : Recover\n");
  
  printf("\n");
}

main(int argc, char *argv[])
{
  char  inputfilename[180], outputfilename[180];
  DBox *oimg, *timg, *ntimg;

  char ch1, ch2, ch, chs;
  char format[20];
  int direction,ok;
  int use_original;
  int value;
  int XX,YY,ZZ,x,y,z;
  int bx,by,bz,ex,ey,ez;
  int do_cut;
  int do_recover;

  int do_newsize, newsize;

  int one, two, vary;
  int change, reverse;
  int c;
  int threshold;

  ok = 0;
  change = 0;
  reverse = 0;
  do_newsize = 0;

  strcpy(format, "byte");

  do_cut = 0;
  do_recover = 0;

  if (argc<2)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilename, argv[1]); 
      strcpy(outputfilename, argv[2]); 

      c=getopt(argc-2,argv+2,"d:s:bfCR");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 's':
	      sscanf(optarg, "%d,%d,%d,%d,%d,%d", &bx,&ex,&by,&ey,&bz,&ez);
	      break;
	    case 'f':
	      strcpy(format, "float");
	      break;
	    case 'b':
	      strcpy(format, "byte");
	      break;
	    case 'R':
	      do_recover = 1;
	      break;
	    case 'C':
	      do_cut = 1;
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:s:bfCR");
	}
    }
  
  if ((do_recover)&&(do_cut))
    {
      printf("please choose either -C or -R, you can not choose both\n");
      exit(0);
    }
   if ((do_recover==0)&&(do_cut==0))
    {
      printf("please choose either -C or -R, you can not choose both, you have to choose one\n");
      exit(0);
    }  


   if (do_cut)
     {
       oimg = new_dbox(XX,YY,ZZ);
       read_dbox(oimg, inputfilename, format);
       
       timg = new_dbox(ex-bx+1,ey-by+1,ez-bz+1);
       
       clear_dbox(timg);
       for (z=bz;z<bz+timg->Z;z++)
	 for (y=by;y<by+timg->Y;y++)
	   for (x=bx;x<bx+timg->X;x++)
	     if ((x>=0)&&(y>=0)&&(z>=0)&&(x<oimg->X)&&(y<oimg->Y)&&(z<oimg->Z))
	       timg->box[z-bz][y-by][x-bx] = oimg->box[z][y][x];
       
       write_dbox(timg, outputfilename, format,1);
     }

   if (do_recover)
     {
       oimg = new_dbox(XX,YY,ZZ);       
       timg = new_dbox(ex-bx+1,ey-by+1,ez-bz+1);
       read_dbox(timg, inputfilename, format);
       
       clear_dbox(oimg);
       
       for (z=bz;z<bz+timg->Z;z++)
	 for (y=by;y<by+timg->Y;y++)
	   for (x=bx;x<bx+timg->X;x++)
	     if ((x>=0)&&(y>=0)&&(z>=0)&&(x<oimg->X)&&(y<oimg->Y)&&(z<oimg->Z))
	       oimg->box[z][y][x] = timg->box[z-bz][y-by][x-bx];

       write_dbox(oimg, outputfilename, format, 1);
     }
}








