/*******************************************************


This program performs image registration.

last modified : Apr 7 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program calculates jacobian of input deformation field.\n");
  printf("\n%s inputdeformationfield outputjacobian -d X,Y,Z [-S]\n", filename);
  printf("\n");
  printf("-d X,Y,Z  : input field size\n");
  printf("-S        : if input field is HAMMER field\n");
}

main(int argc, char *argv[])
{
  char inputdeformationfield[180], outputdeformationfield[180];

  Deformation_Field *idf;  
  DBox *jacobian, *oj;

  float original_distance, threshold;
  
  int x, y, z, c, XX, YY, ZZ, k, xx, yy, zz, sw;
  int do_smooth;
  float ok, okok, maxv;

  FPoint FP, zero;
  Points *hood;

  int width = 10;

  sw = 0;

  threshold = 100.0;
  do_smooth = 0;

  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputdeformationfield, argv[1]); 
      strcpy(outputdeformationfield, argv[2]);

      c=getopt(argc-2,argv+2,"d:S");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'S':
	      sw = 1;
	      break;
	    default:
	      printf("option error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:S");
	}
    }

  idf = new_deformationfield(XX,YY,ZZ);
  read_deformationfield_with_switch(idf, inputdeformationfield, sw);

  jacobian = new_dbox(XX,YY,ZZ);
  Calculate_Jakobian(idf, jacobian);
  write_dbox(jacobian,  outputdeformationfield, "float", 1);
}

