/*******************************************************

This program performs image registration.

last modified : Apr 7 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program reverse deformation field\n");
  printf("\n%s inputdeformationfield outputdeformationfield -d X,Y,Z [-a -S]\n", filename);
  printf("\n");
}

main(int argc, char *argv[])
{
  char inputfile[180], outputfile[180];

  int XX,YY,ZZ;
  int x,y,z;
  int sw;
  int c;
  int absolute_field;

  Deformation_Field *df, *idf;

  sw = 0;
  absolute_field = 0;

  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfile, argv[1]); 
      strcpy(outputfile, argv[2]);

      c=getopt(argc-2,argv+2,"d:Sa");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'S':
	      sw = 1;
	      break;
	    case 'a':
	      absolute_field = 1;
	      break;
	    default:
	      printf("option error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:Sa");
	}
    }

  df = new_deformationfield(XX,YY,ZZ);

  read_deformationfield_with_switch(df, inputfile, sw);

  if (absolute_field)
    {
      for (z=0;z<df->Z;z++)
	for (y=0;y<df->Y;y++)
	  for (x=0;x<df->X;x++)
	    {
	      df->point[z][y][x].X = df->point[z][y][x].X - x;
	      df->point[z][y][x].Y = df->point[z][y][x].Y - y;
	      df->point[z][y][x].Z = df->point[z][y][x].Z - z;
	    }
    }

  idf = inverse_deformationfield(df);

  write_deformationfield_with_switch(idf, outputfile, sw);

  printf("fine, end\n");
}




