/*******************************************************

This program performs image registration.

last modified : Aug 18 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program simulated deformations based on the PCA models generated by program pca_of_deformations\n\n");
  printf("inputs:\n\n%s filenamelist.txt pcamodel_base_filename -I inputdeformationfield -N num -o outputdeformationfield -p percentage [-m alpha,beta] [-v v.data]\n\n", filename);
  printf("-I inputdeformationfield     :  optional, input the deformationfield needs to be regularized\n");
  printf("-N num                       :  optional, input any number between 0 and N-1 (N is number of samples, this will regularize that sample\n");
  printf("-o outputdeformationfield    :  output\n");
  printf("-p percentage                :  optional, default is 1\n");
  printf("-n number of PC              :  optional, no default value, this option has priority than -p.\n");
  printf("-m alpha,beta                :  parameters to choose, optional, default is 0 and 1\n");
  printf("-v v.data                    :  input v.data data\n");
  printf("-M mode_number,times         :  mode_number, 0,1,2, etc, and times: -2,-1,0,1,2 etc\n\n");
  printf("-V std_input                 :  the threshold (1,4,9,20, etc)\n");
  printf("\n");
  printf("-D model_folder              :  model folder, dont use this option is the working folder is the model folder\n");
  printf("\n");
  printf("Note 1: -v has priority than -I, if both arguments are given.\n"); 
  printf("Note 2: the deformationfield here is really not deformationfield, it is WPT of deformation field\n");
  printf("\n");
}

main(int argc, char *argv[])
{
  char inputfilelist[180];
  char modelfolder[180], tempname[180];
  char **filename, deformationfield[180], **filename_infor, inputdeformationfield[200];
  char maskfilename[180];
  char vfile[200];
  char tempfilename[180];
  char tempstring[180];
  int length;
  int number_of_pc;
  int have_number_of_pc;
  int have_magnitude_control;
  float alpha, beta;
  int randsign;
  int modenumber;
  float modetime;
  int havemodenumbertime;

  DBox *dfx, *dfy, *dfz;

  FILE *fp, *gfp;

  FPoint FP, zero;

  int file_number;
  int number;
  int i,j;
  int XX,YY,ZZ;
  int x, y, z;
  int lx, ly, lz;
  int xx,yy,zz;
  int c;
  int smooth;
  int usemodel;
  int sw;
  int update_mask;
  int have_mask;
  int tempint;
  float tempfloat;
  int have_number;

  int have_inputdeformationfield;
  double value_std;
  float value_std_threshold;
  int have_std;
  int have_modelfolder;

  int **sizearray;
  int **steparray;
  int szx, szy, szz, szxyz;

  int pcaindex;
  int index;
  int have_vfile, vnumber;
  float tempx, tempy, tempz;
  float percent;
  int have_percent;
  double total, subtotal;
  int no_of_principal;

  char nouse1[200], nouse2[200], nouse3[200];

  Deformation_Field *df;
  Deformation_Field *idf;

  DBox *simg, *oimg;

  Matrix *Data, *Phi;
  Vector *lambda, *AX;

  Vector *bX, *nX;
  Vector **v;

  smooth = 0;
  sw = 0;
  
  zero.X = 0.0;
  zero.Y = 0.0;
  zero.Z = 0.0;
  
  update_mask = 0;
  have_mask = 0;
  percent = 1.0;
  
  //  printf("begin\n");
  strcpy(tempstring, "DEFPCA");
  number = 1;

  strcpy(deformationfield, "output.field");
  have_vfile = 0;
  have_number = 0;
  have_inputdeformationfield = 0;
  havemodenumbertime = 0;
  have_number_of_pc = 0;
  have_percent = 0;
  have_std = 0;
  have_modelfolder = 0;

  if (argc<2)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilelist, argv[1]); 
      strcpy(tempstring, argv[2]); 

      c=getopt(argc-2,argv+2,"p:N:o:m:v:I:M:n:V:D:");
      while (c!=-1)
	{
	  switch(c)
	    {
	    case 'p':
	      sscanf(optarg, "%f", &percent);
	      have_percent = 1;
	      break;
	    case 'n':
	      sscanf(optarg, "%d", &number_of_pc);
	      have_number_of_pc = 1;
	      break;
	    case 'N':
	      sscanf(optarg, "%d", &number);
	      have_number = 1;
	      break;
	    case 'o':
	      sscanf(optarg, "%s", deformationfield);
	      break;
	    case 'm':
	      have_magnitude_control = 1;
	      sscanf(optarg, "%f,%f", &alpha, &beta);
	      break;
	    case 'v':
	      sscanf(optarg, "%s", vfile);
	      have_vfile = 1;
	      break;
	    case 'I':
	      sscanf(optarg, "%s", inputdeformationfield);
	      have_inputdeformationfield = 1;
	      break;
	    case 'M':
	      sscanf(optarg, "%d,%f", &modenumber, &modetime);
	      havemodenumbertime = 1;
	      break;
	    case 'V':
	      sscanf(optarg, "%f", &value_std_threshold);
	      have_std = 1;
	      break;
	    case 'D':
	      sscanf(optarg, "%s", modelfolder);
	      have_modelfolder = 1;
	      break;
	    default:
	      break;
	    }	  
	  c=getopt(argc-2,argv+2,"p:N:o:m:v:I:M:n:V:D:");
	}
    }

  
  printf("%f\n", value_std_threshold);

  xz_randomize();

  /*
  if (have_modelfolder)
    {
      strcpy(tempname, modelfolder);
      strcat(tempname,"/");
      strcat(tempname, inputfilelist);
      strcpy(inputfilelist, tempname);
    }
  */

  printf("%s\n", inputfilelist);
  fp = fopen(inputfilelist, "rt");
  if (fp==NULL)
    {
      printf("file does not exist\n");
      exit(0);
    }
  else
    {
      printf("file opened\n");
    }
  
  fscanf(fp, "%d\n", &file_number);

  filename = (char **) calloc(file_number, sizeof(char *));
  filename_infor = (char **) calloc(file_number, sizeof(char *));
  sizearray = (int **) calloc(file_number, sizeof(int *));
  steparray = (int **) calloc(file_number, sizeof(int *));
  for (i=0;i<file_number;i++)
    {
      //      printf("%d\n", i);
      filename[i] = (char *) calloc(180, sizeof(char));
      filename_infor[i] = (char *) calloc(180, sizeof(char));
      sizearray[i] = (int *) calloc(3, sizeof(int));
      steparray[i] = (int *) calloc(3, sizeof(int));
    }

  for (i=0;i<file_number;i++)
    {
      fscanf(fp, "%s\n", filename[i]);
      sprintf(filename_infor[i], "%s.infor", filename[i]);
      //      printf("%s, %s\n", filename[i], filename_infor[i]);
    }

  fclose(fp);

  for (i=0;i<file_number;i++)
    {
      if (have_modelfolder)
	{
	  strcpy(tempname, modelfolder);
	  strcat(tempname, "/");
	  strcat(tempname, filename_infor[i]);
	  strcpy(filename_infor[i], tempname);
	}

      fp = fopen(filename_infor[i], "rt");

      fscanf(fp, "%s %s\n", nouse1, nouse2);
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &(sizearray[i][0]), &(sizearray[i][1]), &(sizearray[i][2]));
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &(steparray[i][0]), &(steparray[i][1]), &(steparray[i][2]));
      printf("%d %d %d %d %d %d\n", sizearray[i][0], sizearray[i][1], sizearray[i][2], steparray[i][0], steparray[i][1], steparray[i][2]);
      fclose(fp);
    }

  printf("here\n");

  szx = steparray[0][0];
  szy = steparray[0][1];
  szz = steparray[0][2];

  szx /= 2;
  szy /= 2;
  szz /= 2;

  pcaindex = 0;

  szxyz = szx*szy*szz * 3;

  AX = new_vector(szxyz);

  printf("new deform\n");

  df = new_deformationfield(sizearray[0][0], sizearray[0][1], sizearray[0][2]);

  XX = df->X;
  YY = df->Y;
  ZZ = df->Z;

  printf("new vector\n");

  nX = new_vector(szxyz);

  printf("begin reconstruct\n");

  if (have_vfile)
    {
      fp = fopen(vfile, "r");
      if (fp==NULL)
	{
	  printf("openning file %s failed, please use full path\n", vfile);
	  exit(0);
	}
      fscanf(fp, "%d", &vnumber);
      printf("%d\n", vnumber);
      v = (Vector **) calloc (vnumber, sizeof(Vector *));      
      for (i=0;i<vnumber;i++)
	{
	  fscanf(fp, "%d", &tempint);
	  v[i] = new_vector(tempint);
	  for (j=0;j<tempint;j++)
	    {
	      fscanf(fp, "%f", &tempfloat);
	      v[i]->value[j] = tempfloat;
	    }
	}
      fclose(fp);
      printf("read v finished\n");
    }  
  else if (have_inputdeformationfield)
  {
    printf("you have input deformationfield\n");
    idf = new_deformationfield(sizearray[0][0], sizearray[0][1], sizearray[0][2]);
    printf("reading %s\n", inputdeformationfield);
    read_deformationfield(idf, inputdeformationfield);
  }
  
  for (z=0;z<ZZ;z+=szz)
    for (y=0;y<YY;y+=szy)
      for (x=0;x<XX;x+=szx)
	{
	  printf("I am reconstructing block no. %d\n", pcaindex);

	  printf("reading data\n");

	  //  printf("reading file\n");
	  
	  sprintf(tempfilename, "%s_%d.model", tempstring, pcaindex);

	  if (have_modelfolder)
	    {
	      strcpy(tempname, modelfolder);
	      strcat(tempname, "/");
	      strcat(tempname, tempfilename);
	      strcpy(tempfilename, tempname);
	    }
	  
	  printf("%s\n", tempfilename);

	  gfp = fopen(tempfilename, "rb");
	  
	  if (gfp==NULL)
	    {
	      printf("reading file error\n");
	      exit(0);
	    }

	  fread(&tempint, sizeof(int), 1, gfp);
	  fread(&i, sizeof(int), 1, gfp);

	  printf("matrix size is %dx%d\n", tempint, i);

	  if (tempint!=szxyz)
	    {
	      printf("size does not match\b");
	      exit(0);
	    }

	  Phi = (Matrix *) calloc (1, sizeof(Matrix));
	  new_matrix(Phi, szxyz, i);

	  for (xx=0;xx<szxyz;xx++)
	    for (yy=0;yy<i;yy++)
	      {
		fread(&tempx, sizeof(float), 1, gfp);
		Phi->data[xx][yy] =(double) tempx;
	      }

	  lambda = new_vector(i);
	  for (xx=0;xx<i;xx++)
	    {
	      fread(&(tempx), sizeof(float), 1, gfp);
	      lambda->value[xx] = tempx;
	    }

	  if (have_number_of_pc)
	    {
	      if (i>number_of_pc)
		no_of_principal = number_of_pc;
	      else
		no_of_principal = i;
	    }
	  else if (have_percent)
	    {
	      total = 0.0;
	      subtotal = 0.0;
	      
	      for (xx=0;xx<i;xx++)
		{
		  total += lambda->value[xx];
		}
	      
	      for (xx=0;xx<i;xx++)
		{
		  subtotal += lambda->value[xx];
		  if (subtotal>percent*total)
		    break;
		}
	      
	      no_of_principal = xx;	  	  
	    }
	  else
	    {
	      no_of_principal = i;	      
	    }	  

	  if (pcaindex==0)
	    no_of_principal = i;

	  printf("actual size is %d x %d\n", szxyz, no_of_principal);

	  for (xx=0;xx<szxyz;xx++)
	    {
	      fread(&tempx, sizeof(float), 1, gfp);
	      AX->value[xx] = tempx;
	    }

	  bX = new_vector(no_of_principal);
	  if (have_vfile)
	    {
	      printf("I am using v file to construct the deformation field\n");
	      for (xx=0;xx<bX->size;xx++)
		{
		  bX->value[xx] = v[pcaindex]->value[xx];
		}		      
	    }
	  else if (have_inputdeformationfield)
	    {
	      index = 0;
	      for (zz=z;zz<z+szz;zz++)
		for (yy=y;yy<y+szy;yy++)
		  for (xx=x;xx<x+szx;xx++)
		    {
		      nX->value[index]=idf->point[zz][yy][xx].X;
		      index++;
		      nX->value[index]=idf->point[zz][yy][xx].Y;
		      index++;
		      nX->value[index]=idf->point[zz][yy][xx].Z;
		      index++;
		    }
	      for (xx=0;xx<szxyz;xx++)
		{
		  nX->value[xx] = nX->value[xx] - AX->value[xx];
		}
	      for (yy=0;yy<bX->size;yy++)
		{
		  bX->value[yy] = 0;
		  for (xx=0;xx<szxyz;xx++)
		    {
		      bX->value[yy] += nX->value[xx] * Phi->data[xx][yy];
		    }
		}

	      if (have_std)
		{
		  value_std = 0;
		  for (xx=0;xx<bX->size;xx++)
		    {
		      value_std += bX->value[xx] * bX->value[xx] / lambda->value[xx];
		    }
		  
		  value_std = value_std/bX->size;
		  
		  while (value_std>(double)value_std_threshold)
		    {
		      value_std = 0;
		      for (xx=0;xx<bX->size;xx++)
			{
			  bX->value[xx] = bX->value[xx] * .9;
			  value_std += bX->value[xx] * bX->value[xx] / lambda->value[xx];
			}
		      value_std = value_std/bX->size;	

		      printf("%f %f\n", value_std, value_std_threshold);
		      //getchar();
		    }
		  printf("press any key to continue\n");
		  //getchar();
		}

	    }	    
	  else if (havemodenumbertime)
	    {
	      for (xx=0;xx<bX->size;xx++)
		{
		  bX->value[xx] = 0;
		}
	      if ((modenumber>=0)&&(modetime<bX->size))
		bX->value[modenumber] = sqrt(lambda->value[modenumber]) * modetime;
	    }
	  else
	    {
	      if (have_number)
		for (zz=0;zz<file_number;zz++)
		  {
		    for (xx=0;xx<bX->size;xx++)
		      {
			fread(&tempx, sizeof(float), 1, gfp);
			bX->value[xx] = tempx;
		      }
		    if (zz==number)
		      break;
		  }
	      else
		{
		  for (xx=0;xx<bX->size;xx++)
		    {
		      randsign = rand();
		      if (randsign>RAND_MAX/2)
			randsign = 1;
		      else
			randsign = -1;
		      
		      if (have_magnitude_control)
			bX->value[xx] = gaussian_noise((float)(alpha*sqrt(lambda->value[xx]))*randsign, beta*beta*lambda->value[xx]);
		      else
			bX->value[xx] = gaussian_noise(0, (float)lambda->value[xx]);
		    }	      
		}
	    }
	  
	  fclose(gfp);

	  for (xx=0;xx<szxyz;xx++)
	    nX->value[xx] = 0.0;

	  for (xx=0;xx<szxyz;xx++)
	    {
	      for (yy=0;yy<no_of_principal;yy++)
		nX->value[xx] += Phi->data[xx][yy] * bX->value[yy];
	      nX->value[xx] += AX->value[xx];
	    }

	  //	  display_vector(nX);
	  //	  getchar();

	  index = 0;

	  for (zz=z;zz<z+szz;zz++)
	    for (yy=y;yy<y+szy;yy++)
	      for (xx=x;xx<x+szx;xx++)
		{
		  df->point[zz][yy][xx].X = (float) nX->value[index];
		  index++;
		  df->point[zz][yy][xx].Y = (float) nX->value[index];
		  index++;
		  df->point[zz][yy][xx].Z = (float) nX->value[index];
		  index++;
		}
	  
	  FreeMatrix(Phi);
	  free_vector(bX);
	  free_vector(lambda);

	  pcaindex ++;
	}


  if (have_inputdeformationfield)
    {
      free_deformationfield(idf);
    }
  
  //  Smooth_DeformationField(df, .5);
  write_deformationfield(df, deformationfield);
}




