/*******************************************************

This program performs image registration.

last modified : Aug 18 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program simulated deformations based on the PCA models generated by program pca_of_deformations\n\n");
  printf("inputs:\n\n%s filenamelist.txt pcamodel_base_filename -S subject_pts -M model_pts -o output.v.data -l lambda(weight for second term, default 0.1) [-j] [-P] [-e eta default:1.0] \n\n", filename);
  printf("\n");
  printf("-S subject pts file\n");
  printf("-M model pts file\n");
  printf("-o output v.data file\n");
  printf("-l lambda\n");
  printf("-e eta\n");
  printf("-j -- skip calculating the Matrix, default filename is Model11.WPT.Matrix\n");
  printf("-P -- skip calculating Ms, default Ms filename is Ms.Lambda.V.WPT.Matrix\n");
  
  printf("Note: this program runs LinuxGenerateWPTMatrix\n");
}

main(int argc, char *argv[])
{
  char inputfilelist[180];
  char command[200];
  char command1[200];
  char **filename, deformationfield[180], **filename_infor;
  char matrixfilename[180];
  char ptsfilename[180];
  char mptsfilename[180];
  char maskfilename[180];
  char tempfilename[180];
  char tempstring[180];
  int length;
  int have_magnitude_control;
  float alpha, beta;
  int randsign;
  int didconstrain;
  FPoints *pts, *epts, *mpts;

  DBox *dfx, *dfy, *dfz;

  int kkkk;
  SparseMatrix *sm;
  SparseMatrix **sms;
  sMCol * smc;
  sMCol * smcrow;

  FILE *fp, *gfp;

  FPoint FP, zero;

  int file_number;
  int number, Nnumber;
  int n;
  int i,j,k,kk,ii;
  int XX,YY,ZZ;
  int X,Y,Z;
  int x, y, z;
  int lx, ly, lz;
  int xx,yy,zz;
  int c;
  int smooth;
  int usemodel;
  int sw;
  int update_mask;
  int have_mask;
  int tempint;
  int tempheight, tempwidth;
  int have_number;
  int b8, s8;
  int box_index[64];
  int **sizearray;
  int **steparray;
  int szx, szy, szz, szxyz;
  int jump;
  int jumpP;
  int NUMBER;
  int NN, NNN;
  int ok;
  int *best_n;
  int size_of_history_window;
  int hisind;
  int pcaindex;
  int index;
  int history;

  float tempx, tempy, tempz;
  float percent;
  double total, subtotal;
  float value;
  float value1;
  float value_vector;
  float value_std;
  float eta, LAMBDA;
  float **Energy;
  float *finalEnergy;
  float *En;

  char nouse1[200], nouse2[200], nouse3[200];

  Deformation_Field *df;

  DBox *simg, *oimg;

  Matrix *Data, *Phi, **Ms;
  Vector **lambda, *AX, **sAX;

  Vector *bX, *nX;

  Vector ***v, *desiredf, **deltaf, *deltaff, ***vopt;

  smooth = 0;
  sw = 0;
  
  zero.X = 0.0;
  zero.Y = 0.0;
  zero.Z = 0.0;
  
  update_mask = 0;
  have_mask = 0;
  percent = 1.0;
  
  //  printf("begin\n");
  strcpy(tempstring, "DEFPCA");
  number = 1;

  strcpy(deformationfield, "output.field");
  have_magnitude_control = 0;
  alpha = 0;
  beta = 10;
  jump = 0;
  jumpP = 0;
  have_number = 0;
  LAMBDA = 0.1;
  eta = 1;
  if (argc<2)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilelist, argv[1]); 
      strcpy(tempstring, argv[2]); 

      c=getopt(argc-2,argv+2,"o:S:M:N:jl:e:P");
      while (c!=-1)
	{
	  switch(c)
	    {
	    case 'o':
	      sscanf(optarg, "%s", deformationfield);
	      break;
	    case 'S':
	      sscanf(optarg, "%s", ptsfilename);
	      break;
	    case 'M':
	      sscanf(optarg, "%s", mptsfilename);	      
	      break;
	    case 'j':
	      jump = 1;
	      break;
	    case 'P':
	      jumpP = 1;
	      break;
	    case 'e':
	      sscanf(optarg, "%f", &eta);
	      break;
	    case 'N':
	      sscanf(optarg, "%d", &Nnumber);
	      have_number = 1;
	      break;
	    case 'l':
	      sscanf(optarg, "%f", &LAMBDA);
	      break;
	    default:
	      break;
	    }	  
	  c=getopt(argc-2,argv+2,"o:S:M:N:jl:e:P");
	}
    }

  //  printf("begin\n");

  xz_randomize();

  //  for (ii=0;ii<200;ii++)
  //    printf("%f\n", gaussian_noise(0,1.0));
  //  getchar();
  
  fp = fopen(inputfilelist, "rt");
  if (fp==NULL)
    {
      printf("file %s does not exist\n", inputfilelist);
      exit(0);
    }
  else
    {
      //      printf("file opened\n");
    }
  
  fscanf(fp, "%d\n", &file_number);

  filename = (char **) calloc(file_number, sizeof(char *));
  filename_infor = (char **) calloc(file_number, sizeof(char *));
  sizearray = (int **) calloc(file_number, sizeof(int *));
  steparray = (int **) calloc(file_number, sizeof(int *));
  for (i=0;i<file_number;i++)
    {
      //      printf("%d\n", i);
      filename[i] = (char *) calloc(180, sizeof(char));
      filename_infor[i] = (char *) calloc(180, sizeof(char));
      sizearray[i] = (int *) calloc(3, sizeof(int));
      steparray[i] = (int *) calloc(3, sizeof(int));
    }

  for (i=0;i<file_number;i++)
    {
      fscanf(fp, "%s\n", filename[i]);
      sprintf(filename_infor[i], "%s.infor", filename[i]);
      //      printf("%s, %s\n", filename[i], filename_infor[i]);
    }

  fclose(fp);

  for (i=0;i<file_number;i++)
    {
      fp = fopen(filename_infor[i], "rt");

      fscanf(fp, "%s %s\n", nouse1, nouse2);
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &(sizearray[i][0]), &(sizearray[i][1]), &(sizearray[i][2]));
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &(steparray[i][0]), &(steparray[i][1]), &(steparray[i][2]));
      //      printf("%d %d %d %d %d %d\n", sizearray[i][0], sizearray[i][1], sizearray[i][2], steparray[i][0], steparray[i][1], steparray[i][2]);
      fclose(fp);
    }

  //  printf("here\n");

  szx = steparray[0][0];
  szy = steparray[0][1];
  szz = steparray[0][2];

  szx /= 2;
  szy /= 2;
  szz /= 2;

  szxyz = szx*szy*szz * 3;

  AX = new_vector(szxyz);

  //  printf("new deform\n");

  //  df = new_deformationfield(sizearray[0][0], sizearray[0][1], sizearray[0][2]);

  XX = sizearray[0][0];
  YY = sizearray[0][1];
  ZZ = sizearray[0][2];
  //  XX = df->X;
  //  YY = df->Y;
  //  ZZ = df->Z;

  pts = read_fpoints(ptsfilename);
  mpts = read_fpoints(mptsfilename);

  if (reorder_fpoints_twosets(mpts, pts))
    {
      printf("reorder both pts files\n");
    }

  //  display_fpoints(pts);
  //  display_fpoints(mpts);

  /*
  for (i=0;i<pts->Num;i++)
    {
      printf("%f,%f,%f - %f,%f,%f = ", pts->point[i].X, pts->point[i].Y, pts->point[i].Z,mpts->point[i].X, mpts->point[i].Y, mpts->point[i].Z);
      printf("%f,", pts->point[i].X - floorf(mpts->point[i].X +.5));
      printf("%f,", pts->point[i].Y - floorf(mpts->point[i].Y +.5));
      printf("%f\n", pts->point[i].Z - floorf(mpts->point[i].Z +.5));
    }
  */
  //  exit(0);

  epts = new_fpoints(pts->Num);

  sprintf(matrixfilename, "%s", "Model11.WPT.Matrix");
  if (jump==0)
    {
      sprintf(command, "LinuxGenerateWPTMatrix %s Model11.WPT.Matrix -d %d,%d,%d", mptsfilename, XX,YY,ZZ);
      printf("%s\n", command);
      system(command);
    }

  sm = read_smatrix(matrixfilename, &X, &Y, &Z);

  //  printf("sm read %d,%d,%d\n", X,Y,Z);

  if ((XX!=X)||(YY!=Y)||(ZZ!=Z))
    {
      printf("size mismatch\n");
      exit(0);
    }

  //  printf("new vector\n");

  // now we have to divide sm into 64 submatrix;
  // column index

  smc = make_index(sm);

  //  display_sMCol(smc, sm);
  //  getchar();

  sms = (SparseMatrix **) calloc (64, sizeof(SparseMatrix *));
  for (i=0;i<64;i++)
    sms[i] = (SparseMatrix *) calloc (1, sizeof(SparseMatrix));

  //  printf("smc->Num/64 = %d\n", smc->Num/64);

  for (j=0;j<64;j++)
    {
      number = 0;
      for (i=j*smc->Num/64;i<(j+1)*smc->Num/64;i++)
	{	
	  number += smc->N[i];
	}
      //      printf("%d : number = %d\n", j, number);
      sms[j]->N = number;
      sms[j]->height = sm->height;
      sms[j]->width = sm->width/64;
      sms[j]->x = (int *) calloc (sms[j]->N, sizeof(int));
      sms[j]->y = (int *) calloc (sms[j]->N, sizeof(int));
      sms[j]->value = (float *) calloc (sms[j]->N, sizeof(float));
      number = 0;
      for (i=j*smc->Num/64;i<(j+1)*smc->Num/64;i++)
	if (smc->N[i]>0)
	  {
	    for (k=0;k<smc->N[i];k++)
	      {
		sms[j]->x[number] = sm->x[smc->index[i][k]];
		sms[j]->y[number] = sm->y[smc->index[i][k]]-j*smc->Num/64;
		sms[j]->value[number] = sm->value[smc->index[i][k]];
		number ++;
	      }
	  }
      //      display_smatrix(sms[j]);
      //      getchar();
    }

  for (i=0;i<smc->Num;i++)
    {
      free(smc->index[i]);
    }
  free(smc->index);
  free(smc->N);
  free(smc);
  free_smatrix(sm);

  printf("begin optimization --- calculating Ms\n");

  Ms = (Matrix **) calloc (64, sizeof(Matrix *));

  for(number = 0; number<64;number++)
    {
      return_xyz(number, 4,4,4, &lx,&ly,&lz);
      x = lx % 2;
      y = ly % 2;
      z = lz % 2;
      xx = (lx - x)/2;
      yy = (ly - y)/2;
      zz = (lz - z)/2;
      s8 = z * 4 + y * 2 + x;
      b8 = zz * 4 + yy * 2 + xx;
      box_index[number] = b8 * 8 + s8;
      //      printf("%d->%d\n", number, box_index[number]);
    }

  //  printf("new memory\n");

  sAX = (Vector **) calloc (64, sizeof (Vector *));
  number = 0;
  //  printf("new memory Phi\n");
  Phi = (Matrix *) calloc (1, sizeof(Matrix));

  for (ii=0;ii<epts->Num;ii++)
    {
      epts->point[ii].X = 0;
      epts->point[ii].Y = 0;
      epts->point[ii].Z = 0;
    }

  pcaindex = 0;

  //  printf("new begin\n");

  lambda = (Vector **) calloc (64, sizeof(Vector *));


  // initialize of v

  NUMBER = 5;

  v = (Vector ***) calloc (NUMBER, sizeof(Vector **));
  for (i=0;i<NUMBER;i++)
    v[i] = (Vector **) calloc (64, sizeof(Vector *));

  if (!jumpP)
    {
    for (z=0;z<ZZ;z+=szz)
      for (y=0;y<YY;y+=szy)
	for (x=0;x<XX;x+=szx)
	  {
	    sprintf(tempfilename, "%s_%d.model", tempstring, pcaindex);
	    
	    gfp = fopen(tempfilename, "rb");
	    
	    if (gfp==NULL)
	      {
		printf("reading file error\n");
		exit(0);
	      }
	    
	    fread(&tempint, sizeof(int), 1, gfp);
	    fread(&i, sizeof(int), 1, gfp);
	    
	    //	  printf("matrix size is %dx%d\n", tempint, i);
	    
	    if (tempint!=szxyz)
	      {
		printf("size does not match\b");
		exit(0);
	      }
	    
	    new_matrix(Phi, szxyz, i);
	    
	    printf("reading Phi, No. %d\n", number);
	    for (xx=0;xx<szxyz;xx++)
	      for (yy=0;yy<i;yy++)
		{
		  fread(&tempx, sizeof(float), 1, gfp);
		  Phi->data[xx][yy] =(double) tempx;
		}
	    
	    lambda[number] = new_vector(i);
	    
	    for (n=0;n<NUMBER;n++)
	      v[n][number] = new_vector(i);
	    
	    for (xx=0;xx<i;xx++)
	      {
		fread(&(tempx), sizeof(float), 1, gfp);
		lambda[number]->value[xx] = tempx;
	      }	  
	    
	    //	  printf("entering smatrix x matrix scale3\n");
	    
	    Ms[number] = smatrix_times_matrix_scale3(sms[box_index[number]], Phi);
	    //	  printf("exiting\n");
	    
	    for (xx=0;xx<Phi->height;xx++)
	      free(Phi->data[xx]);
	    free(Phi->data);
	    
	    for (xx=0;xx<szxyz;xx++)
	      {
		fread(&tempx, sizeof(float), 1, gfp);
		AX->value[xx] = tempx;
	      }
	    
	    sAX[number] = new_vector(Ms[number]->height);
	    ii = 0;
	    smcrow = make_row_index(sms[box_index[number]]);
	    
	    //	  display_sMCol(smcrow, sms[box_index[number]]);
	    //	  getchar();
	    
	    for (j=0;j<smcrow->Num;j++)
	      {
		if (smcrow->N[j]>0)
		  {
		    sAX[number]->value[ii*3] = 0;
		    sAX[number]->value[ii*3+1] = 0;
		    sAX[number]->value[ii*3+2] = 0;
		    for (k=0;k<smcrow->N[j];k++)
		      {
			sAX[number]->value[ii*3] += sms[box_index[number]]->value[smcrow->index[j][k]] * AX->value[sms[box_index[number]]->y[smcrow->index[j][k]]*3];
			sAX[number]->value[ii*3+1] += sms[box_index[number]]->value[smcrow->index[j][k]] * AX->value[sms[box_index[number]]->y[smcrow->index[j][k]]*3+1];
			sAX[number]->value[ii*3+2] += sms[box_index[number]]->value[smcrow->index[j][k]] * AX->value[sms[box_index[number]]->y[smcrow->index[j][k]]*3+2];
		      }
		    ii++;
		  }
	      }
	    free_sMCol(smcrow);
	    
	    if (file_number<NUMBER)
	      for (zz=0;zz<file_number;zz++)
		{
		  for (xx=0;xx<i;xx++)
		    {
		      fread(&tempx, sizeof(float), 1, gfp);
		      v[zz][number]->value[xx] = tempx;
		    }		  
		}
	    else
	      {
		for (zz=0;zz<NUMBER;zz++)
		  {
		    for (xx=0;xx<i;xx++)
		      {
			fread(&tempx, sizeof(float), 1, gfp);
			v[zz][number]->value[xx] = tempx;
		      }		  
		  }	      
	      }
	    
	    /*
	      bX = new_vector(i);
	      
	      if (have_number)
	      for (zz=0;zz<file_number;zz++)
	      {
	      for (xx=0;xx<bX->size;xx++)
	      {
	      fread(&tempx, sizeof(float), 1, gfp);
	      bX->value[xx] = tempx;
	      }
	      if (zz==Nnumber)
	      break;
	      }
	      else
	      {
	      for (xx=0;xx<bX->size;xx++)
	      {
	      randsign = rand();
	      if (randsign>RAND_MAX/2)
	      randsign = 1;
	      else
	      randsign = -1;
	      
	      if (have_magnitude_control)
	      bX->value[xx] = gaussian_noise((float)(alpha*sqrt(lambda[number]->value[xx]))*randsign, beta*beta*lambda[number]->value[xx]);
	      else
	      bX->value[xx] = gaussian_noise(0, (float)lambda[number]->value[xx]);
	      }	      
	      
	      }
	    */
	    
	    fclose(gfp);
	    
	    //	  Mat_Print(Ms[number]);
	    
	    /*
	      for (ii=0;ii<epts->Num;ii++)
	      {
	      for (k=0;k<i;k++)
	      {
	      epts->point[ii].X += Ms[number]->data[ii*3][k] * bX->value[k]; 
	      epts->point[ii].Y += Ms[number]->data[ii*3+1][k] * bX->value[k]; 
	      epts->point[ii].Z += Ms[number]->data[ii*3+2][k] * bX->value[k];
	      }
	      epts->point[ii].X += sAX[number]->value[ii*3];
	      epts->point[ii].Y += sAX[number]->value[ii*3+1];
	      epts->point[ii].Z += sAX[number]->value[ii*3+2];
	      }
	    */
	    
	    //	  display_fpoints(epts);
	    
	    number++;
	    pcaindex ++;
	  }
    for (n=file_number;n<NUMBER;n++)
      {
	for (i=0;i<64;i++)
	  for (j=0;j<v[n][i]->size;j++)
	    v[n][i]->value[j] = gaussian_noise(0, lambda[i]->value[j]);
      }

    fp = fopen("Ms.Lambda.V.WPT.Matrix", "wb");
    if (fp==NULL)
      {
	printf("writing Ms fail\n");
	exit(0);
      }

    for (number=0;number<64;number++)
      {
	fwrite(&(lambda[number]->size), sizeof(int), 1, fp);
	for (i=0;i<lambda[number]->size;i++)
	  {
	    tempx = (float)lambda[number]->value[i];
	    fwrite(&tempx, sizeof(float), 1, fp);
	  }

	fwrite(&(Ms[number]->height), sizeof(int), 1, fp);
	fwrite(&(Ms[number]->width), sizeof(int), 1, fp);
	for (i=0;i<Ms[number]->height;i++)
	  for (j=0;j<Ms[number]->width;j++)
	    {
	      tempx = (float) Ms[number]->data[i][j];
	      fwrite(&tempx, sizeof(float), 1, fp);
	    }

	for (i=0;i<sAX[number]->size;i++)
	  {
	    tempx = (float) sAX[number]->value[i];
	    fwrite(&tempx, sizeof(float), 1, fp);
	  }
      }    

    for (n=0;n<NUMBER;n++)
      for (number=0;number<64;number++)
	for (i=0;i<lambda[number]->size;i++)
	  {
	    tempx = (float) v[n][number]->value[i];
	    fwrite(&tempx, sizeof(float), 1, fp);
	  }

    fclose(fp);
    }
  else
    {
      printf("reading Ms data\n");
      fp = fopen("Ms.Lambda.V.WPT.Matrix", "rb");
      if (fp==NULL)
	{
	  printf("reading Ms fail\n");
	  exit(0);
	}      
      //      printf("file open\n");

      for (number=0;number<64;number++)
	{
	  //	  printf("number = %d\n", number);
	  fread(&tempint, sizeof(int), 1, fp);
	  lambda[number] = new_vector(tempint);
	  
	  //	  printf("lambda new done\n");

	  for (i=0;i<lambda[number]->size;i++)
	    {
	      fread(&tempx, sizeof(float), 1, fp);
	      lambda[number]->value[i] = tempx;
	    }
	  //	  printf("lambda read done\n");

	  fread(&(tempheight), sizeof(int), 1, fp);
	  fread(&(tempwidth), sizeof(int), 1, fp);

	  Ms[number] = (Matrix *) calloc (1, sizeof(Matrix));

	  new_matrix(Ms[number], tempheight, tempwidth);
	  //	  printf("Ms size = %d x %d\n", Ms[number]->height, Ms[number]->width);

	  //	  printf("matrix new done\n");
	  for (i=0;i<Ms[number]->height;i++)
	    for (j=0;j<Ms[number]->width;j++)
	      {
		fread(&tempx, sizeof(float), 1, fp);
		Ms[number]->data[i][j] = tempx;
	      }
	  //	  printf("matrix read done\n");

	  sAX[number] = new_vector(Ms[number]->height);
	  for (i=0;i<sAX[number]->size;i++)
	    {
	      fread(&tempx, sizeof(float), 1, fp);
	      sAX[number]->value[i] = tempx;
	    }
	}

      for (n=0;n<NUMBER;n++)
	for (number=0;number<64;number++)
	  {
	    v[n][number] = new_vector(lambda[number]->size);
	    for (i=0;i<lambda[number]->size;i++)
	      {
		fread(&tempx, sizeof(float), 1, fp);
		v[n][number]->value[i] = tempx;
	      }      
	  }      
      
      fclose(fp);
    }  

  // now begin optimization;

  // initialize v randomly
  
  desiredf = new_vector(pts->Num * 3);
  for (i=0;i<pts->Num;i++)
    {
      mpts->point[i].X = floorf(mpts->point[i].X + 0.5);
      mpts->point[i].Y = floorf(mpts->point[i].Y + 0.5);
      mpts->point[i].Z = floorf(mpts->point[i].Z + 0.5);
      desiredf->value[i*3] = pts->point[i].X - mpts->point[i].X;
      desiredf->value[i*3+1] = pts->point[i].Y - mpts->point[i].Y;
      desiredf->value[i*3+2] = pts->point[i].Z - mpts->point[i].Z;
    }

  //  LAMBDA = .2;

  deltaf = (Vector **) calloc (64, sizeof(Vector *));
  for (i=0;i<64;i++)    
    deltaf[i] = new_vector(pts->Num * 3);
  deltaff = new_vector(pts->Num * 3);

  Energy = (float **) calloc (NUMBER, sizeof(float *));
  finalEnergy = (float *) calloc (NUMBER, sizeof(float));
  for (i=0;i<NUMBER;i ++)
    Energy[i] = (float *) calloc (10000, sizeof(float));

  En = (float *) calloc (NUMBER, sizeof(float));

  NN = 5;
  best_n = (int *) calloc (NN, sizeof(int));

  vopt = (Vector ***) calloc (NN, sizeof(Vector **));
  for (i=0;i<NN;i++)
    {
      vopt[i] = (Vector **)calloc(64, sizeof(Vector *));
 
      for (j=0;j<64;j++)
	{
	  vopt[i][j] = new_vector(lambda[j]->size);  
	  //	  printf("voptsize = %d, %d\n", i,vopt[i][j]->size);
	}
    }

  printf("begin iteration\n");

  size_of_history_window = 150;

  for (kkkk=0;kkkk<2;kkkk++)
    {
      didconstrain = 0;
      for (n = 0; n<NUMBER; n++)
	{
	  printf("kkkk=%d, n =%d\n", kkkk,n);
	  for (number = 0; number<10000; number++)
	    {      
	      //	      printf("%d, %d\n", n,number);
	      Energy[n][number] = 0;
	      
	      value = 0;
	      value1 = 0;

	      for (k=0;k<deltaff->size;k++)
		deltaff->value[k] = 0;

	      //	      printf("ok\n");
	      for (i=0;i<64;i++)
		{
		  for (k=0;k<Ms[i]->height;k++)
		    {
		      deltaf[i]->value[k] = 0;	  
		      for (j=0;j<v[n][i]->size;j++)
			{
			  //			  printf("%d %d %d, %d\n", i,k,j,v[n][i]->size );
			  deltaf[i]->value[k] += Ms[i]->data[k][j] * v[n][i]->value[j];
			}
		      deltaf[i]->value[k] += sAX[i]->value[k];
		      deltaff->value[k] += deltaf[i]->value[k];
		    }
		}

	      value_vector = 0;
	      for (k=0;k<deltaff->size;k++)
		{
		  deltaff->value[k] = deltaff->value[k] - desiredf->value[k];
		  value_vector += deltaff->value[k] * deltaff->value[k];
		}
	      value_vector = value_vector/deltaff->size;

	      //	      printf("ok\n");
	      value = value_vector;

	      for (i=0;i<64;i++)
		{
		  value_std = 0;
		  for (j=0;j<v[n][i]->size;j++)
		    {
		      value_std += v[n][i]->value[j] * v[n][i]->value[j] / lambda[i]->value[j];
		    }
		  value_std = value_std/v[n][i]->size;
		  value1 = value1 + value_std;
		}
	      
	      //     printf("%d : %f   ", i, value);
	  
	      Energy[n][number] = value + value1 * LAMBDA;
	      En[number] = 0;
	      for (history = 0; history<size_of_history_window; history++)
		{
		  hisind = number - history;
		  if (hisind>=0)
		    En[number] += Energy[n][hisind];
		}	      
	      
	      //	      printf("iteration %d : Energy function %f = %f + %f --- %f\n", number, Energy[n][number], value, value1, En[number]);

	      if (number>1)
		{
		  if (number>size_of_history_window)
		    if (En[number]>En[number-1])
		      {
			finalEnergy[n] = Energy[n][number];
			//			printf("break iteration\niteration %d, %f\n", number, finalEnergy[n]);
			//			getchar();
			break;
		      }

		  //		  if (En[number]<En[number-1])
		  //		    printf("yes\n");
		  //		  else
		  //		    printf("no\n");
		  /*
		  if (didconstrain==0)
		    {
		      //		      printf("no constraint\n");
		      if (Energy[n][number]>Energy[n][number-1])
			{
			  finalEnergy[n] = Energy[n][number];
			  //		      finalEnergy[n] = value;
			  printf("break iteration\niteration %d, %f\n", number, finalEnergy[n]);
			  getchar();
			  break;
			  didconstrain = 1;
			}
		    }
		  else
		    {
		      didconstrain = 0;
		      //		      printf("yes constraint\n");
		    }
		  */
		}
	      else
		{
		  finalEnergy[n] = 1000000000;	      
		  //		  printf("\n");
		}

	      //	      printf("final energy = %f\n", finalEnergy[n]);
	      
	      for (i=0;i<64;i++)
		for (j=0;j<v[n][i]->size;j++)
		  {
		    value = 0;
		    
		    for(k=0;k<deltaf[i]->size;k++)
		      {
			value += Ms[i]->data[k][j] * deltaff->value[k];
		      }
		    
		    value = value * 2.0 / deltaff->size;
		    value = value + LAMBDA * 2 * v[n][i]->value[j] / lambda[i]->value[j] / v[n][i]->size;
		    value = -1 * value * eta;
		    //		  printf("n=%3d i=%3d j=%3d, value = %f\n", n, i,j, value);
		    v[n][i]->value[j] += value;
		  }


	      //constrain

	      for (i=0;i<64;i++)
		{
		  value_std = 0;
		  for (j=0;j<v[n][i]->size;j++)
		    {
		      value_std += v[n][i]->value[j] * v[n][i]->value[j] / lambda[i]->value[j];
		    }
		  value_std = value_std/v[n][i]->size;
		  //		  printf("%f ", value_std);
		  
		  while (value_std>4.0)
		    {
		      value_std = 0;
		      for (j=0;j<v[n][i]->size;j++)
			{
			  v[n][i]->value[j] = v[n][i]->value[j] * .9;
			  value_std += v[n][i]->value[j] * v[n][i]->value[j] / lambda[i]->value[j];
			}
		      value_std = value_std/v[n][i]->size;		  
		      didconstrain = 1;
		    }
		}

	      	      
	    }
	}
 
      printf("finish iteration\n");
  
      for (ii=0;ii<NUMBER;ii++)
	{
	  printf("NUM: %d, %f\n", ii, finalEnergy[ii]);
	}
      
      value = finalEnergy[0];
      n = 0;
      for (ii=0;ii<NUMBER;ii++)
	{
	  if (value<finalEnergy[ii])
	    {
	      value = finalEnergy[ii];
	      n = ii;
	    }
	}
      
      for (k=0;k<NN;k++)
	{
	  value = finalEnergy[n];
	  best_n[k] = n;
	  for (ii=1;ii<NUMBER;ii++)
	    {
	      ok = 1;
	      for (kk=0;kk<k;kk++)
		if (ii==best_n[kk])
		  ok = 0;
	      
	      if ((value>finalEnergy[ii])&&(ok))
		{
		  value = finalEnergy[ii];
		  best_n[k] = ii;
		}
	    }
	  printf("Best %d = %d\n", k, best_n[k]);
	}  
      
      for (k=0;k<NN;k++)
	{
	  printf("%d\n", best_n[k]);
	}

      for (k=0;k<NN;k++)
	{
	  printf("k = %d\n", k);
	  for (i=0;i<64;i++)
	    {
	      printf("k = %d, i = %d\n", k, i);
	      printf("v size = %d\n",  v[best_n[k]][i]->size);
	      printf("vopt size = %d\n", vopt[k][i]->size);
	      for (ii=0;ii<vopt[k][i]->size;ii++)
		{
		  printf("ii =%d\n", ii);
		  vopt[k][i]->value[ii] = v[best_n[k]][i]->value[ii];
		}
	    }
	}

      printf("here\n");

      NNN = NUMBER / NN;
      for (k=0;k<NUMBER;k++)
	{
	  printf("k = %f\n", k);
	  kk = k % NNN;
	  if (kk>NN-1)
	    kk = NN-1;

	  for (i=0;i<64;i++)
	    {
	      for (j=0;j<v[k][i]->size;j++)
		v[k][i]->value[j] = gaussian_noise(vopt[kk][i]->value[j], (float)lambda[i]->value[j]/16);
	    }
	}

      printf("begin another iteration\n");
    }
  
  //  printf("desired epts\n");
  //  display_fpoints(epts);
  
  for (ii=0;ii<epts->Num;ii++)
    {
      epts->point[ii].X = 0;
      epts->point[ii].Y = 0;
      epts->point[ii].Z = 0;
    }

  for (ii=0;ii<epts->Num;ii++)
    {
      for (number = 0; number < 64; number++)
	{
	  for (k=0;k<Ms[number]->width;k++)
	    {
	      epts->point[ii].X += Ms[number]->data[ii*3][k] * vopt[0][number]->value[k]; 
	      epts->point[ii].Y += Ms[number]->data[ii*3+1][k] * vopt[0][number]->value[k]; 
	      epts->point[ii].Z += Ms[number]->data[ii*3+2][k] * vopt[0][number]->value[k];
	    }
	  epts->point[ii].X += sAX[number]->value[ii*3];
	  epts->point[ii].Y += sAX[number]->value[ii*3+1];
	  epts->point[ii].Z += sAX[number]->value[ii*3+2];
	}
    }  

  //  printf("actual epts\n");
  //  display_fpoints(epts);

  fp = fopen(deformationfield, "w");
    fprintf(fp, "%d\n", 64);
  for (i=0;i<64;i++)
    {
      fprintf(fp, "%d\n", vopt[0][i]->size);
      for (j=0;j<vopt[0][i]->size;j++)
	fprintf(fp, "%f\n", vopt[0][i]->value[j]);
    }
  fclose(fp);

  printf("v.data file %s is written\n", deformationfield);

}




