/*******************************************************

This program performs image registration.

last modified : Aug 18 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program generate the wpt of jacobians based on the PCA models, 1. randomly generate, 2. project an input jacobian onto the statistical space.\n\n");
  printf("inputs:\n\n%s filenamelist.txt pcamodel_base_filename -N num -o outputjacobian -i inputjacobian [-m alpha,beta] [-v v.data]\n\n", filename);
  printf("\n");
}

main(int argc, char *argv[])
{
  char inputfilelist[180];

  char **filename, deformationfield[180], **filename_infor;
  char maskfilename[180];
  char injacobianfilename[200];
  char vfile[200];
  char tempfilename[180];
  char tempstring[180];
  int length;
  int have_magnitude_control;
  float alpha, beta;
  int randsign;

  DBox *jacobian;

  FILE *fp, *gfp;

  FPoint FP, zero;

  int file_number;
  int number;
  int i,j;
  int XX,YY,ZZ;
  int x, y, z;
  int lx, ly, lz;
  int xx,yy,zz;
  int c;
  int smooth;
  int usemodel;
  int sw;
  int update_mask;
  int have_mask;
  int tempint;
  float tempfloat;
  int have_number;
  int have_injacobian;

  int **sizearray;
  int **steparray;
  int szx, szy, szz, szxyz;
  int oXX,oYY,oZZ;

  int pcaindex;
  int index;
  int have_vfile, vnumber;
  float tempx, tempy, tempz;

  double sum;

  double total, subtotal;
  int no_of_principal;

  char nouse1[200], nouse2[200], nouse3[200];

  DBox *simg, *oimg;

  Matrix *Data, *Phi;
  Vector *lambda, *AX;

  Vector *bX, *nX;
  Vector **v;

  smooth = 0;
  sw = 0;
  
  zero.X = 0.0;
  zero.Y = 0.0;
  zero.Z = 0.0;
  
  update_mask = 0;
  have_mask = 0;
  
  //  printf("begin\n");
  strcpy(tempstring, "DEFPCA");
  number = 1;

  strcpy(deformationfield, "output.field");
  have_vfile = 0;
  have_number = 0;
  have_injacobian = 0;
  if (argc<2)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilelist, argv[1]); 
      strcpy(tempstring, argv[2]); 

      c=getopt(argc-2,argv+2,"N:o:m:v:i:");
      while (c!=-1)
	{
	  switch(c)
	    {
	    case 'N':
	      sscanf(optarg, "%d", &number);
	      have_number = 1;
	      break;
	    case 'o':
	      sscanf(optarg, "%s", deformationfield);
	      break;
	    case 'i':
	      sscanf(optarg, "%s", injacobianfilename);
	      have_injacobian = 1;
	      break;
	    case 'm':
	      have_magnitude_control = 1;
	      sscanf(optarg, "%f,%f", &alpha, &beta);
	      break;
	    case 'v':
	      sscanf(optarg, "%s", vfile);
	      have_vfile = 1;
	      break;
	    default:
	      break;
	    }	  
	  c=getopt(argc-2,argv+2,"N:o:m:v:i:");
	}
    }

  xz_randomize();

  fp = fopen(inputfilelist, "rt");
  if (fp==NULL)
    {
      printf("file does not exist\n");
      exit(0);
    }
  else
    {
      printf("file opened\n");
    }
  
  fscanf(fp, "%d\n", &file_number);

  filename = (char **) calloc(file_number, sizeof(char *));
  filename_infor = (char **) calloc(file_number, sizeof(char *));
  sizearray = (int **) calloc(file_number, sizeof(int *));
  steparray = (int **) calloc(file_number, sizeof(int *));
  for (i=0;i<file_number;i++)
    {
      printf("%d\n", i);
      filename[i] = (char *) calloc(180, sizeof(char));
      filename_infor[i] = (char *) calloc(180, sizeof(char));
      sizearray[i] = (int *) calloc(3, sizeof(int));
      steparray[i] = (int *) calloc(3, sizeof(int));
    }

  for (i=0;i<file_number;i++)
    {
      fscanf(fp, "%s\n", filename[i]);
      sprintf(filename_infor[i], "%s.infor", filename[i]);
      printf("%s, %s\n", filename[i], filename_infor[i]);
    }

  fclose(fp);

  for (i=0;i<file_number;i++)
    {
      fp = fopen(filename_infor[i], "rt");

      fscanf(fp, "%s %s\n", nouse1, nouse2);
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &(sizearray[i][0]), &(sizearray[i][1]), &(sizearray[i][2]));
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &(steparray[i][0]), &(steparray[i][1]), &(steparray[i][2]));
      printf("%d %d %d %d %d %d\n", sizearray[i][0], sizearray[i][1], sizearray[i][2], steparray[i][0], steparray[i][1], steparray[i][2]);
      fscanf(fp, "%s %s %s\n", nouse1, nouse2, nouse3);
      sscanf(nouse3, "%d,%d,%d", &oXX,&oYY,&oZZ);
      fclose(fp);

      if ((oXX>sizearray[i][0])||(oYY>sizearray[i][1])||(oZZ>sizearray[i][2]))
	{
	  printf("The size in file %s is not OK, check it!\n", filename_infor[i]);
	  exit(0);
	}
    }

  printf("here\n");

  szx = steparray[0][0];
  szy = steparray[0][1];
  szz = steparray[0][2];

  szx /= 2;
  szy /= 2;
  szz /= 2;

  pcaindex = 0;

  szxyz = szx*szy*szz;

  AX = new_vector(szxyz);

  printf("new deform\n");

  simg = new_dbox(sizearray[0][0], sizearray[0][1], sizearray[0][2]);
  //  oimg = new_dbox(oXX, oYY, oZZ);

  XX = simg->X;
  YY = simg->Y;
  ZZ = simg->Z;

  printf("new vector\n");

  nX = new_vector(szxyz);

  printf("begin reconstruct\n");

  if (have_vfile)
    {
      fp = fopen(vfile, "r");
      fscanf(fp, "%d", &vnumber);
      printf("%d\n", vnumber);
      v = (Vector **) calloc (vnumber, sizeof(Vector *));      
      for (i=0;i<vnumber;i++)
	{
	  fscanf(fp, "%d", &tempint);
	  v[i] = new_vector(tempint);
	  for (j=0;j<tempint;j++)
	    {
	      fscanf(fp, "%f", &tempfloat);
	      v[i]->value[j] = tempfloat;
	    }
	}
      fclose(fp);
    }  

  if (have_injacobian)
    {
      jacobian = new_dbox(XX,YY,ZZ);
      read_dbox(jacobian, injacobianfilename, "float");
    }

  printf("read v finished\n");

  for (z=0;z<ZZ;z+=szz)
    for (y=0;y<YY;y+=szy)
      for (x=0;x<XX;x+=szx)
	{
	  /*
	  if (have_injacobian)
	    if (pcaindex == 0)
	      {
		for (zz=z;zz<z+szz;zz++)
		  for (yy=y;yy<y+szy;yy++)
		    for (xx=x;xx<x+szx;xx++)
		      {
			simg->box[zz][yy][xx] = jacobian->box[zz][yy][xx];
		      }
		pcaindex ++;
		break;
	      }
	  */

	  printf("I am reconstructing block no. %d\n", pcaindex);

	  printf("reading data\n");

	  //  printf("reading file\n");
	  
	  sprintf(tempfilename, "%s_%d.model", tempstring, pcaindex);
	  
	  gfp = fopen(tempfilename, "rb");
	  
	  if (gfp==NULL)
	    {
	      printf("reading file error\n");
	      exit(0);
	    }

	  fread(&tempint, sizeof(int), 1, gfp);
	  fread(&i, sizeof(int), 1, gfp);

	  printf("matrix size is %dx%d\n", tempint, i);

	  if (tempint!=szxyz)
	    {
	      printf("size does not match\n");
	      exit(0);
	    }

	  Phi = (Matrix *) calloc (1, sizeof(Matrix));
	  new_matrix(Phi, szxyz, i);

	  for (xx=0;xx<szxyz;xx++)
	    for (yy=0;yy<i;yy++)
	      {
		fread(&tempx, sizeof(float), 1, gfp);
		Phi->data[xx][yy] =(double) tempx;
	      }

	  lambda = new_vector(i);
	  for (xx=0;xx<i;xx++)
	    {
	      fread(&(tempx), sizeof(float), 1, gfp);
	      lambda->value[xx] = tempx;
	    }

	  no_of_principal = i;	  	  
	  printf("actual size is %d x %d\n", szxyz, no_of_principal);

	  for (xx=0;xx<szxyz;xx++)
	    {
	      fread(&tempx, sizeof(float), 1, gfp);
	      AX->value[xx] = tempx;
	    }

	  bX = new_vector(i);

	  if (have_vfile)
	    {
	      printf("I am using v file to construct the deformation field\n");
	      for (xx=0;xx<bX->size;xx++)
		{
		  bX->value[xx] = v[pcaindex]->value[xx];
		}		      
	    }
	  else if (have_injacobian)
	    {
	      j = 0;
	      for (zz=z;zz<z+szz;zz++)
		for (yy=y;yy<y+szy;yy++)
		  for (xx=x;xx<x+szx;xx++)
		    {
		      nX->value[j] = jacobian->box[zz][yy][xx];
		      j++;
		    }
	      for (xx=0;xx<szxyz;xx++)
		{
		  nX->value[xx] = nX->value[xx] - AX->value[xx];
		}

	      for (j=0;j<no_of_principal;j++)
		{
		  bX->value[j] = 0;
		  for (xx=0;xx<szxyz;xx++)
		    {
		      bX->value[j] = bX->value[j] + Phi->data[xx][j] * nX->value[xx];
		    }
		}

	      sum = 0;
	      for (j=0;j<no_of_principal;j++)
		{
		  sum += bX->value[j] * bX->value[j] / lambda->value[j];
		}	      
	      sum = sum / no_of_principal;
	      while (sum>2.5)
		{		  
		  sum = 0;
		  for (j=0;j<no_of_principal;j++)
		    {
		      bX->value[j] = bX->value[j] * .9;
		      sum += bX->value[j] * bX->value[j] / lambda->value[j];
		    }	      
		  sum = sum / no_of_principal;
		  printf("sum = %f\n", sum);
		}
	    }
	  else //randomly generate
	    {
	      if (have_number)
		for (zz=0;zz<file_number;zz++)
		  {
		    for (xx=0;xx<bX->size;xx++)
		      {
			fread(&tempx, sizeof(float), 1, gfp);
			bX->value[xx] = tempx;
		      }
		    if (zz==number)
		      break;
		  }
	      else
		{
		  for (xx=0;xx<bX->size;xx++)
		    {
		      randsign = rand();
		      if (randsign>RAND_MAX/2)
			randsign = 1;
		      else
			randsign = -1;
		      
		      if (have_magnitude_control)
			bX->value[xx] = gaussian_noise((float)(alpha*sqrt(lambda->value[xx]))*randsign, beta*beta*lambda->value[xx]);
		      else
			bX->value[xx] = gaussian_noise(0, (float)lambda->value[xx]);
		    }	      
		}
	    }
	  
	  fclose(gfp);

	  for (xx=0;xx<szxyz;xx++)
	    nX->value[xx] = 0.0;

	  for (xx=0;xx<szxyz;xx++)
	    {
	      for (yy=0;yy<no_of_principal;yy++)
		nX->value[xx] += Phi->data[xx][yy] * bX->value[yy];
	      nX->value[xx] += AX->value[xx];
	    }

	  //	  display_vector(nX);
	  //	  getchar();

	  index = 0;

	  for (zz=z;zz<z+szz;zz++)
	    for (yy=y;yy<y+szy;yy++)
	      for (xx=x;xx<x+szx;xx++)
		{
		  simg->box[zz][yy][xx] = (float) nX->value[index];
		  index++;
		}

	  FreeMatrix(Phi);
	  free_vector(bX);
	  free_vector(lambda);

	  pcaindex ++;
	}

  write_dbox(simg, deformationfield, "float", 1);
}




