/* this program generates the multi-resolution images

Jon Z. Xue

Jan 10 2002
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s imagefile outputfile [options]\n", filename);
  printf("-d <int,int,int>\n");
  printf("-s <int,int,int,int,int,int>\n");
  printf("-G , optional, gradually change to 0.\n");
  
  printf("\n");
}

main(int argc, char *argv[])
{
  char  inputfilename[180], outputfilename[180];

  Deformation_Field *odf, *tdf;

  char ch1, ch2, ch, chs;
  char format[20];
  int direction,ok;
  int use_original;
  int value;
  int XX,YY,ZZ,x,y,z;
  int bx,by,bz,ex,ey,ez;
  int nx,ny,nz;
  float rx,ry,rz;
  int gradual;
  int do_newsize, newsize;
  int mark;

  int one, two, vary;
  int change, reverse;
  int c;
  int threshold;

  ok = 0;
  change = 0;
  reverse = 0;
  do_newsize = 0;
  gradual = 0;
  mark =0;

  strcpy(format, "byte");
  if (argc<2)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilename, argv[1]); 
      strcpy(outputfilename, argv[2]); 

      c=getopt(argc-2,argv+2,"d:s:G");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 's':
	      sscanf(optarg, "%d,%d,%d,%d,%d,%d", &bx,&ex,&by,&ey,&bz,&ez);
	      break;
	    case 'G':
	      gradual = 1;
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:s:G");
	}
    }
  
  printf("[%d,%d,%d]\n", XX,YY,ZZ);

  odf = new_deformationfield(XX,YY,ZZ);
  tdf = new_deformationfield(ex-bx+1,ey-by+1,ez-bz+1);

  read_deformationfield_with_switch(tdf, inputfilename,0);

  for (z=bz;z<bz+tdf->Z;z++)
    for (y=by;y<by+tdf->Y;y++)
      for (x=bx;x<bx+tdf->X;x++)
	{
	  odf->point[z][y][x].X = tdf->point[z-bz][y-by][x-bx].X;
	  odf->point[z][y][x].Y = tdf->point[z-bz][y-by][x-bx].Y;
	  odf->point[z][y][x].Z = tdf->point[z-bz][y-by][x-bx].Z;
	}

  if (gradual)
    for (z=0;z<odf->Z;z++)
      for (y=0;y<odf->Y;y++)
	for (x=0;x<odf->X;x++)
	  {
	    mark = 0;
	    rx = 1.0;
	    ry = 1.0;
	    rz = 1.0;

	    nx = x;
	    ny = y;
	    nz = z;
	    
	    if (x<bx)
	      {
		rx = 1.0 - (float)(bx - x)/bx;	      
		nx = bx;
		mark = 1;
	      }
	    if (y<by)
	      {
		ry = 1.0 - (float)(by - y)/by;	      
		ny = by;
		mark = 1;
	      }
	    if (z<bz)
	      {
		rz = 1.0 - (float)(bz - z)/bz;	    
		nz = bz;
		mark = 1;
	      }
	    if (x>=ex)
	      {
		rx = 1.0 - (float)(x-ex)/(odf->X-ex);	  
		nx = ex;
		mark = 1;
	      }
	    if (y>=ey)
	      {
		ry = 1.0 - (float)(y-ey)/(odf->Y-ey);
		ny = ey;
		mark = 1;
	      }
	    if (z>=ez)
	      {
		rz = 1.0 - (float)(z-ez)/(odf->Z-ez);
		nz = ez;
		mark = 1;
	      }
	    
	    if (mark)
	      {
		odf->point[z][y][x].X = odf->point[nz][ny][nx].X * rx*ry*rz;
		odf->point[z][y][x].Y = odf->point[nz][ny][nx].Y * rx*ry*rz;
		odf->point[z][y][x].Z = odf->point[nz][ny][nx].Z * rx*ry*rz;	  
	      }
	  }
  
  write_deformationfield_with_switch(odf, outputfilename, 0);
}








