#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>


extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("tag worldtovoxel file\n");
  printf("read_tag ptsfile mncfile outputvoxelpoints [sequence -s X,Y,Z]\n");
}

main(int argc, char *argv[])
{
  char tagfile[200], mncfile[200], outputptsfile[200];

  char buff[500]; char ch;

  FILE *fp;

  double tempx, tempy, tempz;

  int c;
  int dontuse;

  FPoints *ipts, *opts;

  int N;

  int i;
  int Num;

  dontuse = 0;

  char s1, s2, s3;

  s1 = 'Z';
  s2 = 'Y';
  s3 = 'X';
  
  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(tagfile, argv[1]); 
      strcpy(mncfile, argv[2]);
      strcpy(outputptsfile, argv[3]);      

      c=getopt(argc-3,argv+3,"s:");
      while (c!=-1)
	{
	  switch(c)
	    {
	    case 's':
	      sscanf(optarg, "%c,%c,%c", &s1, &s2, &s3);
	      break;
	    default:
	      printf("option error\n");
	      break;
	    }
	  c=getopt(argc-3,argv+3,"s:");
	}
    }

  printf("sequence %c,%c,%c\n", s1, s2, s3);

  ipts = read_fpoints(tagfile);
  opts = new_fpoints(ipts->Num);

  //  display_fpoints(ipts);

  printf("please dont worry about the following error:\n");
  sprintf(buff, "rm %s", outputptsfile);
  //  printf("%s\n", buff);
  system(buff);
  printf("that is it\n");
  sprintf(buff, "echo %d >> %s", ipts->Num, outputptsfile);
  //  printf("%s\n", buff);
  system(buff);
  
  for (i=0;i<ipts->Num;i++)
    {
      sprintf(buff, "worldtovoxel %s %f %f %f >> %s", mncfile, (ipts->point[i].X), (ipts->point[i].Y), (ipts->point[i].Z), outputptsfile);
      //      printf("%s\n", buff);
      system(buff);
    }
  
  fp = fopen(outputptsfile, "rt");
  
  fscanf(fp, "%d\n", &Num);
  //  printf("%d\n", Num);
  
  for (i=0;i<Num;i++)
    {
      fscanf(fp, "%lf %lf %lf", &tempx, &tempy, &tempz);

      //      printf("%f %f %f --->", tempx, tempy, tempz);

      switch(s1)
	{
	case 'X':
	  opts->point[i].X = tempx;	  
	  break;
	case 'Y':
	  opts->point[i].X = tempy;
 	  break;
	case 'Z':
	  opts->point[i].X = tempz;      
 	  break;
	default:
	  break;
	}
       switch(s2)
	{
	case 'X':
	  opts->point[i].Y = tempx;	  
	  break;
	case 'Y':
	  opts->point[i].Y = tempy;
 	  break;
	case 'Z':
	  opts->point[i].Y = tempz;      
 	  break;
	default:
	  break;
	}
      switch(s3)
	{
	case 'X':
	  opts->point[i].Z = tempx;	  
	  break;
	case 'Y':
	  opts->point[i].Z = tempy;
 	  break;
	case 'Z':
	  opts->point[i].Z = tempz;      
 	  break;
	default:
	  break;
	}

      //      printf("%f %f %f\n", opts->point[i].X, opts->point[i].Y, opts->point[i].Z);
   }
  
  fclose(fp);
  
  write_fpoints(opts, outputptsfile);
}



