/*!
 * \file function.h
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#ifndef _FUNCTIONS
#define _FUNCTIONS

//#include "ConservLaw.h"

extern int ComputeJacobian(stsDMMG,Mat);
extern int AnComputeJacobian(stsDMMG,Mat);
extern int ComputeRHS(stsDMMG,Vec);
extern int RedComputeRHS(DMMG,Vec);
void nodalforcevector(double*, int, int, int, double, double, double);

extern int LagComputeJacobian(DMMG,Mat);
extern int LagComputeRHS(DMMG,Vec);
extern int lagrangian_init();

/*******************************************************/
/*  Embedded boundary conditions if any *****/
extern int NeumannContibution(stsDMMG,Vec);
void neumann_boundary();
extern int DirichletContibution(stsDMMG,Vec);
extern int Dirichlet_set(DMMG);
/*******************************************************/

/*******************************************************/
/* Matrix Free Routines */
extern int ComputeMatFreeJacobian(Vec Vecin, Vec Vecout);
extern int CreateJacobian(stsDMMG,Mat *);
extern int CreateJacobianMatrixFree(stsDMMG dmmg,Mat *jac);
extern int ComputeJacobianMatrixFree(stsDMMG dmmg,Mat J);
extern int JacobianMatVecMatrixFree(Mat,Vec,Vec);
extern int JacobianMatGetDiagonal(Mat, Vec);
int matrixFreeMatVec(stsData *, Vec Vecin, Vec Vecout);
int ComputeJacobianMatDiagonal(stsData *,Vec Vecdiag);
/*******************************************************/

/*******************************************************/
/*********** Cartesian Dirichlet boundary identifiers **/
void dirichlet_boundary();
void dirichlet_identifier(int *dirichlet_flag, MatStencil *row,int mx, int my, int mz);
/*******************************************************/

/*******************************************************/
/***** Element level integration ***********************/
void quad(double **xq, double **sq, double ***sh, double *det,double *wq, double , double , double );
void quadlag(double **xq, double **sq, double ***sh, double *det,double *wq, int ie);
void analnode(double **sh);
/*******************************************************/

PetscErrorCode FormFunctionNLinear(SNES snes,Vec X,Vec F,void* ptr);
int matrixFreeMatVecNLinear(stsData *data, Vec Vecin, Vec Vecout);
int FormInitialGuess(SNES snes,Vec X,void *ptr);


void initialize();
void readinput(int argc,char **argv);

void denseelemmat(stsData*, int,int,int);
void rowcolindex(int i, int j, int k, MatStencil *row, MatStencil *col,int jacobian_flag);
void inhomogeneous_material(double*, double*, int, int , int, double, double, double );
void material_props_finelevel(double*, double*);
void createien(int xm, int ym);
void gatherreal(double*,  double*);
void gatherreal1(double*, double* );
void hacks();
extern int node_index(int rowi, int rowj, int rowk,int xd,int yd);
/*********************************************************************/
/* Test case specific *********************************************/
void testcases();
void truthcube_data();
void truthcube_compare();
void abaqus_data();
void abaqus_compare();
/*********************************************************************/

extern int jacobiprec(stsData *data);

/**********************************************************************/
/*Level Set Stuff*/
void marknarrowband(int*, double*, int, int, int);
void reinitlevset(double*,int, int, int);

/*Tumor stuff*/
double ComputeMass(double *disp, int xm, int ym, int zm);
double ComputeTumVolume(int xm, int ym, int zm);
void  OriginalMatProp(char InputImageFile[800], 
			double stiffwm, double stiffgm, double stiffvent, double stiffcsf,double diffwm, double diffgm, double diffvent,
			double compresbrain, double compresvent, double *lambda, double *mu, double *dif);
void  OriginalLandmarks(char InputLandmarkFileUndef[800],char InputLandmarkFileDef[800], double *undeflmark, double *deflmarkobj);
void DeformLandmarks(int nblmarks, double *undeflmark, double *vel, double dt, int xm, int ym, int zm, double *deflmark);


/****************************************************************/
/*Matrix allocation/freeing*/
double** my_malloc_matrix(int rows, int cols);
void my_free_matrix(double ** arr, int rows, int cols);


/*Diffusion 3D*/

void InterpolateVecNodalToElement(Vec vnod, Vec velem);
void InterpolateElementToNodal(Vec velem, Vec vnod);
void InterpolateNodalToElement(Vec vnod, Vec velem);
void RetrieveVecs(Vec m, Vec *msep);
void ReactionForward(Vec c0, double rho, double dt, Vec c);
//void AdvectionGrad(struct ConservationLaw *cl, Vec m0, Vec v, Vec s, double dt, double cfln,  Vec m);
//void AdvectionDiv(struct ConservationLaw *cl, Vec m0, Vec v, Vec s, double dt, double cfln,  Vec m);
//void DiffusionExplicit(struct ConservationLaw *cl, Vec c0, Vec D, Vec s, double dt, double cfln,  Vec c);
void ComputeForceForward(Vec c, double *paramforce, Vec force);
void SolveElasticity(Vec lambda, Vec mu, Vec force, Vec disp);
void ComputeVelocity(Vec dispold, Vec dispnew, double dt, Vec v);
double ComputeObjectiveFuncDensitySpace(Vec c, Vec cobj);
void TrackParticlesLagrangian(double *vel, double timespan, int xm, int ym, int zm, double Hx, double Hy, double Hz, double *deflmark);

int InitializeForwardSolver(int argc,char **argv);
void InitializeModel(char InputImageFile[800], Vec m, Vec c, Vec disp, Vec v, Vec cobj, Vec phi);
void OutputAuxiliary(Vec c, double *cumdisparray, Vec v, Vec lambda, Vec mu, Vec D, Vec phi, int counter);

void CumulateDisplacement(double *vel, double timespan, int xm, int ym, int zm, double Hx, double Hy, double Hz, double *dispc);

#define node_index3(rowi,rowj,rowk,xd,yd) ( (rowj)*(xd) + (rowi) + (rowk)*(xd)*(yd))

#endif 
