/*!
 * \file CreateTemplateWithTumor.c
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <mvcd.h>    
#include <cres.h>
#include <matrixSHEN_1.h>
#include <unistd.h>


#define YYES    1
#define NNO     0

int getopt(int nargc, char * const *nargv, const char *ostr);

float res_x, res_y, res_z ;
int   image_size_x, image_size_y, image_size_z;


void ShenMain(int argc,char *argv[]) ;
void show_usage_SHEN() ;

//add spherical tumor with label 200 to the normal brain template
void  CreateTemplateWithTumor(char InputImageFile[80], float tumradius, float tumcx, float tumcy, float tumcz, char OutputImageFile[80])
{

  int counti, countj, countk, i, j, k, ie, size;
  float xcoord, ycoord, zcoord;  
  unsigned char grayscale;
  FILE *fp, *fp1, *fb, *fb1;
  
  
 
  fb = fopen(InputImageFile,"rb");//original segmented image
  if (fb == NULL) {
  	perror("Could not open image file\n");
	exit(0);
	}
  
  printf("%s\n", InputImageFile);

  //re-write the original segmented image file + spherical tumor added
  
  fb1 = fopen(OutputImageFile,"wb");//original segmented image*/
  
  counti = 1; countj = 1; countk = 1; 
 
  size=image_size_x*image_size_y*image_size_z;
  
  for (ie=0;ie<size; ie++){
  
  	//printf("%d\r", ie);
  
        
        fread(&grayscale,sizeof(char),1,fb);
        
       
        //initial tumor=small sphere of center (tumcx,tumcy,tumcz) and radius tumradius

        i = counti-1; j = countj-1; k = countk-1;
        
        
        xcoord = (i+1.0/2.0) * res_x; /* element centroids*/
        ycoord = (j+1.0/2.0) * res_y;
        zcoord = (k+1.0/2.0) * res_z;
        
       
	
        if ((xcoord-tumcx)*(xcoord-tumcx)+(ycoord-tumcy)*(ycoord-tumcy)+(zcoord-tumcz)*(zcoord-tumcz)<=tumradius*tumradius){ grayscale=200; }
        
 	

	fwrite(&grayscale,sizeof(char),1,fb1); //spherical mask added with label 200*/
        
 
        counti++;
        if (counti==image_size_x+1){ countj++; counti=1; }
        if (countj==image_size_y+1){ counti=1; countj=1; countk++; }
  }
  
  
 fclose(fb);
 fclose(fb1);
 
 
 
} //end function CreateTemplateWithTumor




main(int argc,char *argv[])
{
  ShenMain(argc,argv);    
}



void ShenMain(int argc,char *argv[])
{
  int           i,j,k,c,num;
  FILE          *fp;
  extern char   *optarg;

  float 	cx,cy,cz,radius;	
  char 		fileInput[256];
  char 		fileOutput[256];
  
  
  num=3;

  if(argc<num)
    show_usage_SHEN() ;


  /*  defaults */
  image_size_x=256;
  image_size_y=256;
  image_size_z=124;
  res_x=0.9375;
  res_y=0.9375;
  res_z=1.5;
  cx=0.0;
  cy=0.0;
  cz=0.0;
  radius=0.0;
 
  strcpy(fileInput, argv[1]);
  strcpy(fileOutput, argv[2]);


  printf("%s %s\n", fileInput, fileOutput);

  while((c=getopt(argc-2,argv+2,"d:r:T:")) != -1)


    {
      switch(c)
	{
	case 'd':
	  sscanf(optarg, "%d,%d,%d", &image_size_x,&image_size_y,&image_size_z) ; /* input image size: x,y,z */
	  break ;
	
	case 'r':
	  sscanf(optarg, "%g,%g,%g", &res_x,&res_y,&res_z) ; /* input image resolution: x,y,z */
	  break ;

	case 'T':
	  sscanf(optarg, "%g,%g,%g,%g", &cx,&cy,&cz,&radius) ; /* spherical tumor seed parameters */
	  break ;


	default:
	  break;
	}
    }


  printf("image_size_x=%d, image_size_y=%d, image_size_z=%d\n", image_size_x,image_size_y,image_size_z) ;
  printf("res_x=%g, res_y=%g, res_z=%g\n", res_x,res_y,res_z) ;
  printf("cx=%g, cy=%g, cz=%g, radius=%g\n", cx,cy,cz,radius) ;
  
  CreateTemplateWithTumor(fileInput, radius, cx, cy, cz, fileOutput);

}


void show_usage_SHEN()
{
  printf("USAGE: CreateTemplateWithTumor <input NormalBrainTemplateSegmented> <output NormalBrainTemplateSegmentedWithTumorSeed, spherical, label 200>:\n\
\t -d <int,int,int>       : original image size, x,y,z, default : 256,256,124  \n\
\t -r <float,float,flat>       : original image resolution, x,y,z, default : 0.9375,0.9375,1.5  \n\
\t -T <float,float,float,float>       : spherical tumor seed center (x,y,z) and radius, physical coordinates, default : 0.0,0.0,0.0,0.0  \n\
");
  exit(1);
}
