/*!
 * \file ResampleDeformationFieldCos.c
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <mvcd.h>    
#include <cres.h>
#include <matrixSHEN_1.h>
#include <unistd.h>

/*
#include "/sbia/home/chogea/TC/Include/mvcd.h"
#include "/sbia/home/chogea/TC/Include/cres.h"
#include "/sbia/home/chogea/TC/Include/matrixSHEN_1.h"*/  /*by SHEN*/

#define YYES    1
#define NNO     0

int getopt(int nargc, char * const *nargv, const char *ostr);


int Orig_image_size_x, Orig_image_size_y, Orig_image_size_z ;
float Orig_res_x, Orig_res_y, Orig_res_z ;
int           image_size_x, image_size_y, image_size_z;
Fvector3d     ***Orig_DeformFld, ***Output_DeformFld_Phys, ***Output_DeformFld_Voxel ;

void MarcMain(int,char *[]);
void ShenMain(int argc,char *argv[]) ;
void show_usage_SHEN() ;


void WriteImg(char filename[80], unsigned char ***data, int image_size_x, int image_size_y, int image_size_z)
{
  FILE  *fp;
  int   i, k ;

  /* write the smoothed image */
  fp=myopen(filename,"w");
  for(k=0;k<image_size_z;k++)
    for(i=0;i<image_size_x;i++)
      fwrite(data[k][i],1,image_size_y,fp);
  fclose(fp);
}


void WriteDeformationField(char filename[180], Fvector3d ***DeformFld, int size_x, int size_y, int size_z)
{
  FILE  *fp;
  int   i, k ;

  /* write the smoothed image */
  fp=myopen(filename,"w");
  /*fwrite(&image_size,sizeof(int),1,fp);
    fwrite(&image_size_z,sizeof(int),1,fp);*/
  for(k=0;k<size_z;k++)
    for(i=0;i<size_x;i++)
      fwrite(DeformFld[k][i],sizeof(Fvector3d),size_y,fp);
  fclose(fp);
}



void SampleDeformationField(char InputFile[80], Fvector3d ***Orig_DeformFld, int Orig_image_size_x, int Orig_image_size_y, int Orig_image_size_z,float Orig_res_x, float Orig_res_y, float Orig_res_z,  char OutputFilePhys[80],  char OutputFileVoxel[80],Fvector3d ***Output_DeformFld_Phys, Fvector3d ***Output_DeformFld_Voxel, int image_size_x, int image_size_y, int image_size_z)
{
  FILE  *fp;
  float ratio_x, ratio_y,ratio_z, deform_ratio_x, deform_ratio_y, deform_ratio_z, dx, dy, dz ;
  /* for linear interpolation */
  float ii,jj,kk, b,c,d, b1,c1,d1;
  int   i,j,k,ni,nj,nk, niP1,njP1,nkP1, GreyValue ;
  float alpha ;

  /* open deformation field in the last resolution */
  fp=myopen(InputFile,"r");
    fseek(fp,0,SEEK_END);
//    Orig_image_size_z=ftell(fp)/(Orig_image_size_x*Orig_image_size_y*12);
    rewind(fp);
    printf("given: Orig_image_size_x=%d ", Orig_image_size_x) ;
    printf("given: Orig_image_size_y=%d ", Orig_image_size_y) ;
    printf("given: Orig_image_size_z=%d\n", Orig_image_size_z) ;

    /* output */
//    image_size_z = (int)(((float)image_size/(float)Orig_image_size)*Orig_image_size_z) ;
    printf("output: Output_image_size_x=%d Output_image_size_y=%d Output_image_size_z=%d\n", image_size_x, image_size_y, image_size_z) ;

    /* vector field */ 
    Orig_DeformFld   = Fvector3dalloc3d(Orig_image_size_x,Orig_image_size_y,Orig_image_size_z);
    Output_DeformFld_Phys = Fvector3dalloc3d(image_size_x+1,image_size_y+1,image_size_z+1); //nodal phys. displacement whenever needed
    Output_DeformFld_Voxel = Fvector3dalloc3d(image_size_x,image_size_y,image_size_z);

    for(k=0;k<Orig_image_size_z;k++)
      for(i=0;i<Orig_image_size_x;i++) {
	fread(Orig_DeformFld[k][i],sizeof(Fvector3d),Orig_image_size_y,fp);

	/*for(j=0;j<Orig_image_size_y;j++) 
		if(Orig_DeformFld[k][i][j].x>1.0) printf("%d %d %d %g\n ",k,i, j, Orig_DeformFld[k][i][j].x);
	*/

      }
  fclose(fp);

  /* interpolation */
  ratio_x = (float)Orig_image_size_x/(float)image_size_x ;
  ratio_y = (float)Orig_image_size_y/(float)image_size_y ;
  ratio_z = (float)Orig_image_size_z/(float)image_size_z ;

  deform_ratio_x = 1.0/(ratio_x*Orig_res_x) ; /*for voxel-scaled displacements*/
  deform_ratio_y = 1.0/(ratio_y*Orig_res_y) ;
  deform_ratio_z = 1.0/(ratio_z*Orig_res_z) ;


  for(k=0; k<image_size_z; k++)
    for(i=0; i<image_size_x; i++)
      for(j=0; j<image_size_y; j++)
	{
	  ii = i*ratio_x ;
	  jj = j*ratio_y ;
	  kk = k*ratio_z ;

	  ni = (int)ii ;
	  nj = (int)jj ;
	  nk = (int)kk ;

	  niP1 = ni+1 ;
	  njP1 = nj+1 ;
	  nkP1 = nk+1 ;

	  if(ni>=0 && ni<Orig_image_size_x-1  &&  nj>=0 && nj<Orig_image_size_y-1  &&  nk>=0 && nk<Orig_image_size_z-1 )
	    {

	      b = ii-ni ;        b1 = 1.-b ;
	      c = jj-nj ;        c1 = 1.-c ;
	      d = kk-nk ;        d1 = 1.-d ;

	      dx = ( d1*(Orig_DeformFld[nk][ni][nj].x*(b1*c1) + Orig_DeformFld[nk][niP1][nj].x*(b*c1) + Orig_DeformFld[nk][ni][njP1].x*(b1*c) + Orig_DeformFld[nk][niP1][njP1].x*(b*c)) + d*(Orig_DeformFld[nkP1][ni][nj].x*(b1*c1) + Orig_DeformFld[nkP1][niP1][nj].x*(b*c1) + Orig_DeformFld[nkP1][ni][njP1].x*(b1*c) + Orig_DeformFld[nkP1][niP1][njP1].x*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 
	      dy = ( d1*(Orig_DeformFld[nk][ni][nj].y*(b1*c1) + Orig_DeformFld[nk][niP1][nj].y*(b*c1) + Orig_DeformFld[nk][ni][njP1].y*(b1*c) + Orig_DeformFld[nk][niP1][njP1].y*(b*c)) + d*(Orig_DeformFld[nkP1][ni][nj].y*(b1*c1) + Orig_DeformFld[nkP1][niP1][nj].y*(b*c1) + Orig_DeformFld[nkP1][ni][njP1].y*(b1*c) + Orig_DeformFld[nkP1][niP1][njP1].y*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 
	      dz = ( d1*(Orig_DeformFld[nk][ni][nj].z*(b1*c1) + Orig_DeformFld[nk][niP1][nj].z*(b*c1) + Orig_DeformFld[nk][ni][njP1].z*(b1*c) + Orig_DeformFld[nk][niP1][njP1].z*(b*c)) + d*(Orig_DeformFld[nkP1][ni][nj].z*(b1*c1) + Orig_DeformFld[nkP1][niP1][nj].z*(b*c1) + Orig_DeformFld[nkP1][ni][njP1].z*(b1*c) + Orig_DeformFld[nkP1][niP1][njP1].z*(b*c)) )/( d1*((b1*c1)+(b*c1)+(b1*c)+(b*c)) + d*((b1*c1)+(b*c1)+(b1*c)+(b*c)) ) ; 

		// physical displacement
	      Output_DeformFld_Phys[k][i][j].x = dx;
	      Output_DeformFld_Phys[k][i][j].y = dy;
	      Output_DeformFld_Phys[k][i][j].z = dz;

		 // voxel-normalized displacement
	      Output_DeformFld_Voxel[k][i][j].x = dx*deform_ratio_x ; // *deform_ratio, June 14, 2001
	      Output_DeformFld_Voxel[k][i][j].y = dy*deform_ratio_y ;
	      Output_DeformFld_Voxel[k][i][j].z = dz*deform_ratio_z ;

	/*if( Output_DeformFld_Phys[k][i][j].z>1.0 )  {
		printf("k i j Output_DeformFld_Phys[k][i][j].z   %d %d %d  %g\n", 	
			k,i,j,Output_DeformFld_Phys[k][i][j].z);
	}*/

	/*printf("k i j phys_x phys_y phys_z  %d %d %d %g %g %g\n", 	
			k,i,j,Output_DeformFld_Phys[k][i][j].x,Output_DeformFld_Phys[k][i][j].y,Output_DeformFld_Phys[k][i][j].z);*/

		 

	  }

	  if(ni==Orig_image_size_x-1 && nj>=0 && nj<Orig_image_size_y-1 && nk>=0 && nk<Orig_image_size_z-1 || ni>=0 && ni<Orig_image_size_x-1 && nj==Orig_image_size_y-1 && nk>=0 && nk<Orig_image_size_z-1  || ni>=0 && ni<Orig_image_size_x-1 && nj>=0 && nj<Orig_image_size_y-1 && nk==Orig_image_size_z-1)
	    {	
		 // physical displacement
	      Output_DeformFld_Phys[k][i][j].x = Orig_DeformFld[nk][ni][nj].x;
	      Output_DeformFld_Phys[k][i][j].y = Orig_DeformFld[nk][ni][nj].y;
	      Output_DeformFld_Phys[k][i][j].z = Orig_DeformFld[nk][ni][nj].z;

		// voxel-normalized displacement
	      Output_DeformFld_Voxel[k][i][j].x = Orig_DeformFld[nk][ni][nj].x*deform_ratio_x ; // *deform_ratio, June 14, 2001
	      Output_DeformFld_Voxel[k][i][j].y = Orig_DeformFld[nk][ni][nj].y*deform_ratio_y ;
	      Output_DeformFld_Voxel[k][i][j].z = Orig_DeformFld[nk][ni][nj].z*deform_ratio_z ;

		

	    }

	}

 //phys disp nodal only
 for(i=0; i<image_size_x+1; i++)
      for(j=0; j<image_size_y+1; j++){
  		Output_DeformFld_Phys[image_size_z][i][j].x=0.0;
  		Output_DeformFld_Phys[image_size_z][i][j].y=0.0;
		Output_DeformFld_Phys[image_size_z][i][j].z=0.0;

	}

 for(k=0; k<image_size_z+1; k++)
      for(i=0; i<image_size_x+1; i++){
  		Output_DeformFld_Phys[k][i][image_size_y].x=0.0;
  		Output_DeformFld_Phys[k][i][image_size_y].y=0.0;
		Output_DeformFld_Phys[k][i][image_size_y].z=0.0;

	}

 for(k=0; k<image_size_z+1; k++)
      for(j=0; j<image_size_y+1; j++){
  		Output_DeformFld_Phys[k][image_size_x][j].x=0.0;
  		Output_DeformFld_Phys[k][image_size_x][j].y=0.0;
		Output_DeformFld_Phys[k][image_size_x][j].z=0.0;
	}


  
  printf("done\n") ;
  WriteDeformationField(OutputFilePhys, Output_DeformFld_Phys, image_size_x+1, image_size_y+1, image_size_z+1) ;
  WriteDeformationField(OutputFileVoxel, Output_DeformFld_Voxel, image_size_x, image_size_y, image_size_z) ;

  /* free */
  Fvector3dfree3d(Orig_DeformFld, Orig_image_size_z, Orig_image_size_x) ;
  Fvector3dfree3d(Output_DeformFld_Phys, image_size_z+1, image_size_x+1) ;
  Fvector3dfree3d(Output_DeformFld_Voxel, image_size_z, image_size_x) ;
}




main(int argc,char *argv[])
{
  ShenMain(argc,argv);    
}



/* the following is edited by SHEN */
void ShenMain(int argc,char *argv[])
{
  int           i,j,k,c,num;
  FILE          *fp;
  extern char   *optarg;
	
  char 		fileInput1[256];
  char 		fileOutput1[256];
  char		fileOutput2[256];

  Fvector3d     ***Output_DeformFld_Phys2;

  num=3;

  if(argc<num)
    show_usage_SHEN() ;


  /*  input vector fields size */
  Orig_image_size_x= 256;
  Orig_image_size_y= 256;
  Orig_image_size_z= 124 ;
  /*  input image resolution, physical space! */
  Orig_res_x= 0.9375;
  Orig_res_y= 0.9375;
  Orig_res_z= 1.5 ;
  /*  output vector fields size */
  image_size_x= 256;
  image_size_y= 256;
  image_size_z= 124 ;

  strcpy(fileInput1, argv[1]);
  strcpy(fileOutput1, argv[2]);
  strcpy(fileOutput2, argv[3]);

  printf("%s;%s;%s\n", fileInput1, fileOutput1, fileOutput2);

  while((c=getopt(argc-3,argv+3,"v:r:o:")) != -1)
    {
      switch(c)
	{
	case 'v':
	  sscanf(optarg, "%d,%d,%d", &Orig_image_size_x,&Orig_image_size_y,&Orig_image_size_z) ; /* original input vector field */
	  break ;

	case 'r':
	  sscanf(optarg, "%g,%g,%g", &Orig_res_x,&Orig_res_y,&Orig_res_z) ; /* original input resolution x,y,z */
	  break ;

	case 'o':
	  sscanf(optarg, "%d,%d,%d", &image_size_x,&image_size_y,&image_size_z) ; /* for output vector field */
	  break ;

	default:
	  break;
	}
    }
  printf("Orig_image_size_x=%d,Orig_res_x=%g, Output_image_size_x=%d\n", Orig_image_size_x, Orig_res_x, image_size_x) ;
  printf("Orig_image_size_y=%d,Orig_res_y=%g, Output_image_size_y=%d\n", Orig_image_size_y, Orig_res_y, image_size_y) ;
  printf("Orig_image_size_z=%d,Orig_res_z=%g,Output_image_size_z=%d\n", Orig_image_size_z, Orig_res_z, image_size_z) ;

  SampleDeformationField(fileInput1, Orig_DeformFld, Orig_image_size_x, Orig_image_size_y, Orig_image_size_z, Orig_res_x, Orig_res_y, Orig_res_z, fileOutput1,fileOutput2, 	Output_DeformFld_Phys, Output_DeformFld_Voxel, image_size_x, image_size_y, image_size_z);

/*//test the output file here: open deformation field in the last resolution 

  fp=fopen(argv[2],"r");

    //vector field 
    Output_DeformFld_Phys2 = Fvector3dalloc3d(image_size_x+1, image_size_y+1, image_size_z+1);

    for(k=0;k<image_size_z+1;k++)
      for(i=0;i<image_size_x+1;i++) {
	fread(Output_DeformFld_Phys2[k][i],sizeof(Fvector3d),image_size_y+1,fp);

	for(j=0;j<image_size_y+1;j++) {
		
		if(Output_DeformFld_Phys2[k][i][j].x>1.0) 
		printf("x: k i j  %d %d %d %f\n ",k,i, j, Output_DeformFld_Phys2[k][i][j].x);
		if(Output_DeformFld_Phys2[k][i][j].y>1.0) 
		printf("y: k i j %d %d %d %f\n ",k,i, j, Output_DeformFld_Phys2[k][i][j].y);
		if(Output_DeformFld_Phys2[k][i][j].z>1.0) 
		printf("z: k i j %d %d %d %f\n ",k,i, j, Output_DeformFld_Phys2[k][i][j].z);
	}

      }
 fclose(fp);*/



}


void show_usage_SHEN()
{
  printf("USAGE: ResampleDeformationField <input VectorField>:DS convention (y,x,z) <output VectorFieldPhys>:DS convention (y,x,z) <output VectorFieldVoxel>:DS convention (y,x,z)\n\
\t -v <int,int,int>             : x,y,z size in input vector field, default : 256,256,124  \n\
\t -r <float,float,float>       : x,y,z physical resolution in input vector field, default : 0.9375,0.9375,1.5  \n\
\t -o <int,int,int>             : x,y,z for output vector field, default : 256,256,124 \n\
");
  exit(1);
}
