/*!
 * \file pcShellHeader.h
 *
 * Copyright (c) 2011 University of Pennsylvania. All rights reserved.
 * See COPYING file or https://www.rad.upenn.edu/sbia/software/license.html.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#ifndef __PC_SHELL_HEADER_H
#define __PC_SHELL_HEADER_H

typedef struct {
	void *pcShellStruct; 
	} PCShellCtx;

typedef struct {} PC1ShellCtx;

typedef struct{ Vec diag;} PC2ShellCtx;

extern PetscErrorCode CreatePC1Context(PC1ShellCtx**);
extern PetscErrorCode SetUpPC1(PC1ShellCtx*,Mat);
extern PetscErrorCode ApplyPC1(PC1ShellCtx*,Vec,Vec);
extern PetscErrorCode DestroyPC1(PC1ShellCtx*);

extern PetscErrorCode CreatePC2Context(PC2ShellCtx**);
extern PetscErrorCode SetUpPC2(PC2ShellCtx*,Mat );
extern PetscErrorCode ApplyPC2(PC2ShellCtx*,Vec,Vec);
extern PetscErrorCode DestroyPC2(PC2ShellCtx*);

extern PetscErrorCode CreatePCShellContext(void**);
extern PetscErrorCode SetUpPCShell(void*,Mat);
extern PetscErrorCode ApplyPCShell(void*,Vec,Vec);
extern PetscErrorCode DestroyPCShell(void*);

#endif
