/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import simple.http.Poller;
import simple.http.PollerHandler;
import simple.util.schedule.Scheduler;

final class Processor
implements Runnable {
    private PollerHandler proc;
    private Scheduler queue;
    private volatile boolean alive;

    public Processor(PollerHandler proc, Scheduler queue) {
        this.proc = proc;
        this.queue = queue;
        this.alive = true;
    }

    public void run() {
        while (this.alive) {
            try {
                this.execute();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void kill() {
        this.alive = false;
    }

    private void execute() throws InterruptedException {
        Object top = this.queue.dequeue();
        Poller poller = (Poller)top;
        try {
            poller.process(this.proc);
        }
        catch (Throwable e) {
            poller.close();
        }
    }
}

