/*
 * Decompiled with CFR 0.152.
 */
package simple.http.load;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import simple.http.load.Configuration;
import simple.http.serve.Locator;
import simple.util.PriorityQueue;
import simple.util.xml.Node;
import simple.util.xml.Traverser;

public class PrefixResolver
extends Traverser {
    private Configuration setup = new Configuration();
    private Properties table = new Properties();
    private String[] list;
    private int[] skip;
    private Map data = new HashMap();
    private Map load = new HashMap();
    private Map map = new HashMap();

    public PrefixResolver(Locator lookup) {
        this(lookup, 256);
    }

    public PrefixResolver(Locator lookup, int max) {
        this.skip = new int[max];
        this.init(lookup);
    }

    private void init(Locator lookup) {
        try {
            this.load(lookup);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load(Locator lookup) throws Exception {
        try {
            this.load(lookup, "Mapper.xml");
        }
        catch (IOException e) {
            this.load(lookup, "mapper.xml");
        }
    }

    private void load(Locator lookup, String name) throws Exception {
        this.parse(lookup.getFile(name), "utf-8");
    }

    public Configuration getConfiguration(String name) {
        return (Configuration)this.data.get(name);
    }

    public String getClass(String name) {
        return (String)this.load.get(name);
    }

    public String getName(String prefix) {
        return (String)this.map.get(prefix);
    }

    public String getPrefix(String normal) {
        int size = normal.length();
        int off = 0;
        if (size < this.skip.length) {
            off = this.skip[size];
        }
        int i = off;
        while (i < this.list.length) {
            if (normal.startsWith(this.list[i])) {
                return this.list[i];
            }
            ++i;
        }
        return "/";
    }

    public String getPath(String normal) {
        String prefix = this.getPrefix(normal);
        int size = prefix.length() - 1;
        return normal.substring(size);
    }

    protected void start() {
        this.setup.clear();
        this.table.clear();
        this.load.clear();
        this.map.clear();
        this.data.clear();
    }

    protected void process(Node node) {
        String name = node.getName();
        if (name.equals("match")) {
            this.match(node);
        }
        if (name.equals("service")) {
            this.setup.clear();
            this.table.clear();
        }
        if (name.equals("section")) {
            this.setup.putAll((Map<?, ?>)this.table);
            this.table.clear();
        }
    }

    protected void commit(Node node) {
        String name = node.getName();
        if (name.equals("service")) {
            this.service(node);
        }
        if (name.equals("property")) {
            this.property(node);
        }
        if (name.equals("section")) {
            this.section(node);
        }
    }

    private void section(Node node) {
        String name = node.getAttribute("id");
        if (name != null) {
            this.setup.put(name, this.table.clone());
            this.table.clear();
        }
    }

    private void service(Node node) {
        String name = node.getAttribute("name");
        String type = node.getAttribute("type");
        if (name != null) {
            this.setup.putAll((Map<?, ?>)this.table);
            this.data.put(name, this.setup.clone());
            this.load.put(name, type);
        }
    }

    private void match(Node node) {
        String name = node.getAttribute("name");
        String path = node.getAttribute("path");
        if (path != null) {
            this.map.put(path, name);
        }
    }

    private void property(Node node) {
        String name = node.getAttribute("key");
        if (name != null) {
            this.table.put(name, node.getProperty());
        }
    }

    protected void finish() {
        this.index(this.map.keySet());
    }

    private void index(Set set) {
        this.list = new String[set.size()];
        set.toArray(this.list);
        this.prepare(this.list);
        this.sort(this.list);
        this.optimize(this.skip);
    }

    private void prepare(String[] list) {
        int i = 0;
        while (i < list.length) {
            Object data = this.map.remove(list[i]);
            if (!list[i].endsWith("/")) {
                int n = i;
                list[n] = String.valueOf(list[n]) + "/";
            }
            this.map.put(list[i], data);
            ++i;
        }
    }

    private void sort(String[] list) {
        PriorityQueue queue = new PriorityQueue();
        int i = 0;
        while (i < list.length) {
            queue.add(list[i], list[i].length());
            ++i;
        }
        i = 0;
        while (i < list.length) {
            list[i] = (String)queue.remove();
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void optimize(int[] skip) {
        size = skip.length - 1;
        off = 0;
        while (off < this.list.length) {
            if (this.list[off].length() >= size) ** GOTO lbl9
            skip[size--] = off;
            continue;
            while (this.list[off].length() >= size) {
                skip[size] = off++;
lbl9:
                // 2 sources

                if (off < this.list.length) continue;
            }
            --size;
        }
        while (size > 0) {
            skip[size--] = off - 1;
        }
    }
}

