#!/usr/bin/env python
import sys,os,csv,numpy
from subprocess import Popen
from sklearn.metrics import adjusted_rand_score as ARI

def main():
    cwd = os.getcwd()+'/'+sys.argv[0].replace('test.py','')
    sys.stdout.write("1. Testing CHIMERA... this may take a few minutes.\n")
    sys.stdout.flush()
    process = Popen("chimera -i "+ cwd+"/test_data.csv -r "+ cwd+"/output.txt " +\
             "-k 2 -m 20 -N 3 -e 0.01 -o "+ cwd+"/model.cpkl", shell=True)
    process.communicate()
    with open(cwd+'/output.txt') as f:
        out_label = numpy.asarray(list(csv.reader(f)))
    idx = numpy.nonzero(out_label[0]=="Cluster")[0]
    out_label = out_label[1:,idx].flatten().astype(numpy.int)
    true_label = numpy.append(numpy.ones(250),numpy.ones(250)*2)
    measure = ARI(true_label,out_label)
    sys.stdout.write("Clustering test samples yields an adjusted rand index of %.3f with ground truth labels.\n" % measure)
    if measure>=0.9:
        sys.stdout.write("Test is successful.\n\n")


    sys.stdout.write("2. Testing CHIMERA_TEST... this may finish with a few seconds\n")
    sys.stdout.flush()
    process = Popen("chimera_test -i "+ cwd+"/test_data_test.csv -r "+ cwd+"/output_test.txt -m"+ cwd+"/model.cpkl", shell=True)
    process.communicate()
    with open(cwd+'/output_test.txt') as f:
        out_label_test = numpy.asarray(list(csv.reader(f)))
    idx = numpy.nonzero(out_label_test[0]=="Cluster")[0]
    out_label_test = out_label_test[1:,idx].flatten().astype(numpy.int)
    if sum(out_label_test!=out_label)==0:
        sys.stdout.write("Test is successful.\n\n")
    else:
        sys.stdout.write("Test fails, please check installation.\n\n")

    os.remove(cwd+"/output.txt")
    os.remove(cwd+"/output_test.txt")
    os.remove(cwd+"/model.cpkl")
    
if __name__ == '__main__': main()
