/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BinaryOutputStream
extends FilterOutputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/BinaryOutputStream.java,v 1.12 2008/02/21 04:56:38 dclunie Exp $";
    boolean bigEndian;
    byte[] buffer;
    protected long byteOffset;

    public long getByteOffset() {
        return this.byteOffset;
    }

    protected void localInit(boolean bl) {
        this.bigEndian = bl;
        this.buffer = new byte[8];
        this.byteOffset = 0L;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.byteOffset += (long)n2;
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        ++this.byteOffset;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public BinaryOutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.localInit(bl);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isLittleEndian() {
        return !this.bigEndian;
    }

    public void setBigEndian() {
        this.bigEndian = true;
    }

    public void setLittleEndian() {
        this.bigEndian = false;
    }

    public void setEndian(boolean bl) {
        this.bigEndian = bl;
    }

    final void insertUnsigned8(int n) {
        this.buffer[0] = (byte)n;
    }

    final void insertUnsigned16(int n) {
        if (this.bigEndian) {
            this.buffer[0] = (byte)(n >> 8);
            this.buffer[1] = (byte)n;
        } else {
            this.buffer[1] = (byte)(n >> 8);
            this.buffer[0] = (byte)n;
        }
    }

    final void insertSigned16(int n) {
        this.insertUnsigned16(n);
    }

    final void insertUnsigned32(long l) {
        if (this.bigEndian) {
            this.buffer[0] = (byte)(l >> 24);
            this.buffer[1] = (byte)(l >> 16);
            this.buffer[2] = (byte)(l >> 8);
            this.buffer[3] = (byte)l;
        } else {
            this.buffer[3] = (byte)(l >> 24);
            this.buffer[2] = (byte)(l >> 16);
            this.buffer[1] = (byte)(l >> 8);
            this.buffer[0] = (byte)l;
        }
    }

    final void insertSigned32(long l) {
        this.insertUnsigned32(l);
    }

    final void insertUnsigned64(long l) {
        if (this.bigEndian) {
            this.buffer[0] = (byte)(l >> 56);
            this.buffer[1] = (byte)(l >> 48);
            this.buffer[2] = (byte)(l >> 40);
            this.buffer[3] = (byte)(l >> 32);
            this.buffer[4] = (byte)(l >> 24);
            this.buffer[5] = (byte)(l >> 16);
            this.buffer[6] = (byte)(l >> 8);
            this.buffer[7] = (byte)l;
        } else {
            this.buffer[7] = (byte)(l >> 56);
            this.buffer[6] = (byte)(l >> 48);
            this.buffer[5] = (byte)(l >> 40);
            this.buffer[4] = (byte)(l >> 32);
            this.buffer[3] = (byte)(l >> 24);
            this.buffer[2] = (byte)(l >> 16);
            this.buffer[1] = (byte)(l >> 8);
            this.buffer[0] = (byte)l;
        }
    }

    public final void writeUnsigned8(int n) throws IOException {
        this.insertUnsigned8(n);
        this.write(this.buffer, 0, 1);
    }

    public final void writeUnsigned16(int n) throws IOException {
        this.insertUnsigned16(n);
        this.write(this.buffer, 0, 2);
    }

    public final void writeSigned16(int n) throws IOException {
        this.insertSigned16(n);
        this.write(this.buffer, 0, 2);
    }

    public final void writeUnsigned32(long l) throws IOException {
        this.insertUnsigned32(l);
        this.write(this.buffer, 0, 4);
    }

    public final void writeSigned32(long l) throws IOException {
        this.insertSigned32(l);
        this.write(this.buffer, 0, 4);
    }

    public final void writeFloat(float f) throws IOException {
        int n = Float.floatToRawIntBits(f);
        this.insertUnsigned32(n);
        this.write(this.buffer, 0, 4);
    }

    public final void writeDouble(double d) throws IOException {
        long l = Double.doubleToRawLongBits(d);
        this.insertUnsigned64(l);
        this.write(this.buffer, 0, 8);
    }

    public final void writeUnsigned16(short[] sArray, int n) throws IOException {
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        int n3 = 0;
        if (this.bigEndian) {
            while (n3 < n) {
                short s = sArray[n3++];
                byArray[n2++] = (byte)(s >> 8);
                byArray[n2++] = (byte)s;
            }
        } else {
            while (n3 < n) {
                short s = sArray[n3++];
                byArray[n2++] = (byte)s;
                byArray[n2++] = (byte)(s >> 8);
            }
        }
        this.write(byArray, 0, n * 2);
    }

    public final void writeFloat(float[] fArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeFloat(fArray[i]);
        }
    }

    public final void writeDouble(double[] dArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeDouble(dArray[i]);
        }
    }

    private final void dumpBuffer(String string, int n) {
        System.err.print("after " + string);
        for (int i = 0; i < n; ++i) {
            System.err.print(" 0x" + Integer.toHexString(this.buffer[i] & 0xFF));
        }
        System.err.println();
    }

    public static void main(String[] stringArray) {
        BinaryOutputStream binaryOutputStream = null;
        try {
            binaryOutputStream = new BinaryOutputStream(new FileOutputStream(stringArray[0]), false);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(0);
        }
        binaryOutputStream.insertUnsigned8(255);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0xff)", 1);
        binaryOutputStream.insertUnsigned16(255);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0xff)", 2);
        binaryOutputStream.insertUnsigned32(255L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0xff)", 4);
        binaryOutputStream.insertUnsigned8(65535);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0xffff)", 1);
        binaryOutputStream.insertUnsigned16(65535);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0xffff)", 2);
        binaryOutputStream.insertUnsigned32(65535L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0xffff)", 4);
        binaryOutputStream.insertUnsigned8(0xFFFFFF);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0xffffff)", 1);
        binaryOutputStream.insertUnsigned16(0xFFFFFF);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0xffffff)", 2);
        binaryOutputStream.insertUnsigned32(0xFFFFFFL);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0xffffff)", 4);
        binaryOutputStream.insertUnsigned8(-1);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0xffffffff)", 1);
        binaryOutputStream.insertUnsigned16(-1);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0xffffffff)", 2);
        binaryOutputStream.insertUnsigned32(-1L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0xffffffff)", 4);
        binaryOutputStream.insertUnsigned8(127);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0x7f)", 1);
        binaryOutputStream.insertUnsigned16(127);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0x7f)", 2);
        binaryOutputStream.insertUnsigned32(127L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0x7f)", 4);
        binaryOutputStream.insertUnsigned8(32639);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0x7f7f)", 1);
        binaryOutputStream.insertUnsigned16(32639);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0x7f7f)", 2);
        binaryOutputStream.insertUnsigned32(32639L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0x7f7f)", 4);
        binaryOutputStream.insertUnsigned8(0x7F7F7F);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0x7f7f7f)", 1);
        binaryOutputStream.insertUnsigned16(0x7F7F7F);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0x7f7f7f)", 2);
        binaryOutputStream.insertUnsigned32(0x7F7F7FL);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0x7f7f7f)", 4);
        binaryOutputStream.insertUnsigned8(0x7F7F7F7F);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0x7f7f7f7f)", 1);
        binaryOutputStream.insertUnsigned16(0x7F7F7F7F);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0x7f7f7f7f)", 2);
        binaryOutputStream.insertUnsigned32(0x7F7F7F7FL);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0x7f7f7f7f)", 4);
        try {
            binaryOutputStream = new BinaryOutputStream(new FileOutputStream(stringArray[0]), true);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(0);
        }
        binaryOutputStream.insertUnsigned8(255);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0xff)", 1);
        binaryOutputStream.insertUnsigned16(255);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0xff)", 2);
        binaryOutputStream.insertUnsigned32(255L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0xff)", 4);
        binaryOutputStream.insertUnsigned8(65535);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0xffff)", 1);
        binaryOutputStream.insertUnsigned16(65535);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0xffff)", 2);
        binaryOutputStream.insertUnsigned32(65535L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0xffff)", 4);
        binaryOutputStream.insertUnsigned8(0xFFFFFF);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0xffffff)", 1);
        binaryOutputStream.insertUnsigned16(0xFFFFFF);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0xffffff)", 2);
        binaryOutputStream.insertUnsigned32(0xFFFFFFL);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0xffffff)", 4);
        binaryOutputStream.insertUnsigned8(-1);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0xffffffff)", 1);
        binaryOutputStream.insertUnsigned16(-1);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0xffffffff)", 2);
        binaryOutputStream.insertUnsigned32(-1L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0xffffffff)", 4);
        binaryOutputStream.insertUnsigned8(127);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0x7f)", 1);
        binaryOutputStream.insertUnsigned16(127);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0x7f)", 2);
        binaryOutputStream.insertUnsigned32(127L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0x7f)", 4);
        binaryOutputStream.insertUnsigned8(32639);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0x7f7f)", 1);
        binaryOutputStream.insertUnsigned16(32639);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0x7f7f)", 2);
        binaryOutputStream.insertUnsigned32(32639L);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0x7f7f)", 4);
        binaryOutputStream.insertUnsigned8(0x7F7F7F);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0x7f7f7f)", 1);
        binaryOutputStream.insertUnsigned16(0x7F7F7F);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0x7f7f7f)", 2);
        binaryOutputStream.insertUnsigned32(0x7F7F7FL);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0x7f7f7f)", 4);
        binaryOutputStream.insertUnsigned8(0x7F7F7F7F);
        binaryOutputStream.dumpBuffer("After insertUnsigned8(0x7f7f7f7f)", 1);
        binaryOutputStream.insertUnsigned16(0x7F7F7F7F);
        binaryOutputStream.dumpBuffer("After insertUnsigned16(0x7f7f7f7f)", 2);
        binaryOutputStream.insertUnsigned32(0x7F7F7F7FL);
        binaryOutputStream.dumpBuffer("After insertUnsigned32(0x7f7f7f7f)", 4);
    }
}

