/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.GeometryOfSliceFromAttributeList;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;

public class GeometryOfVolumeFromAttributeList
extends GeometryOfVolume {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/GeometryOfVolumeFromAttributeList.java,v 1.12 2005/01/15 16:17:23 dclunie Exp $";

    public GeometryOfVolumeFromAttributeList(AttributeList attributeList) throws DicomException {
        this.frames = null;
        this.isVolume = false;
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        if (n3 == 1 && sequenceAttribute == null && sequenceAttribute2 == null && attributeList.containsKey(TagFromName.ImagePositionPatient)) {
            GeometryOfSliceFromAttributeList geometryOfSliceFromAttributeList = null;
            try {
                geometryOfSliceFromAttributeList = new GeometryOfSliceFromAttributeList(attributeList);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                geometryOfSliceFromAttributeList = null;
            }
            if (geometryOfSliceFromAttributeList != null) {
                this.frames = new GeometryOfSlice[1];
                this.frames[0] = geometryOfSliceFromAttributeList;
            }
        } else if (n3 > 0 && sequenceAttribute != null && sequenceAttribute2 != null) {
            SequenceAttribute sequenceAttribute3 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PlaneOrientationSequence);
            SequenceAttribute sequenceAttribute4 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PlanePositionSequence);
            SequenceAttribute sequenceAttribute5 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PixelMeasuresSequence);
            this.frames = new GeometryOfSlice[n3];
            for (int i = 0; i < n3; ++i) {
                Attribute attribute = null;
                SequenceAttribute sequenceAttribute6 = sequenceAttribute3;
                if (sequenceAttribute6 == null) {
                    sequenceAttribute6 = (SequenceAttribute)sequenceAttribute2.getItem(i).getAttributeList().get(TagFromName.PlaneOrientationSequence);
                }
                if (sequenceAttribute6 != null) {
                    attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute6, TagFromName.ImageOrientationPatient);
                }
                Attribute attribute2 = null;
                SequenceAttribute sequenceAttribute7 = sequenceAttribute4;
                if (sequenceAttribute7 == null) {
                    sequenceAttribute7 = (SequenceAttribute)sequenceAttribute2.getItem(i).getAttributeList().get(TagFromName.PlanePositionSequence);
                }
                if (sequenceAttribute7 != null) {
                    attribute2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute7, TagFromName.ImagePositionPatient);
                }
                Attribute attribute3 = null;
                Attribute attribute4 = null;
                SequenceAttribute sequenceAttribute8 = sequenceAttribute5;
                if (sequenceAttribute8 == null) {
                    sequenceAttribute8 = (SequenceAttribute)sequenceAttribute2.getItem(i).getAttributeList().get(TagFromName.PixelMeasuresSequence);
                }
                if (sequenceAttribute8 != null) {
                    attribute3 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute8, TagFromName.PixelSpacing);
                    attribute4 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute8, TagFromName.SliceThickness);
                }
                if (attribute2 == null || attribute3 == null || attribute == null) {
                    this.frames = null;
                    break;
                }
                double[] dArray = attribute2.getDoubleValues();
                double[] dArray2 = attribute3.getDoubleValues();
                double[] dArray3 = new double[]{dArray2[0], dArray2[1], 0.0};
                double d = attribute4 == null ? 0.0 : attribute4.getSingleDoubleValueOrDefault(0.0);
                double[] dArray4 = attribute.getDoubleValues();
                double[] dArray5 = new double[]{dArray4[0], dArray4[1], dArray4[2]};
                double[] dArray6 = new double[]{dArray4[3], dArray4[4], dArray4[5]};
                double[] dArray7 = new double[]{n, n2, 1.0};
                this.frames[i] = new GeometryOfSlice(dArray5, dArray6, dArray, dArray3, d, dArray7);
            }
        }
        this.checkAndSetVolumeSampledRegularlyAlongFrameDimension();
    }

    public static double[] getImageOrientationPatientFromAttributeList(AttributeList attributeList) {
        double[] dArray = null;
        try {
            SequenceAttribute sequenceAttribute;
            Attribute attribute = null;
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 0);
            if (n == 1 && sequenceAttribute2 == null) {
                attribute = attributeList.get(TagFromName.ImageOrientationPatient);
            } else if (n > 0 && sequenceAttribute2 != null && (sequenceAttribute = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute2, TagFromName.PlaneOrientationSequence)) != null) {
                attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.ImageOrientationPatient);
            }
            if (attribute != null) {
                dArray = attribute.getDoubleValues();
            }
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        return dArray;
    }
}

