/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetOfDicomFiles
extends HashSet {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SetOfDicomFiles.java,v 1.3 2006/10/15 13:08:46 dclunie Exp $";
    private HashSet setOfSOPClassUIDs = new HashSet();

    public Set getSetOfSOPClassUIDs() {
        return this.setOfSOPClassUIDs;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("DicomFile [");
            stringBuffer.append(Integer.toString(n));
            stringBuffer.append("]:\n");
            stringBuffer.append(((DicomFile)iterator.next()).toString());
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void add(String string) {
        this.add(string, false);
    }

    public void add(String string, boolean bl) {
        DicomFile dicomFile = new DicomFile(string, bl);
        this.add(dicomFile);
        this.setOfSOPClassUIDs.add(dicomFile.sopClassUID);
    }

    public void add(String string, String string2, String string3, String string4) {
        this.setOfSOPClassUIDs.add(string2);
        this.add(new DicomFile(string, string2, string3, string4));
    }

    public AttributeList[] getAttributeLists() {
        AttributeList[] attributeListArray = new AttributeList[this.size()];
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            attributeListArray[n] = ((DicomFile)iterator.next()).getAttributeList();
            ++n;
        }
        return attributeListArray;
    }

    public static void main(String[] stringArray) {
        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                setOfDicomFiles.add(string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
        System.out.println(setOfDicomFiles.toString());
    }

    public class DicomFile
    implements Comparable {
        private String fileName;
        private String sopClassUID;
        private String sopInstanceUID;
        private String transferSyntaxUID;
        private AttributeList list;

        public String getFileName() {
            return this.fileName;
        }

        public String getSOPClassUID() {
            return this.sopClassUID;
        }

        public String getSOPInstanceUID() {
            return this.sopInstanceUID;
        }

        public String getTransferSyntaxUID() {
            return this.transferSyntaxUID;
        }

        public AttributeList getAttributeList() {
            return this.list;
        }

        public int compareTo(Object object) {
            return this.fileName == null ? (((DicomFile)object).fileName == null ? 0 : -1) : this.fileName.compareTo(((DicomFile)object).fileName);
        }

        public int hashCode() {
            return this.fileName == null ? 0 : this.fileName.hashCode();
        }

        public DicomFile(String string, String string2, String string3, String string4) {
            this.fileName = string;
            this.sopClassUID = string2;
            this.sopInstanceUID = string3;
            this.transferSyntaxUID = string4;
            this.list = null;
        }

        public DicomFile(String string, AttributeList attributeList) {
            this(string, attributeList, false);
        }

        public DicomFile(String string, AttributeList attributeList, boolean bl) {
            this.fileName = string;
            this.sopClassUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPClassUIDInFile);
            if (this.sopClassUID == null) {
                this.sopClassUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
            }
            this.sopInstanceUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ReferencedSOPInstanceUIDInFile);
            if (this.sopInstanceUID == null) {
                this.sopInstanceUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
            }
            this.transferSyntaxUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.TransferSyntaxUID);
            this.list = bl ? attributeList : null;
        }

        public DicomFile(String string) {
            this(string, false);
        }

        public DicomFile(String string, boolean bl) {
            this.fileName = string;
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
                this.list = new AttributeList();
                boolean bl2 = false;
                if (bl) {
                    this.list.read(dicomInputStream);
                    bl2 = true;
                } else {
                    this.list.readOnlyMetaInformationHeader(dicomInputStream);
                }
                this.sopClassUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.ReferencedSOPClassUIDInFile);
                this.sopInstanceUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.ReferencedSOPInstanceUIDInFile);
                this.transferSyntaxUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.TransferSyntaxUID);
                if (this.sopClassUID == null || this.sopInstanceUID == null) {
                    if (!bl2) {
                        this.list.read(dicomInputStream, TagFromName.PixelData);
                    }
                    this.sopClassUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.SOPClassUID);
                    this.sopInstanceUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.SOPInstanceUID);
                }
                if (!bl) {
                    this.list = null;
                }
                dicomInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("file=");
            stringBuffer.append(this.fileName);
            stringBuffer.append(", sopClassUID=");
            stringBuffer.append(this.sopClassUID);
            stringBuffer.append(", sopInstanceUID=");
            stringBuffer.append(this.sopInstanceUID);
            stringBuffer.append(", transferSyntaxUID=");
            stringBuffer.append(this.transferSyntaxUID);
            return stringBuffer.toString();
        }
    }
}

