/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.XMLRepresentationOfDicomObjectFactory;
import com.pixelmed.utils.FloatFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLRepresentationOfStructuredReportObjectFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/XMLRepresentationOfStructuredReportObjectFactory.java,v 1.4 2008/02/18 18:14:52 dclunie Exp $";
    private DocumentBuilder db;

    private void addCodedConceptAttributesToDocumentNode(Node node, Document document, CodedSequenceItem codedSequenceItem) {
        if (codedSequenceItem != null) {
            Object object;
            Object object2;
            String string = codedSequenceItem.getCodeMeaning();
            if (string != null) {
                object2 = document.createAttribute("cm");
                object2.setValue(string);
                node.getAttributes().setNamedItem((Node)object2);
            }
            if ((object2 = codedSequenceItem.getCodeValue()) != null) {
                object = document.createAttribute("cv");
                object.setValue((String)object2);
                node.getAttributes().setNamedItem((Node)object);
            }
            if ((object = codedSequenceItem.getCodingSchemeDesignator()) != null) {
                Attr attr = document.createAttribute("csd");
                attr.setValue((String)object);
                node.getAttributes().setNamedItem(attr);
            }
        }
    }

    private void addContentItemsFromTreeToNode(ContentItem contentItem, Document document, Node node) {
        String string;
        if (contentItem != null && (string = contentItem.getValueType()) != null) {
            Element element;
            Object object;
            Object object2;
            Object object3;
            String string2 = string.toLowerCase();
            Element element2 = document.createElement(string2);
            node.appendChild(element2);
            String string3 = contentItem.getRelationshipType();
            if (string3 != null) {
                object3 = document.createAttribute("relationship");
                object3.setValue(string3);
                element2.getAttributes().setNamedItem((Node)object3);
            }
            if ((object3 = contentItem.getConceptName()) != null) {
                object2 = document.createElement("concept");
                element2.appendChild((Node)object2);
                this.addCodedConceptAttributesToDocumentNode((Node)object2, document, (CodedSequenceItem)object3);
            }
            if (contentItem instanceof ContentItemFactory.CodeContentItem) {
                object2 = ((ContentItemFactory.CodeContentItem)contentItem).getConceptCode();
                if (object2 != null) {
                    object = document.createElement("value");
                    element2.appendChild((Node)object);
                    this.addCodedConceptAttributesToDocumentNode((Node)object, document, (CodedSequenceItem)object2);
                }
            } else if (contentItem instanceof ContentItemFactory.NumericContentItem) {
                object2 = ((ContentItemFactory.NumericContentItem)contentItem).getNumericValue();
                if (object2 != null) {
                    object = document.createElement("value");
                    element2.appendChild((Node)object);
                    object.appendChild(document.createTextNode((String)object2));
                }
                if ((object = ((ContentItemFactory.NumericContentItem)contentItem).getUnits()) != null) {
                    Element element3 = document.createElement("units");
                    element2.appendChild(element3);
                    this.addCodedConceptAttributesToDocumentNode(element3, document, (CodedSequenceItem)object);
                }
            } else if (contentItem instanceof ContentItemFactory.StringContentItem) {
                object2 = ((ContentItemFactory.StringContentItem)contentItem).getConceptValue();
                if (object2 != null) {
                    object = document.createElement("value");
                    element2.appendChild((Node)object);
                    object.appendChild(document.createTextNode((String)object2));
                }
            } else if (contentItem instanceof ContentItemFactory.SpatialCoordinatesContentItem) {
                object2 = ((ContentItemFactory.SpatialCoordinatesContentItem)contentItem).getGraphicType();
                if (object2 != null) {
                    object = document.createElement(((String)object2).toLowerCase());
                    element2.appendChild((Node)object);
                    float[] fArray = ((ContentItemFactory.SpatialCoordinatesContentItem)contentItem).getGraphicData();
                    if (fArray != null) {
                        for (int i = 0; i < fArray.length; ++i) {
                            element = document.createElement(i % 2 == 0 ? "x" : "y");
                            object.appendChild(element);
                            element.appendChild(document.createTextNode(FloatFormatter.toString(fArray[i])));
                        }
                    }
                }
            } else if (contentItem instanceof ContentItemFactory.TemporalCoordinatesContentItem) {
                object2 = (ContentItemFactory.TemporalCoordinatesContentItem)contentItem;
                object = ((ContentItemFactory.TemporalCoordinatesContentItem)object2).getTemporalRangeType();
                if (object != null) {
                    Element element4;
                    int n;
                    Element element5 = document.createElement(((String)object).toLowerCase());
                    element2.appendChild(element5);
                    Object[] objectArray = ((ContentItemFactory.TemporalCoordinatesContentItem)object2).getReferencedSamplePositions();
                    if (objectArray != null) {
                        element = document.createElement("samplepositions");
                        element5.appendChild(element);
                        for (n = 0; n < objectArray.length; ++n) {
                            element4 = document.createElement("position");
                            element.appendChild(element4);
                            element4.appendChild(document.createTextNode(Integer.toString(objectArray[n])));
                        }
                    }
                    if ((objectArray = (Object[])((ContentItemFactory.TemporalCoordinatesContentItem)object2).getReferencedTimeOffsets()) != null) {
                        element = document.createElement("timeoffsets");
                        element5.appendChild(element);
                        for (n = 0; n < objectArray.length; ++n) {
                            element4 = document.createElement("offset");
                            element.appendChild(element4);
                            element4.appendChild(document.createTextNode(FloatFormatter.toString(objectArray[n])));
                        }
                    }
                    if ((objectArray = (Object[])((ContentItemFactory.TemporalCoordinatesContentItem)object2).getReferencedDateTimes()) != null) {
                        element = document.createElement("datetimes");
                        element5.appendChild(element);
                        for (n = 0; n < objectArray.length; ++n) {
                            element4 = document.createElement("datetime");
                            element.appendChild(element4);
                            element4.appendChild(document.createTextNode((String)objectArray[n]));
                        }
                    }
                }
            } else if (contentItem instanceof ContentItemFactory.CompositeContentItem) {
                object2 = ((ContentItemFactory.CompositeContentItem)contentItem).getReferencedSOPClassUID();
                if (object2 != null) {
                    object = document.createElement("class");
                    element2.appendChild((Node)object);
                    object.appendChild(document.createTextNode((String)object2));
                }
                if ((object2 = ((ContentItemFactory.CompositeContentItem)contentItem).getReferencedSOPInstanceUID()) != null) {
                    object = document.createElement("instance");
                    element2.appendChild((Node)object);
                    object.appendChild(document.createTextNode((String)object2));
                }
                if (contentItem instanceof ContentItemFactory.ImageContentItem) {
                    Element element6;
                    Element element7;
                    Object object4;
                    object2 = (ContentItemFactory.ImageContentItem)contentItem;
                    int n = ((ContentItemFactory.ImageContentItem)object2).getReferencedFrameNumber();
                    if (n != 0) {
                        object4 = document.createElement("frame");
                        element2.appendChild((Node)object4);
                        object4.appendChild(document.createTextNode(Integer.toString(n)));
                    }
                    if ((n = ((ContentItemFactory.ImageContentItem)object2).getReferencedSegmentNumber()) != 0) {
                        object4 = document.createElement("segment");
                        element2.appendChild((Node)object4);
                        object4.appendChild(document.createTextNode(Integer.toString(n)));
                    }
                    object = ((ContentItemFactory.ImageContentItem)object2).getPresentationStateSOPClassUID();
                    object4 = ((ContentItemFactory.ImageContentItem)object2).getPresentationStateSOPInstanceUID();
                    if (object != null && ((String)object).length() > 0 || object4 != null && ((String)object4).length() > 0) {
                        element7 = document.createElement("presentationstate");
                        element2.appendChild(element7);
                        element = document.createElement("class");
                        element7.appendChild(element);
                        element.appendChild(document.createTextNode((String)object));
                        element6 = document.createElement("instance");
                        element7.appendChild(element6);
                        element6.appendChild(document.createTextNode((String)object4));
                    }
                    object = ((ContentItemFactory.ImageContentItem)object2).getRealWorldValueMappingSOPClassUID();
                    object4 = ((ContentItemFactory.ImageContentItem)object2).getRealWorldValueMappingSOPInstanceUID();
                    if (object != null && ((String)object).length() > 0 || object4 != null && ((String)object4).length() > 0) {
                        element7 = document.createElement("realworldvaluemapping");
                        element2.appendChild(element7);
                        element = document.createElement("class");
                        element7.appendChild(element);
                        element.appendChild(document.createTextNode((String)object));
                        element6 = document.createElement("instance");
                        element7.appendChild(element6);
                        element6.appendChild(document.createTextNode((String)object4));
                    }
                } else if (contentItem instanceof ContentItemFactory.WaveformContentItem && (object2 = (Object)((ContentItemFactory.WaveformContentItem)contentItem).getReferencedWaveformChannels()) != null && ((Object)object2).length > 0) {
                    object = document.createElement("channels");
                    element2.appendChild((Node)object);
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        Element element8 = document.createElement("channel");
                        object.appendChild(element8);
                        element8.appendChild(document.createTextNode(Integer.toString((int)object2[i])));
                    }
                }
            }
            int n = contentItem.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.addContentItemsFromTreeToNode((ContentItem)contentItem.getChildAt(i), document, element2);
            }
        }
    }

    public XMLRepresentationOfStructuredReportObjectFactory() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.db = documentBuilderFactory.newDocumentBuilder();
    }

    public Document getDocument(AttributeList attributeList) {
        return this.getDocument(null, attributeList);
    }

    public Document getDocument(StructuredReport structuredReport) {
        return this.getDocument(structuredReport, null);
    }

    public Document getDocument(StructuredReport structuredReport, AttributeList attributeList) {
        Object object;
        if (structuredReport == null) {
            try {
                structuredReport = new StructuredReport(attributeList);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
        Document document = this.db.newDocument();
        Element element = document.createElement("DicomStructuredReport");
        document.appendChild(element);
        if (attributeList != null) {
            object = (AttributeList)attributeList.clone();
            ((AttributeList)object).removePrivateAttributes();
            ((AttributeList)object).removeGroupLengthAttributes();
            ((AttributeList)object).removeMetaInformationHeaderAttributes();
            ((AttributeList)object).remove(TagFromName.ContentSequence);
            ((AttributeList)object).remove(TagFromName.ValueType);
            ((AttributeList)object).remove(TagFromName.ContentTemplateSequence);
            ((AttributeList)object).remove(TagFromName.ContinuityOfContent);
            ((AttributeList)object).remove(TagFromName.ConceptNameCodeSequence);
            Element element2 = document.createElement("DicomStructuredReportHeader");
            element.appendChild(element2);
            try {
                new XMLRepresentationOfDicomObjectFactory().addAttributesFromListToNode((AttributeList)object, document, element2);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace(System.err);
            }
        }
        if (structuredReport != null) {
            object = document.createElement("DicomStructuredReportContent");
            element.appendChild((Node)object);
            this.addContentItemsFromTreeToNode((ContentItem)structuredReport.getRoot(), document, (Node)object);
        }
        return document;
    }

    public static String toString(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append(node);
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                stringBuffer.append(" ");
                stringBuffer.append(node2);
            }
        }
        stringBuffer.append("\n");
        ++n;
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            stringBuffer.append(XMLRepresentationOfStructuredReportObjectFactory.toString(node3, n));
        }
        return stringBuffer.toString();
    }

    public static String toString(Node node) {
        return XMLRepresentationOfStructuredReportObjectFactory.toString(node, 0);
    }

    public static void write(OutputStream outputStream, Document document) throws IOException, TransformerConfigurationException, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Properties properties = new Properties();
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        properties.setProperty("encoding", "UTF-8");
        transformer.setOutputProperties(properties);
        transformer.transform(dOMSource, streamResult);
    }

    public static void createDocumentAndWriteIt(AttributeList attributeList, OutputStream outputStream) throws IOException, DicomException {
        XMLRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(null, attributeList, outputStream);
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, OutputStream outputStream) throws IOException, DicomException {
        XMLRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(structuredReport, null, outputStream);
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, AttributeList attributeList, OutputStream outputStream) throws IOException, DicomException {
        try {
            Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
            XMLRepresentationOfStructuredReportObjectFactory.write(outputStream, document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DicomException("Could not create XML document - problem creating object model from DICOM" + parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new DicomException("Could not create XML document - could not instantiate transformer" + transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new DicomException("Could not create XML document - could not transform to XML" + transformerException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0], null, true, true);
            StructuredReport structuredReport = new StructuredReport(attributeList);
            Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
            XMLRepresentationOfStructuredReportObjectFactory.write(System.out, document);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

