/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.event;

import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.EventDispatcher;
import com.pixelmed.event.Listener;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Vector;

public class ApplicationEventDispatcher
implements EventDispatcher {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/event/ApplicationEventDispatcher.java,v 1.7 2006/10/23 17:21:51 dclunie Exp $";
    private static ApplicationEventDispatcher applicationEventDispatcher;
    private Vector listeners = new Vector();

    public static synchronized ApplicationEventDispatcher getApplicationEventDispatcher() {
        if (applicationEventDispatcher == null) {
            applicationEventDispatcher = new ApplicationEventDispatcher();
        }
        if (applicationEventDispatcher == null) {
            throw new RuntimeException("Internal error - cannot make new ApplicationEventDispatcher");
        }
        return applicationEventDispatcher;
    }

    private ApplicationEventDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(new WeakReference<Listener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                if (weakReference == null) {
                    System.err.println("ApplicationEventDispatcher.removeListener(): tidy up weak reference that was nulled - this should not happen");
                    iterator.remove();
                    continue;
                }
                Listener listener2 = (Listener)weakReference.get();
                if (listener2 == null) {
                    System.err.println("ApplicationEventDispatcher.removeListener(): tidy up weak reference that was nulled - this should not happen");
                    iterator.remove();
                    continue;
                }
                if (!listener2.equals(listener)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListenersForEventContext(EventContext eventContext) {
        if (eventContext != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    if (weakReference == null) {
                        System.err.println("ApplicationEventDispatcher.removeAllListenersForEventContext(): tidy up weak reference that was nulled - this should not happen");
                        iterator.remove();
                        continue;
                    }
                    Listener listener = (Listener)weakReference.get();
                    if (listener == null) {
                        System.err.println("ApplicationEventDispatcher.removeAllListenersForEventContext(): tidy up weak reference that was nulled - this should not happen");
                        iterator.remove();
                        continue;
                    }
                    if (listener.getEventContext() != eventContext) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processEvent(Event event) {
        Class<?> clazz = event.getClass();
        EventContext eventContext = event.getEventContext();
        Vector vector = this.listeners;
        synchronized (vector) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                if (weakReference == null) {
                    System.err.println("ApplicationEventDispatcher.processEvent(): tidy up weak reference that was nulled - this should not happen");
                    iterator.remove();
                    continue;
                }
                Listener listener = (Listener)weakReference.get();
                if (listener == null) {
                    System.err.println("ApplicationEventDispatcher.processEvent(): tidy up weak reference that was nulled - this should not happen");
                    iterator.remove();
                    continue;
                }
                EventContext eventContext2 = listener.getEventContext();
                if (listener.getClassOfEventHandled() != clazz || eventContext != null && eventContext2 != null && eventContext2 != eventContext) continue;
                listener.changed(event);
            }
        }
    }
}

