/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.query;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class QueryTreeRecord
implements Comparable,
TreeNode {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/query/QueryTreeRecord.java,v 1.10 2005/07/28 13:56:57 dclunie Exp $";
    private QueryInformationModel q;
    private AttributeList filter;
    private int debugLevel;
    private QueryTreeRecord parent;
    private List children;
    private InformationEntity ie;
    private Attribute uniqueKey;
    private AttributeList uniqueKeys;
    private AttributeList allAttributesReturnedInIdentifier;
    private String value;
    private boolean childrenPopulated;
    private int numberOfChildren;

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public int compareTo(Object object) {
        String string;
        QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
        Attribute attribute = queryTreeRecord.getUniqueKey();
        String string2 = attribute == null ? null : attribute.getSingleStringValueOrNull();
        String string3 = string = this.getUniqueKey() == null ? null : this.getUniqueKey().getSingleStringValueOrNull();
        if (string == null && string2 == null) {
            return 0;
        }
        int n = string.compareTo(string2);
        int n2 = StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(this.getValue(), queryTreeRecord.getValue());
        if (n2 == 0) {
            return n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChildAt(int n) {
        this.populateChildrenIfRequired();
        return n < this.getChildCount() ? (TreeNode)this.children.get(n) : null;
    }

    public int getIndex(TreeNode treeNode) {
        this.populateChildrenIfRequired();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!this.children.get(i).equals(treeNode)) continue;
            return i;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    private void populateChildrenIfRequired() {
        if (!this.childrenPopulated) {
            this.populateChildren();
            this.childrenPopulated = true;
            this.numberOfChildren = this.children == null ? 0 : this.children.size();
        }
    }

    public int getChildCount() {
        if (this.numberOfChildren == -1) {
            this.populateChildrenIfRequired();
        }
        return this.numberOfChildren;
    }

    public Enumeration children() {
        this.populateChildrenIfRequired();
        return this.children == null ? null : new Vector(this.children).elements();
    }

    private void populateChildren() {
        InformationEntity informationEntity;
        if (this.debugLevel > 0) {
            System.err.println("QueryTreeRecord.populateChildren() for " + this);
        }
        InformationEntity informationEntity2 = informationEntity = this.ie == null ? this.q.getRoot() : this.q.getChildTypeForParent(this.ie);
        if (informationEntity != null) {
            if (this.debugLevel > 0) {
                System.err.println("QueryTreeRecord.populateChildren(): queryLevel=" + informationEntity);
            }
            AttributeTag attributeTag = this.q.getUniqueKeyForInformationEntity(informationEntity);
            if (this.debugLevel > 0) {
                System.err.println("QueryTreeRecord.populateChildren(): uniqueKeyTagFromThisLevel=" + attributeTag);
            }
            OurResponseIdentifierHandler ourResponseIdentifierHandler = new OurResponseIdentifierHandler(this, informationEntity, attributeTag);
            try {
                this.q.performQuery(this.filter, this.uniqueKeys, informationEntity, ourResponseIdentifierHandler);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
            catch (DicomNetworkException dicomNetworkException) {
                dicomNetworkException.printStackTrace(System.err);
            }
        }
    }

    public QueryTreeRecord(QueryInformationModel queryInformationModel, AttributeList attributeList, QueryTreeRecord queryTreeRecord, String string, InformationEntity informationEntity, Attribute attribute, AttributeList attributeList2, int n) {
        this.q = queryInformationModel;
        this.filter = attributeList;
        this.parent = queryTreeRecord;
        this.value = string;
        this.ie = informationEntity;
        this.uniqueKey = attribute;
        this.allAttributesReturnedInIdentifier = attributeList2;
        this.debugLevel = n;
        this.childrenPopulated = false;
        this.numberOfChildren = -1;
        Comparable comparable = queryInformationModel.getAttributeTagOfCountOfChildren(informationEntity);
        if (attributeList2 != null && comparable != null && attributeList2.containsKey(comparable)) {
            this.numberOfChildren = Attribute.getSingleIntegerValueOrDefault(attributeList2, (AttributeTag)comparable, -1);
        }
        this.uniqueKeys = new AttributeList();
        for (comparable = queryTreeRecord; comparable != null; comparable = (QueryTreeRecord)((QueryTreeRecord)comparable).getParent()) {
            Attribute attribute2 = ((QueryTreeRecord)comparable).getUniqueKey();
            if (attribute2 == null) continue;
            this.uniqueKeys.put(attribute2.getTag(), attribute2);
        }
        if (attribute != null) {
            this.uniqueKeys.put(attribute.getTag(), attribute);
        }
    }

    public void addChild(QueryTreeRecord queryTreeRecord) {
        int n;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if ((n = Collections.binarySearch(this.children, queryTreeRecord)) < 0) {
            this.children.add(-n - 1, queryTreeRecord);
        }
    }

    public void addSibling(QueryTreeRecord queryTreeRecord) throws DicomException {
        if (this.parent == null) {
            throw new DicomException("Internal error - root node with sibling");
        }
        this.parent.addChild(queryTreeRecord);
    }

    public String getValue() {
        return this.value;
    }

    public InformationEntity getInformationEntity() {
        return this.ie;
    }

    public AttributeList getUniqueKeys() {
        return this.uniqueKeys;
    }

    public Attribute getUniqueKey() {
        return this.uniqueKey;
    }

    public AttributeList getAllAttributesReturnedInIdentifier() {
        return this.allAttributesReturnedInIdentifier;
    }

    private class OurResponseIdentifierHandler
    extends IdentifierHandler {
        private InformationEntity ie;
        private AttributeTag uniqueKeyTagFromThisLevel;
        private QueryTreeRecord parentNode;

        public OurResponseIdentifierHandler(QueryTreeRecord queryTreeRecord2, InformationEntity informationEntity, AttributeTag attributeTag) {
            this.parentNode = queryTreeRecord2;
            this.ie = informationEntity;
            this.uniqueKeyTagFromThisLevel = attributeTag;
        }

        public void doSomethingWithIdentifier(AttributeList attributeList) throws DicomException {
            if (QueryTreeRecord.this.debugLevel > 0) {
                System.err.println("QueryTreeRecord.populateChildren.doSomethingWithIdentifier():");
            }
            if (QueryTreeRecord.this.debugLevel > 0) {
                System.err.print(attributeList);
            }
            String string = QueryTreeRecord.this.q.getStringValueForTreeFromResponseIdentifier(this.ie, attributeList);
            Attribute attribute = attributeList.get(this.uniqueKeyTagFromThisLevel);
            if (attribute == null || attribute.getVL() == 0L) {
                throw new DicomException("Invalid query response for " + this.ie + " without unique key value in " + this.uniqueKeyTagFromThisLevel + " from " + QueryTreeRecord.this.q);
            }
            QueryTreeRecord queryTreeRecord = new QueryTreeRecord(QueryTreeRecord.this.q, QueryTreeRecord.this.filter, this.parentNode, string, this.ie, attribute, attributeList, QueryTreeRecord.this.debugLevel);
            QueryTreeRecord.this.addChild(queryTreeRecord);
        }
    }
}

