/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.FloatFormatter;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.RequestTypeServer;
import com.pixelmed.web.WebRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

class ImageDisplayRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/ImageDisplayRequestHandler.java,v 1.7 2006/01/06 16:45:10 dclunie Exp $";
    private String imageDisplayTemplateFileName;
    private Comparator compareDatabaseAttributesByInstanceNumber = new CompareDatabaseAttributesByInstanceNumber();

    protected ImageDisplayRequestHandler(String string, String string2, int n) {
        super(string, n);
        this.imageDisplayTemplateFileName = string2;
    }

    private static final double[] getDoubleArrayOrNullFromDatabaseStringValue(String string) {
        double[] dArray = null;
        try {
            if (string != null) {
                dArray = FloatFormatter.fromString(string, '\\');
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            dArray = null;
        }
        return dArray;
    }

    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        try {
            String string4;
            Object object;
            Map map = webRequest.getParameters();
            if (map == null) {
                throw new Exception("Missing parameters for requestType \"" + string3 + "\"");
            }
            String string5 = (String)map.get("primaryKey");
            if (string5 == null || string5.length() == 0) {
                throw new Exception("Missing primaryKey parameter for requestType \"" + string3 + "\"");
            }
            String string6 = (String)map.get("studyUID");
            if (string6 == null || string6.length() == 0) {
                throw new Exception("Missing studyUID parameter for requestType \"" + string3 + "\"");
            }
            String string7 = (String)map.get("seriesUID");
            if (string7 == null || string7.length() == 0) {
                throw new Exception("Missing seriesUID parameter for requestType \"" + string3 + "\"");
            }
            InputStream inputStream = RequestTypeServer.class.getResourceAsStream("/com/pixelmed/web/" + this.imageDisplayTemplateFileName);
            if (inputStream == null) {
                throw new Exception("No page template \"" + this.imageDisplayTemplateFileName + "\"");
            }
            String string8 = FileUtilities.readFile(inputStream);
            if (this.webServerDebugLevel > 2) {
                System.err.println("ImageDisplayRequestHandler.generateResponseToGetRequest(): Template is " + string8);
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            String string9 = "";
            String string10 = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.INSTANCE).toUpperCase();
            ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity.INSTANCE, string5);
            Collections.sort(arrayList, this.compareDatabaseAttributesByInstanceNumber);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                double d;
                double d2;
                object = (Map)arrayList.get(i);
                string4 = (String)object.get("SOPINSTANCEUID");
                stringBuffer.append(string9);
                stringBuffer.append("\"");
                stringBuffer.append(string4);
                stringBuffer.append("\"");
                double[] dArray = ImageDisplayRequestHandler.getDoubleArrayOrNullFromDatabaseStringValue((String)object.get("WINDOWCENTER"));
                double d3 = d2 = dArray == null || dArray.length == 0 ? 0.0 : dArray[0];
                if (this.webServerDebugLevel > 1) {
                    System.err.println("ImageDisplayRequestHandler.generateResponseToGetRequest(): windowCenter=" + d2);
                }
                stringBuffer2.append(string9);
                stringBuffer2.append(d2);
                double[] dArray2 = ImageDisplayRequestHandler.getDoubleArrayOrNullFromDatabaseStringValue((String)object.get("WINDOWWIDTH"));
                double d4 = d = dArray2 == null || dArray2.length == 0 ? 0.0 : dArray2[0];
                if (this.webServerDebugLevel > 1) {
                    System.err.println("ImageDisplayRequestHandler.generateResponseToGetRequest(): windowWidth=" + d);
                }
                stringBuffer3.append(string9);
                stringBuffer3.append(d);
                string9 = "\n,";
            }
            stringBuffer.append("\n");
            stringBuffer2.append("\n");
            stringBuffer3.append("\n");
            String string11 = stringBuffer.toString();
            if (this.webServerDebugLevel > 2) {
                System.err.println("ImageDisplayRequestHandler.generateResponseToGetRequest(): sopInstanceUIDReplacement is " + string11);
            }
            string8 = string8.replaceFirst("####REPLACEMEWITHLISTOFSOPINSTANCEUIDS####", string11);
            object = stringBuffer2.toString();
            if (this.webServerDebugLevel > 2) {
                System.err.println("ImageDisplayRequestHandler.generateResponseToGetRequest(): windowCenterReplacement is " + (String)object);
            }
            string8 = string8.replaceFirst("####REPLACEMEWITHWINDOWCENTERS####", (String)object);
            string4 = stringBuffer3.toString();
            if (this.webServerDebugLevel > 2) {
                System.err.println("ImageDisplayRequestHandler.generateResponseToGetRequest(): windowWidthReplacement is " + string4);
            }
            string8 = string8.replaceFirst("####REPLACEMEWITHWINDOWWIDTHS####", string4);
            if (this.webServerDebugLevel > 2) {
                System.err.println("ImageDisplayRequestHandler.generateResponseToGetRequest(): Response after replacement is " + string8);
            }
            this.sendHeaderAndBodyText(outputStream, string8, "imagedisplay.html", "text/html");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            if (this.webServerDebugLevel > 0) {
                System.err.println("ImageDisplayRequestHandler.generateResponseToGetRequest(): Sending 404 Not Found");
            }
            ImageDisplayRequestHandler.send404NotFound(outputStream, exception.getMessage());
        }
    }

    private class CompareDatabaseAttributesByInstanceNumber
    implements Comparator {
        private CompareDatabaseAttributesByInstanceNumber() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            String string = (String)((Map)object).get("INSTANCENUMBER");
            String string2 = (String)((Map)object2).get("INSTANCENUMBER");
            try {
                int n2 = Integer.parseInt(string);
                int n3 = Integer.parseInt(string2);
                n = n2 - n3;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
            return n;
        }
    }
}

