/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class SequenceAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SequenceAttribute.java,v 1.17 2008/02/21 04:46:18 dclunie Exp $";
    private LinkedList itemList = new LinkedList();

    public SequenceAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.valueLength = 0xFFFFFFFFL;
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SequenceItem sequenceItem = (SequenceItem)iterator.next();
            sequenceItem.write(dicomOutputStream);
        }
        dicomOutputStream.writeUnsigned16(65534);
        dicomOutputStream.writeUnsigned16(57565);
        dicomOutputStream.writeUnsigned32(0L);
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append("\n%seq\n");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((SequenceItem)iterator.next()).toString(dicomDictionary));
            stringBuffer.append("\n");
        }
        stringBuffer.append("%endseq");
        return stringBuffer.toString();
    }

    public void removeValues() {
        this.itemList = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public void addItem(SequenceItem sequenceItem) {
        this.itemList.addLast(sequenceItem);
    }

    public void addItem(AttributeList attributeList) {
        this.itemList.addLast(new SequenceItem(attributeList));
    }

    public void addItem(AttributeList attributeList, long l) {
        this.itemList.addLast(new SequenceItem(attributeList, l));
    }

    public Iterator iterator() {
        return this.itemList.listIterator(0);
    }

    public int getNumberOfItems() {
        return this.itemList.size();
    }

    public SequenceItem getItem(int n) {
        return this.itemList == null || n >= this.itemList.size() ? null : (SequenceItem)this.itemList.get(n);
    }

    public byte[] getVR() {
        return ValueRepresentation.SQ;
    }

    public static AttributeList getAttributeListFromWithinSequenceWithSingleItem(SequenceAttribute sequenceAttribute) {
        SequenceItem sequenceItem;
        Iterator iterator;
        AttributeList attributeList = null;
        if (sequenceAttribute != null && (iterator = sequenceAttribute.iterator()).hasNext() && (sequenceItem = (SequenceItem)iterator.next()) != null) {
            attributeList = sequenceItem.getAttributeList();
        }
        return attributeList;
    }

    public static AttributeList getAttributeListFromWithinSequenceWithSingleItem(AttributeList attributeList, AttributeTag attributeTag) {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        return SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
    }

    public static Attribute getNamedAttributeFromWithinSequenceWithSingleItem(SequenceAttribute sequenceAttribute, AttributeTag attributeTag) {
        AttributeList attributeList;
        Attribute attribute = null;
        if (sequenceAttribute != null && (attributeList = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute)) != null) {
            attribute = attributeList.get(attributeTag);
        }
        return attribute;
    }

    public static Attribute getNamedAttributeFromWithinSequenceWithSingleItem(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2) {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        return SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, attributeTag2);
    }

    public static String getMeaningOfCodedSequenceAttributeOrDefault(AttributeList attributeList, AttributeTag attributeTag, String string) {
        String string2 = string;
        Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(attributeList, attributeTag, TagFromName.CodeMeaning);
        if (attribute != null) {
            string2 = attribute.getSingleStringValueOrDefault(string);
        }
        return string2;
    }
}

