/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.network.AAbortPDU;
import com.pixelmed.network.AssociateAcceptPDU;
import com.pixelmed.network.AssociateRejectPDU;
import com.pixelmed.network.AssociateRequestPDU;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.PresentationContextListFactory;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.StringUtilities;
import java.io.IOException;
import java.net.Socket;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class AssociationAcceptor
extends Association {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AssociationAcceptor.java,v 1.24 2005/12/30 14:30:55 dclunie Exp $";

    protected AssociationAcceptor(Socket socket, String string, String string2, String string3, int n, int n2, int n3, int n4) throws DicomNetworkException, IOException {
        super(n4);
        this.socket = socket;
        this.calledAETitle = string;
        this.callingAETitle = null;
        this.presentationContexts = null;
        try {
            LinkedList linkedList;
            AssociateRequestPDU associateRequestPDU;
            this.setSocketOptions(socket, n, n2, n3, n4);
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
            byte[] byArray = new byte[6];
            AssociationAcceptor.readInsistently(this.in, byArray, 0, 6, "type and length of PDU");
            int n5 = byArray[0] & 0xFF;
            int n6 = ByteArray.bigEndianToUnsignedInt(byArray, 2, 4);
            if (n4 > 1) {
                System.err.println("Association[" + this.associationNumber + "]: Them: PDU Type: 0x" + Integer.toHexString(n5) + " (length 0x" + Integer.toHexString(n6) + ")");
            }
            if (n5 == 1) {
                associateRequestPDU = new AssociateRequestPDU(AssociationAcceptor.getRestOfPDU(this.in, byArray, n6));
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Them:\n" + associateRequestPDU);
                }
                this.presentationContexts = associateRequestPDU.getRequestedPresentationContexts();
                this.maximumLengthReceived = associateRequestPDU.getMaximumLengthReceived();
                this.callingAETitle = StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl(associateRequestPDU.getCallingAETitle());
                if (!string.equals(StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl(associateRequestPDU.getCalledAETitle()))) {
                    AssociateRejectPDU associateRejectPDU = new AssociateRejectPDU(1, 1, 7);
                    this.out.write(associateRejectPDU.getBytes());
                    this.out.flush();
                    socket.close();
                    throw new DicomNetworkException("Called AE title requested (" + associateRequestPDU.getCalledAETitle() + ") doesn't match ours (" + string + ") - rejecting association");
                }
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Presentation contexts requested:\n" + this.presentationContexts);
                }
                this.presentationContexts = AssociationAcceptor.applyAbstractSyntaxSelectionPolicy(this.presentationContexts);
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Presentation contexts after applyAbstractSyntaxSelectionPolicy:\n" + this.presentationContexts);
                }
                this.presentationContexts = this.applyTransferSyntaxSelectionPolicy(this.presentationContexts);
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Presentation contexts after applyTransferSyntaxSelectionPolicy:\n" + this.presentationContexts);
                }
                this.presentationContexts = AssociationAcceptor.applyExplicitTransferSyntaxPreferencePolicy(this.presentationContexts);
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Presentation contexts after applyExplicitTransferSyntaxPreferencePolicy:\n" + this.presentationContexts);
                }
                linkedList = AssociateAcceptPDU.sanitizePresentationContextsForAcceptance(this.presentationContexts);
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Presentation contexts for A-ASSOCIATE-AC:\n" + linkedList);
                }
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: OurMaximumLengthReceived=" + n);
                }
            } else {
                if (n5 == 7) {
                    AAbortPDU aAbortPDU = new AAbortPDU(AssociationAcceptor.getRestOfPDU(this.in, byArray, n6));
                    if (n4 > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Them:\n" + aAbortPDU);
                    }
                    socket.close();
                    throw new DicomNetworkException("A-ABORT indication - " + aAbortPDU.getInfo());
                }
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Aborting");
                }
                AAbortPDU aAbortPDU = new AAbortPDU(0, 0);
                this.out.write(aAbortPDU.getBytes());
                this.out.flush();
                socket.close();
                throw new DicomNetworkException("A-P-ABORT indication - " + aAbortPDU.getInfo());
            }
            LinkedList linkedList2 = associateRequestPDU.getSCUSCPRoleSelections();
            AssociateAcceptPDU associateAcceptPDU = new AssociateAcceptPDU(string, this.callingAETitle, string2, string3, n, linkedList, linkedList2);
            this.out.write(associateAcceptPDU.getBytes());
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new DicomNetworkException("A-P-ABORT indication - " + iOException);
        }
    }

    protected static LinkedList applyAbstractSyntaxSelectionPolicy(LinkedList linkedList) {
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            PresentationContext presentationContext;
            String string = (presentationContext = (PresentationContext)listIterator.next()).getAbstractSyntaxUID();
            presentationContext.setResultReason((byte)(SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) || SOPClass.isVerification(string) || SOPClass.isCompositeInstanceQuery(string) || SOPClass.isCompositeInstanceRetrieveWithMove(string) || SOPClass.isCompositeInstanceRetrieveWithGet(string) ? 0 : 3));
        }
        return linkedList;
    }

    protected LinkedList applyTransferSyntaxSelectionPolicy(LinkedList linkedList) {
        boolean bl = PresentationContextListFactory.haveBzip2Support();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            PresentationContext presentationContext = (PresentationContext)listIterator.next();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            List list = presentationContext.getTransferSyntaxUIDs();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator2.hasNext()) {
                String string = (String)listIterator2.next();
                if (string == null) continue;
                if (string.equals("1.2.840.10008.1.2")) {
                    bl3 = true;
                    continue;
                }
                if (string.equals("1.2.840.10008.1.2.1")) {
                    bl2 = true;
                    continue;
                }
                if (string.equals("1.2.840.10008.1.2.2")) {
                    bl4 = true;
                    continue;
                }
                if (string.equals("1.2.840.10008.1.2.1.99")) {
                    bl5 = true;
                    continue;
                }
                if (!string.equals("1.3.6.1.4.1.5962.300.1")) continue;
                bl6 = true;
            }
            presentationContext.newTransferSyntaxUIDs();
            if (bl6 && bl) {
                presentationContext.addTransferSyntaxUID("1.3.6.1.4.1.5962.300.1");
                continue;
            }
            if (bl5) {
                presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1.99");
                continue;
            }
            if (bl2) {
                presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1");
                continue;
            }
            if (bl4) {
                presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.2");
                continue;
            }
            if (bl3) {
                presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2");
                continue;
            }
            presentationContext.setResultReason((byte)4);
        }
        return linkedList;
    }

    protected static LinkedList applyExplicitTransferSyntaxPreferencePolicy(LinkedList linkedList) {
        String string;
        PresentationContext presentationContext;
        HashSet<String> hashSet = new HashSet<String>();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            presentationContext = (PresentationContext)listIterator.next();
            string = presentationContext.getTransferSyntaxUID();
            if (string == null || !TransferSyntax.isExplicitVR(string)) continue;
            hashSet.add(presentationContext.getAbstractSyntaxUID());
        }
        listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            presentationContext = (PresentationContext)listIterator.next();
            string = presentationContext.getTransferSyntaxUID();
            if (string == null || !TransferSyntax.isImplicitVR(string) || !hashSet.contains(presentationContext.getAbstractSyntaxUID())) continue;
            presentationContext.setResultReason((byte)2);
        }
        return linkedList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

