/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import java.io.IOException;

public class SectionHeader {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/SectionHeader.java,v 1.6 2004/09/30 12:51:52 dclunie Exp $";
    private int sectionCRC;
    private int sectionIDNumber;
    private long sectionLength;
    private int sectionVersionNumber;
    private int protocolVersionNumber;
    private byte[] reserved = new byte[6];
    private long bytesRead;
    private long byteOffset;
    protected SCPTreeRecord tree;

    public int getSectionCRC() {
        return this.sectionCRC;
    }

    public int getSectionIDNumber() {
        return this.sectionIDNumber;
    }

    public long getSectionLength() {
        return this.sectionLength;
    }

    public int getSectionVersionNumber() {
        return this.sectionVersionNumber;
    }

    public int getProtocolVersionNumber() {
        return this.protocolVersionNumber;
    }

    public byte[] getReservedBytes() {
        return this.reserved;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public long read(BinaryInputStream binaryInputStream, long l) throws IOException {
        this.byteOffset = l;
        this.bytesRead = 0L;
        this.sectionCRC = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionIDNumber = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionLength = binaryInputStream.readUnsigned32();
        this.bytesRead += 4L;
        this.sectionVersionNumber = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        this.protocolVersionNumber = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        binaryInputStream.readInsistently(this.reserved, 0, 6);
        this.bytesRead += 6L;
        return this.bytesRead;
    }

    public String toString() {
        return "[Byte offset = " + this.byteOffset + " dec (0x" + Long.toHexString(this.byteOffset) + ")]\n" + "Section CRC = " + this.sectionCRC + " dec (0x" + Integer.toHexString(this.sectionCRC) + ")\n" + "Section ID Number = " + this.sectionIDNumber + " dec (0x" + Integer.toHexString(this.sectionIDNumber) + ")\n" + "Section Length = " + this.sectionLength + " dec (0x" + Long.toHexString(this.sectionLength) + ")\n" + "Section Version Number = " + this.sectionVersionNumber + " dec (0x" + Integer.toHexString(this.sectionVersionNumber) + ")\n" + "Protocol Version Number = " + this.protocolVersionNumber + " dec (0x" + Integer.toHexString(this.protocolVersionNumber) + ")\n";
    }

    public SCPTreeRecord getTree() {
        return this.tree;
    }

    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, " Header");
            new SCPTreeRecord(sCPTreeRecord2, "Byte offset", Long.toString(this.byteOffset) + " dec (0x" + Long.toHexString(this.byteOffset) + ")");
            new SCPTreeRecord(sCPTreeRecord2, "Section CRC", Long.toString(this.sectionCRC) + " dec (0x" + Long.toHexString(this.sectionCRC) + ")");
            new SCPTreeRecord(sCPTreeRecord2, "Section ID Number", Long.toString(this.sectionIDNumber) + " dec (0x" + Long.toHexString(this.sectionIDNumber) + ")");
            new SCPTreeRecord(sCPTreeRecord2, "Section Length", Long.toString(this.sectionLength) + " dec (0x" + Long.toHexString(this.sectionLength) + ")");
            new SCPTreeRecord(sCPTreeRecord2, "Section Version Number", Long.toString(this.sectionVersionNumber) + " dec (0x" + Long.toHexString(this.sectionVersionNumber) + ")");
            new SCPTreeRecord(sCPTreeRecord2, "Protocol Version Number", Long.toString(this.protocolVersionNumber) + " dec (0x" + Long.toHexString(this.protocolVersionNumber) + ")");
        }
        return this.tree;
    }
}

