/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.server;

import com.pixelmed.database.DatabaseApplicationProperties;
import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.web.RequestTypeServer;
import com.pixelmed.web.WebServerApplicationProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class DicomAndWebStorageServer {
    protected DatabaseInformationModel databaseInformationModel;

    public DicomAndWebStorageServer(Properties properties) throws IOException, DicomException, DicomNetworkException {
        this.doCommonConstructorStuff(properties, null);
    }

    public DicomAndWebStorageServer(Properties properties, DatabaseInformationModel databaseInformationModel) throws IOException, DicomException, DicomNetworkException {
        this.doCommonConstructorStuff(properties, databaseInformationModel);
    }

    protected void doCommonConstructorStuff(Properties properties, DatabaseInformationModel databaseInformationModel) throws IOException, DicomException, DicomNetworkException {
        DatabaseApplicationProperties databaseApplicationProperties = new DatabaseApplicationProperties(properties);
        File file = databaseApplicationProperties.getSavedImagesFolderCreatingItIfNecessary();
        this.databaseInformationModel = databaseInformationModel == null ? new PatientStudySeriesConcatenationInstanceModel(databaseApplicationProperties.getDatabaseFileName(), databaseApplicationProperties.getDatabaseServerName()) : databaseInformationModel;
        NetworkApplicationProperties networkApplicationProperties = new NetworkApplicationProperties(properties);
        NetworkApplicationInformationFederated networkApplicationInformationFederated = new NetworkApplicationInformationFederated();
        WebServerApplicationProperties webServerApplicationProperties = new WebServerApplicationProperties(properties);
        networkApplicationInformationFederated.startupAllKnownSourcesAndRegister(networkApplicationProperties, webServerApplicationProperties);
        int n = networkApplicationProperties.getListeningPort();
        String string = networkApplicationProperties.getCalledAETitle();
        int n2 = networkApplicationProperties.getStorageSCPDebugLevel();
        int n3 = networkApplicationProperties.getQueryDebugLevel();
        new Thread(new StorageSOPClassSCPDispatcher(n, string, file, StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS, new OurReceivedObjectHandler(), this.databaseInformationModel.getQueryResponseGeneratorFactory(n3), this.databaseInformationModel.getRetrieveResponseGeneratorFactory(n3), networkApplicationInformationFederated, false, n2)).start();
        new Thread(new RequestTypeServer(this.databaseInformationModel, webServerApplicationProperties)).start();
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : ".com.pixelmed.server.DicomAndWebStorageServer.properties";
        try {
            Properties properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                properties.put("Dicom.ListeningPort", "11112");
                properties.put("Dicom.CalledAETitle", "STORESCP");
                properties.put("Dicom.CallingAETitle", "STORESCP");
                properties.put("Dicom.PrimaryDeviceType", "ARCHIVE");
                properties.put("Dicom.StorageSCPDebugLevel", "0");
                properties.put("Network.DynamicConfigurationDebugLevel", "0");
                properties.put("Application.SavedImagesFolderName", "tmp");
            }
            System.err.println("properties=" + properties);
            new DicomAndWebStorageServer(properties);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    DicomAndWebStorageServer.this.databaseInformationModel.insertObject(attributeList, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }
}

