/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.SearchListener;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.StoryData;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_String;

public class PdfGroupingAlgorithms {
    private boolean[] isUsed;
    private float[] f_x1;
    private float[] f_x2;
    private float[] f_y1;
    private float[] f_y2;
    private boolean[] hadSpace;
    private String[] f_colorTag;
    private int[] writingMode;
    private int[] moveType;
    private int[] fontSize;
    private float[] spaceWidth;
    private StringBuffer[] content;
    private int[] textLength;
    private String hyphen_values = "";
    private PdfData pdf_data;
    private boolean isXHTML = true;
    private int nextSlot;
    private Vector_Int lineBreaks = new Vector_Int();
    private Vector_Object lines;
    private Vector_Int lineY2;
    private static final String MARKER = StoryData.marker;
    public static char MARKER2 = MARKER.charAt(0);
    private int max_rows = 0;
    private int master = 0;
    private boolean colorExtracted = false;
    private int[] line_order;
    private static final int increment = 100;
    private boolean IS_LEGACY = true;
    public static boolean oldTextExtraction = false;
    public static boolean useUnrotatedCoords;
    private float[] endPoints;
    private boolean includeTease;
    private String[] teasers;
    private StringBuffer tease;
    private float endX;

    public PdfGroupingAlgorithms() {
    }

    public PdfGroupingAlgorithms(PdfData pdfData) {
        this.pdf_data = pdfData;
        this.colorExtracted = pdfData.isColorExtracted();
    }

    private final String getLineDownSeparator(int n, int n2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3;
        StringBuffer stringBuffer4;
        String string = " ";
        boolean bl = false;
        if (PdfDecoder.isXMLExtraction()) {
            stringBuffer4 = Strip.stripXML(stringBuffer);
            stringBuffer3 = Strip.stripXML(stringBuffer2);
        } else {
            stringBuffer4 = Strip.trim(stringBuffer);
            stringBuffer3 = Strip.trim(stringBuffer2);
        }
        int n3 = stringBuffer4.length();
        int n4 = stringBuffer3.length();
        if (n3 > 1 && n4 > 1) {
            char c = stringBuffer4.charAt(n3 - 1);
            char c2 = stringBuffer4.charAt(n3 - 2);
            char c3 = stringBuffer3.charAt(0);
            char c4 = stringBuffer3.charAt(1);
            if (this.hyphen_values.indexOf(c) != -1) {
                string = "";
                if (c2 == ':') {
                    string = "\n";
                }
                if (c == ' ') {
                    string = " ";
                }
            } else if ((c2 == '.' | c == '.') & (Character.isUpperCase(c3) | c3 == '&' | Character.isUpperCase(c4) | c4 == '&')) {
                string = PdfDecoder.isXMLExtraction() ? "<p></p>\n" : "\n";
            }
        }
        if (bl) {
            string = PdfDecoder.isXMLExtraction() ? string + "<p></p>\n" : string + '\n';
        }
        return string;
    }

    private final void cleanupShadowsAndDrownedObjects(boolean bl) {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (this.isUsed[n2]) continue;
            float f = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
            float f2 = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            for (int j = i + 1; j < n; ++j) {
                boolean bl2;
                int n3 = nArray[j];
                if (!(!this.isUsed[n3] & !this.isUsed[n2])) continue;
                float f3 = this.fontSize[n3] - this.fontSize[n2];
                if (f3 < 0.0f) {
                    f3 = -f3;
                }
                if (f3 == 0.0f && f > this.f_x1[n3] && f < this.f_x2[n3] && Math.abs(this.f_x2[n3] - this.f_x1[n3] - (this.f_x2[n2] - this.f_x1[n2])) < 10.0f && f2 < this.f_y1[n3] && f2 > this.f_y2[n3]) {
                    this.isUsed[n3] = true;
                    continue;
                }
                boolean bl3 = this.f_x1[n3] > this.f_x1[n2] && this.f_x2[n3] < this.f_x2[n2] && this.f_y1[n3] < this.f_y1[n2] && this.f_y2[n3] > this.f_y2[n2];
                boolean bl4 = bl2 = this.f_x1[n2] > this.f_x1[n3] && this.f_x2[n2] < this.f_x2[n3] && this.f_y1[n2] < this.f_y1[n3] && this.f_y2[n2] > this.f_y2[n3];
                if (!(bl3 | bl2)) continue;
                if (this.f_y2[n2] > this.f_y2[n3]) {
                    string = this.getLineDownSeparator(n3, n2, this.content[n2], this.content[n3]);
                    if (!bl || string.indexOf(32) == -1) {
                        this.merge(n2, n3, string, true);
                    }
                } else {
                    string = this.getLineDownSeparator(n3, n2, this.content[n3], this.content[n2]);
                    if (!bl || string.indexOf(32) == -1) {
                        this.merge(n3, n2, string, true);
                    }
                }
                f = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
                f2 = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            }
        }
    }

    private final String isGapASpace(int n, int n2, float f, boolean bl, int n3) {
        String string = "";
        float f2 = this.spaceWidth[n] * (float)this.fontSize[n];
        float f3 = this.spaceWidth[n2] * (float)this.fontSize[n2];
        float f4 = f2 > f3 ? f3 : f2;
        int n4 = 0;
        if (PdfStreamDecoder.runningStoryPad) {
            n4 = (int)(f / (f4 / 1000.0f));
        } else {
            if ((f4 = f / (f4 / 1000.0f)) > 0.6f && f4 < 1.0f) {
                f4 = 1.0f;
            }
            n4 = (int)f4;
        }
        if (n4 > 0) {
            string = " ";
        }
        if (n4 > 1 && bl && n3 == 0 | oldTextExtraction) {
            string = " <SpaceCount space=\"" + n4 + "\" />";
        }
        return string;
    }

    public final void cleanupText(PdfData pdfData) {
        this.pdf_data = pdfData;
        this.copyToArrays();
        this.removeEncoding();
        this.writeFromArrays();
    }

    private final void merge(int n, int n2, String string, boolean bl) {
        if (this.f_x1[n] > this.f_x1[n2]) {
            this.f_x1[n] = this.f_x1[n2];
        }
        if (this.f_y1[n] < this.f_y1[n2]) {
            this.f_y1[n] = this.f_y1[n2];
        }
        if (this.f_x2[n] < this.f_x2[n2]) {
            this.f_x2[n] = this.f_x2[n2];
        }
        if (this.f_y2[n] > this.f_y2[n2]) {
            this.f_y2[n] = this.f_y2[n2];
        }
        if (PdfDecoder.isXMLExtraction()) {
            String string2 = Fonts.fe;
            if (this.colorExtracted) {
                string2 = Fonts.fe + "</color>";
            }
            if (bl && this.content[n].toString().endsWith(string2)) {
                this.content[n] = new StringBuffer(this.content[n].substring(0, this.content[n].length() - string2.length()));
                this.content[n].append(string);
                this.content[n].append(string2);
            } else {
                this.content[n].append(string);
            }
        }
        this.fontSize[n] = this.fontSize[n2];
        this.content[n] = this.content[n].append(this.content[n2]);
        this.textLength[n] = this.textLength[n] + this.textLength[n2];
        this.isUsed[n2] = true;
        this.content[n2] = null;
    }

    private final void writeFromArrays() {
        int n = 1;
        int[] nArray = this.getUnusedFragments();
        n = nArray.length;
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            StringBuffer stringBuffer = this.content[n2];
            int n3 = (int)this.f_y1[n2];
            int n4 = (int)this.f_y2[n2];
            if (n3 < n4) {
                int n5 = n3;
                n3 = n4;
                n4 = n5;
            }
            if (stringBuffer.toString().trim().length() <= 0) continue;
            Hashtable<String, CharSequence> hashtable = new Hashtable<String, CharSequence>();
            if (PdfDecoder.isXMLExtraction()) {
                stringBuffer = new StringBuffer(Fonts.cleanupTokens(stringBuffer.toString()));
            }
            hashtable.put("content", stringBuffer);
            hashtable.put("x1", String.valueOf(this.f_x1[n2]));
            hashtable.put("x2", String.valueOf(this.f_x2[n2]));
            hashtable.put("y1", String.valueOf(this.f_y1[n2]));
            hashtable.put("y2", String.valueOf(this.f_y2[n2]));
            if (this.colorExtracted) {
                hashtable.put("color", this.f_colorTag[n2]);
            }
            vector.add(hashtable);
        }
        this.pdf_data.resetTextList(vector);
    }

    private final void removeEncoding() {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (this.isUsed[n2]) continue;
            this.content[n2] = this.removeHiddenMarkers(n2);
        }
    }

    private final void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int n = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[n];
        this.fontSize = new int[n];
        this.writingMode = new int[n];
        this.spaceWidth = new float[n];
        this.content = new StringBuffer[n];
        this.textLength = new int[n];
        this.f_x1 = new float[n];
        this.f_colorTag = new String[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        this.moveType = new int[n];
        for (int i = 0; i < n; ++i) {
            this.content[i] = new StringBuffer(this.pdf_data.contents[i]);
            this.fontSize[i] = this.pdf_data.f_end_font_size[i];
            this.writingMode[i] = this.pdf_data.f_writingMode[i];
            this.f_x1[i] = this.pdf_data.f_x1[i];
            this.f_colorTag[i] = this.pdf_data.colorTag[i];
            this.f_x2[i] = this.pdf_data.f_x2[i];
            this.f_y1[i] = this.pdf_data.f_y1[i];
            this.f_y2[i] = this.pdf_data.f_y2[i];
            this.moveType[i] = this.pdf_data.move_command[i];
            this.spaceWidth[i] = this.pdf_data.space_width[i];
            this.textLength[i] = this.pdf_data.text_length[i];
        }
    }

    private int[] getUnusedFragments() {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.isUsed[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private StringBuffer removeHiddenMarkers(int n) {
        if (this.content[n].indexOf(MARKER) == -1) {
            return this.content[n];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.content[n].toString(), MARKER, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals(MARKER)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuffer = stringBuffer.append(string);
        }
        return stringBuffer;
    }

    private float scanLineForValue(StringBuffer[] stringBufferArray, StringBuffer stringBuffer, String string, int n, boolean bl) {
        StringBuffer stringBuffer2 = null;
        int n2 = 0;
        int n3 = stringBuffer.length();
        char[] cArray = stringBuffer.toString().toCharArray();
        if (this.includeTease) {
            this.tease = new StringBuffer();
            stringBuffer2 = new StringBuffer();
        }
        float f = -1.0f;
        float f2 = -1.0f;
        float f3 = 0.0f;
        StringBuffer stringBuffer3 = new StringBuffer();
        if (!bl) {
            string = string.toLowerCase();
        }
        while (n2 < n3) {
            int n4;
            while (n2 < n3 && cArray[n2] != MARKER2) {
                ++n2;
            }
            if (cArray[n2] != MARKER2) continue;
            int n5 = ++n2;
            while (n2 < n3 && cArray[n2] != MARKER2) {
                ++n2;
            }
            f3 = Float.parseFloat(stringBuffer.substring(n5, n2));
            n5 = ++n2;
            while (n2 < n3 && cArray[n2] != MARKER2) {
                ++n2;
            }
            String string2 = stringBuffer.substring(n5, n2);
            n5 = ++n2;
            while (n2 < n3 && cArray[n2] != MARKER2) {
                ++n2;
            }
            String string3 = stringBuffer.substring(n5, n2);
            if (f3 < (float)n) continue;
            boolean bl2 = false;
            if (PdfDecoder.isXMLExtraction() && (n4 = string3.indexOf(60)) != -1) {
                if (string3.indexOf("<link:") != -1) {
                    bl2 = true;
                }
                string3 = string3.substring(0, n4);
            }
            if (this.includeTease) {
                n4 = stringBuffer2.lastIndexOf(" ");
                if (n4 != -1 && string3.indexOf(32) != -1) {
                    stringBuffer2 = new StringBuffer(stringBuffer2.substring(n4 + 1, stringBuffer2.length()));
                }
                stringBuffer2.append(string3);
                if (bl2) {
                    stringBuffer2.append(' ');
                }
            }
            stringBuffer3.append(string3);
            String string4 = stringBuffer3.toString();
            if (!bl) {
                string4 = string4.toLowerCase();
            }
            if (f == -1.0f | string4.length() == 0) {
                f = f3;
            }
            if (string4.indexOf(string) != -1) {
                f2 = f;
                this.endX = f3 + Float.parseFloat(string2);
                if (this.includeTease) {
                    this.tease.append(Strip.stripXML(stringBuffer2));
                    if (stringBuffer2.toString().endsWith(" ")) {
                        this.tease.append(' ');
                    }
                    this.createTease(stringBufferArray, stringBuffer, n2, n3);
                }
            } else if (!string.startsWith(string4)) {
                stringBuffer3 = new StringBuffer();
                f = -1.0f;
                if (string3.equals(" ")) {
                    stringBuffer2 = new StringBuffer();
                }
            }
            if (!(f2 >= 0.0f)) continue;
            break;
        }
        return f2;
    }

    private void createTease(StringBuffer[] stringBufferArray, StringBuffer stringBuffer, int n, int n2) {
        int n3 = 0;
        int n4 = 3;
        StringBuffer stringBuffer2 = stringBuffer;
        String string = "";
        boolean bl = false;
        while (n < n2 && n4 > 0) {
            int n5;
            while (n < n2 && stringBuffer2.charAt(n) != MARKER2) {
                ++n;
            }
            boolean bl2 = false;
            if (stringBuffer2.charAt(n) == MARKER2 | n == 0) {
                ++n;
                for (n5 = 0; n5 < 3; ++n5) {
                    n3 = n;
                    while (n < n2 && stringBuffer2.charAt(n) != MARKER2) {
                        ++n;
                    }
                    ++n;
                }
                string = stringBuffer2.substring(n3, --n);
                if (PdfDecoder.isXMLExtraction()) {
                    n5 = string.indexOf("<link:");
                    if (n5 != -1) {
                        int n6 = string.indexOf(62, n5);
                        int n7 = Integer.parseInt(string.substring(n5 + 6, n6));
                        n = 0;
                        stringBuffer2 = stringBufferArray[n7];
                        n2 = stringBuffer2.length();
                        bl2 = true;
                    }
                    if ((n5 = string.indexOf(60)) != -1) {
                        string = string.substring(0, n5);
                    }
                }
            }
            if (string.equals(" ")) {
                --n4;
            }
            this.tease.append(Strip.stripXML(string));
            if (string.endsWith(" ")) {
                this.tease.append(' ');
            }
            if (!bl2 || (n5 = (int)string.charAt(string.length() - 1)) == 45 || n5 == 32) continue;
            this.tease.append(' ');
        }
    }

    public static String removeHiddenMarkers(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(MARKER) == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(MARKER)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuffer = stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private void findVerticalLines(float f, float f2, float f3, float f4, int n) throws PdfException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        int n3 = this.pdf_data.getRawTextElementCount();
        String string = "";
        for (int i = 0; i < n3; ++i) {
            float f5;
            float f6;
            float f7;
            float f8;
            float f9 = 0.0f;
            float f10 = 0.0f;
            string = this.pdf_data.contents[i];
            if (oldTextExtraction | n == 0) {
                f8 = this.f_x1[i];
                f7 = this.f_x2[i];
                f6 = this.f_y1[i];
                f5 = this.f_y2[i];
            } else if (n == 1) {
                f7 = this.f_x1[i];
                f8 = this.f_x2[i];
                f6 = this.f_y1[i];
                f5 = this.f_y2[i];
            } else if (n == 3) {
                f8 = this.f_y1[i];
                f7 = this.f_y2[i];
                f6 = this.f_x2[i];
                f5 = this.f_x1[i];
            } else if (n == 2) {
                f8 = this.f_y2[i];
                f7 = this.f_y1[i];
                f5 = this.f_x1[i];
                f6 = this.f_x2[i];
            } else {
                throw new PdfException("Illegal value " + n + "for currentWritingMode");
            }
            if (!((double)f8 > (double)f - 0.5) || !((double)f7 < (double)f3 + 0.5) || !((double)f5 > (double)f2 - 0.5) || !((double)f6 < (double)f4 + 0.5)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER, true);
            String string2 = "";
            String string3 = "";
            Object var21_27 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.equals(MARKER)) continue;
                string2 = stringTokenizer.nextToken();
                if (string2.length() > 0) {
                    f10 = f9;
                    f9 = Float.parseFloat(string2);
                    try {
                        if (string3.length() == 0 || string3.indexOf(32) != -1) {
                            int n4;
                            Integer n5 = new Integer((int)f9);
                            var21_27 = hashMap.get(n5);
                            if (var21_27 == null) {
                                hashMap.put(n5, new Integer(1));
                            } else {
                                n4 = var21_27;
                                if (++n4 > n2) {
                                    n2 = n4;
                                }
                                hashMap.put(n5, new Integer(n4));
                            }
                            n4 = (int)(f10 + (f9 - f10) / 2.0f);
                            if (f10 != 0.0f) {
                                n5 = new Integer(n4);
                                var21_27 = hashMap.get(n5);
                                if (var21_27 == null) {
                                    hashMap.put(n5, new Integer(1));
                                } else {
                                    int n6 = var21_27;
                                    if (++n6 > n2) {
                                        n2 = n6;
                                    }
                                    hashMap.put(n5, new Integer(n6));
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " stripping x values");
                    }
                }
                String string4 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string3 = string2 = stringTokenizer.nextToken();
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        int n7 = n2 / 2;
        while (iterator.hasNext()) {
            Integer n8 = (Integer)iterator.next();
            int n9 = (Integer)hashMap.get(n8);
            if (n9 <= n7) continue;
            this.lineBreaks.addElement(n8);
        }
    }

    private void copyToArrays(float f, float f2, float f3, float f4, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4) throws PdfException {
        int n = this.pdf_data.getRawTextElementCount() + 100;
        this.f_x1 = new float[n];
        this.f_colorTag = new String[n];
        this.hadSpace = new boolean[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        this.spaceWidth = new float[n];
        this.content = new StringBuffer[n];
        this.fontSize = new int[n];
        this.textLength = new int[n];
        this.writingMode = new int[n];
        this.isUsed = new boolean[n];
        this.moveType = new int[n];
        boolean bl5 = false;
        n -= 100;
        float f5 = -1.0f;
        float f6 = 0.0f;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            f6 = this.pdf_data.f_character_spacing[i];
            string2 = this.pdf_data.contents[i];
            float f12 = this.pdf_data.f_x1[i];
            string4 = this.pdf_data.colorTag[i];
            float f13 = this.pdf_data.f_x2[i];
            float f14 = this.pdf_data.f_y1[i];
            float f15 = this.pdf_data.f_y2[i];
            int n2 = this.pdf_data.text_length[i];
            int n3 = this.pdf_data.f_writingMode[i];
            int n4 = this.pdf_data.move_command[i];
            boolean bl6 = false;
            if (oldTextExtraction | n3 == 0 | n3 == 1 && f15 > f2 && f14 < f4 && f12 < f3 && f13 > f) {
                bl6 = true;
            } else if (!oldTextExtraction && n3 == 3 | n3 == 2 && f12 > f && f13 < f3 && f14 > f2 && f15 < f4) {
                bl6 = true;
            }
            if (!bl6) continue;
            if (!bl5 && bl3) {
                this.findVerticalLines(f, f2, f3, f4, n3);
                bl5 = true;
            }
            if (oldTextExtraction | n3 == 0 | n3 == 1) {
                f11 = (f13 - f12) / (float)n2;
                f10 = f12;
                f9 = f12;
                f8 = f;
                f7 = f3;
            } else {
                f11 = (f14 - f15) / (float)n2;
                f10 = f15;
                f9 = f15;
                f8 = f2;
                f7 = f4;
            }
            f5 = -1.0f;
            char[] cArray = string2.toCharArray();
            int n5 = cArray.length;
            int n6 = 0;
            String string5 = "";
            String string6 = "";
            String string7 = "";
            boolean bl7 = false;
            if (string2.indexOf(MARKER) == -1) {
                stringBuffer = new StringBuffer(string2);
            }
            boolean bl8 = true;
            while (n6 < n5) {
                int n7;
                int n8;
                do {
                    if (cArray[n6] != MARKER2) {
                        n8 = n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string5 = string2.substring(n8, n6);
                    } else {
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        n8 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string7 = string2.substring(n8, n6);
                        n8 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string3 = string2.substring(n8, n6);
                        n8 = ++n6;
                        while (n6 < n5 && cArray[n6] != MARKER2) {
                            ++n6;
                        }
                        string6 = string5 = string2.substring(n8, n6);
                        if (string7.length() > 0) {
                            f9 = f10;
                            f10 = Float.parseFloat(string7);
                        }
                        if (PdfDecoder.isXMLExtraction() && f9 < f8 && f10 > f8 && !string5.startsWith(Fonts.fb)) {
                            string5 = Fonts.getActiveFontTag(string2, "") + string5;
                        }
                    }
                    if (f10 > f8 & f10 < f7) break;
                    string5 = "";
                    string6 = "";
                } while (n6 < n5);
                if (bl8) {
                    bl8 = false;
                    if (PdfDecoder.isXMLExtraction() && bl && !string5.startsWith(Fonts.fb) && !string5.startsWith("<color ")) {
                        stringBuffer.append(Fonts.getActiveFontTag(stringBuffer.toString(), string2));
                    }
                }
                if (bl7) {
                    bl7 = false;
                    if (oldTextExtraction | n3 == 0) {
                        f12 = f10;
                    } else if (n3 == 1) {
                        f13 = f10;
                    } else if (n3 == 3) {
                        f15 = f10;
                    } else if (n3 == 2) {
                        f14 = f10;
                    }
                }
                n8 = 0;
                if (bl3 && f6 > 0.0f && stringBuffer.toString().endsWith(" ")) {
                    n7 = this.lineBreaks.size();
                    for (int j = 0; j < n7; ++j) {
                        int n9 = this.lineBreaks.elementAt(j);
                        if (!(f9 < (float)n9 & f10 > (float)n9)) continue;
                        j = n7;
                        n8 = 1;
                    }
                }
                n7 = this.checkForPunctuation(string6, string);
                if (n8 != 0) {
                    float f16 = f12;
                    float f17 = f13;
                    float f18 = f14;
                    float f19 = f15;
                    if (oldTextExtraction | n3 == 0) {
                        f17 = f9 + Float.parseFloat(string3);
                    } else if (n3 == 1) {
                        f16 = f9 + Float.parseFloat(string3);
                    } else if (n3 == 3) {
                        f18 = f9 + Float.parseFloat(string3);
                    } else if (n3 == 2) {
                        f19 = f9 + Float.parseFloat(string3);
                    }
                    this.addFragment(n4, i, stringBuffer, f16, f17, f18, f19, n2, bl, string4, bl4);
                    stringBuffer = new StringBuffer(Fonts.getActiveFontTag(stringBuffer.toString(), string2));
                    stringBuffer.append(string5);
                    if (oldTextExtraction | n3 == 0) {
                        f12 = f10;
                        continue;
                    }
                    if (n3 == 1) {
                        f13 = f10;
                        continue;
                    }
                    if (n3 == 3) {
                        f15 = f10;
                        continue;
                    }
                    if (n3 != 2) continue;
                    f14 = f10;
                    continue;
                }
                if (n7 | (bl2 && (string6.indexOf(32) != -1 || string5.endsWith(" "))) | string6.indexOf("   ") != -1) {
                    if (n7 == 0) {
                        stringBuffer.append(string5.trim());
                    }
                    if (oldTextExtraction | n3 == 0) {
                        this.addFragment(n4, i, stringBuffer, f12, f10, f14, f15, n2, bl, string4, bl4);
                    } else if (n3 == 1) {
                        this.addFragment(n4, i, stringBuffer, f10, f13, f14, f15, n2, bl, string4, bl4);
                    } else if (n3 == 3) {
                        this.addFragment(n4, i, stringBuffer, f12, f13, f10, f15, n2, bl, string4, bl4);
                    } else if (n3 == 2) {
                        this.addFragment(n4, i, stringBuffer, f12, f13, f14, f10, n2, bl, string4, bl4);
                    }
                    if (string3.length() > 0) {
                        f10 += Float.parseFloat(string3);
                    }
                    if (bl2 & this.nextSlot > 0) {
                        this.hadSpace[this.nextSlot - 1] = true;
                    }
                    stringBuffer = new StringBuffer(Fonts.getActiveFontTag(stringBuffer.toString(), string2));
                    if (oldTextExtraction | n3 == 0) {
                        f12 = f10;
                        continue;
                    }
                    if (n3 == 1) {
                        f13 = f10;
                        continue;
                    }
                    if (n3 == 3) {
                        f15 = f10;
                        continue;
                    }
                    if (n3 != 2) continue;
                    f14 = f10;
                    continue;
                }
                if (f5 != -1.0f & f10 > f5) {
                    if (oldTextExtraction | n3 == 0) {
                        this.addFragment(n4, i, stringBuffer, f12, f5, f14, f15, n2, bl, string4, bl4);
                    } else if (n3 == 1) {
                        this.addFragment(n4, i, stringBuffer, f5, f13, f14, f15, n2, bl, string4, bl4);
                    } else if (n3 == 3) {
                        this.addFragment(n4, i, stringBuffer, f12, f13, f5, f15, n2, bl, string4, bl4);
                    } else if (n3 == 2) {
                        this.addFragment(n4, i, stringBuffer, f12, f13, f14, f5, n2, bl, string4, bl4);
                    }
                    stringBuffer = new StringBuffer(Fonts.getActiveFontTag(stringBuffer.toString(), string2));
                    stringBuffer.append(string5);
                    if (oldTextExtraction | n3 == 0) {
                        f12 = f5;
                    } else if (n3 == 1) {
                        f13 = f5;
                    } else if (n3 == 3) {
                        f15 = f5;
                    } else if (n3 == 2) {
                        f14 = f5;
                    }
                    f5 = -1.0f;
                    continue;
                }
                if (PdfDecoder.isXMLExtraction() && string5.endsWith(' ' + Fonts.fe)) {
                    string5 = Fonts.fe;
                    string6 = "";
                    if (oldTextExtraction | n3 == 0) {
                        f13 = f9;
                    } else if (n3 == 1) {
                        f12 = f9;
                    } else if (n3 == 3) {
                        f14 = f9;
                    } else if (n3 == 2) {
                        f15 = f9;
                    }
                }
                stringBuffer.append(string5);
            }
            if (bl && PdfDecoder.isXMLExtraction() && !stringBuffer.toString().endsWith(Fonts.fe) && !stringBuffer.toString().endsWith("</color>")) {
                stringBuffer.append(Fonts.fe);
            }
            if (oldTextExtraction | n3 == 0 | n3 == 1) {
                if (f12 < f13) {
                    this.addFragment(n4, i, stringBuffer, f12, f13, f14, f15, n2, bl, string4, bl4);
                }
            } else if (oldTextExtraction | n3 == 3 | n3 == 2 && f14 > f15) {
                this.addFragment(n4, i, stringBuffer, f12, f13, f14, f15, n2, bl, string4, bl4);
            }
            stringBuffer = new StringBuffer();
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private boolean checkForPunctuation(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        boolean bl = false;
        int n = string.length();
        int n2 = n - 1;
        if (n > 0) {
            char c = string.charAt(n2);
            boolean bl2 = c == '>';
            while ((bl2 | c == ' ') & n2 > 0) {
                if (c == '<') {
                    bl2 = false;
                }
                if ((c = string.charAt(--n2)) != '>') continue;
                bl2 = true;
            }
            if (c == ';') {
                bl = true;
                --n2;
                while (n2 > -1) {
                    c = string.charAt(n2);
                    if (c == '&' || c == '#') {
                        bl = false;
                        n2 = 0;
                    }
                    if (n2 != 0 && c != ' ' && Character.isJavaLetterOrDigit(c)) {
                        --n2;
                        continue;
                    }
                    break;
                }
            } else if (string2.indexOf(c) != -1) {
                bl = true;
            }
        }
        return bl;
    }

    private void addFragment(int n, int n2, StringBuffer stringBuffer, float f, float f2, float f3, float f4, int n3, boolean bl, String string, boolean bl2) {
        StringBuffer stringBuffer2 = stringBuffer;
        String string2 = stringBuffer2.toString();
        if (bl2) {
            if (string2.indexOf("&#") != -1) {
                stringBuffer2 = Strip.stripAmpHash(stringBuffer2);
            }
            if (PdfDecoder.isXMLExtraction() && (string2.indexOf("&lt;") != -1 || string2.indexOf("&gt;") != -1)) {
                stringBuffer2 = Strip.stripXMLArrows(stringBuffer2);
            } else if (!(PdfDecoder.isXMLExtraction() || string2.indexOf(60) == -1 && string2.indexOf(62) == -1)) {
                stringBuffer2 = Strip.stripArrows(stringBuffer2);
            }
        }
        if (this.getFirstChar(stringBuffer2) != -1) {
            if (!bl) {
                stringBuffer2 = Strip.stripXML(stringBuffer2);
            } else if (PdfDecoder.isXMLExtraction()) {
                if (this.pdf_data.isColorExtracted() && !stringBuffer2.toString().endsWith("</color>")) {
                    if (!stringBuffer2.toString().endsWith(Fonts.fe)) {
                        stringBuffer2 = stringBuffer2.append(Fonts.fe);
                    }
                    stringBuffer2 = stringBuffer2.append("</color>");
                } else if (!this.pdf_data.isColorExtracted() && !stringBuffer2.toString().endsWith(Fonts.fe)) {
                    stringBuffer2 = stringBuffer2.append(Fonts.fe);
                }
            }
            int n4 = this.f_x1.length;
            if (this.nextSlot < n4) {
                this.f_x1[this.nextSlot] = f;
                this.f_colorTag[this.nextSlot] = string;
                this.f_x2[this.nextSlot] = f2;
                this.f_y1[this.nextSlot] = f3;
                this.f_y2[this.nextSlot] = f4;
                this.moveType[this.nextSlot] = n;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[n2];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[n2];
                this.textLength[this.nextSlot] = n3;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[n2];
                this.content[this.nextSlot] = stringBuffer2;
                ++this.nextSlot;
            } else {
                float[] fArray = new float[n4 += 100];
                String[] stringArray = new String[n4];
                float[] fArray2 = new float[n4];
                float[] fArray3 = new float[n4];
                float[] fArray4 = new float[n4];
                float[] fArray5 = new float[n4];
                StringBuffer[] stringBufferArray = new StringBuffer[n4];
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                int[] nArray3 = new int[n4];
                int[] nArray4 = new int[n4];
                boolean[] blArray = new boolean[n4];
                boolean[] blArray2 = new boolean[n4];
                for (int i = 0; i < n4 - 100; ++i) {
                    fArray[i] = this.f_x1[i];
                    stringArray[i] = this.f_colorTag[i];
                    fArray2[i] = this.f_x2[i];
                    fArray3[i] = this.f_y1[i];
                    fArray4[i] = this.f_y2[i];
                    blArray2[i] = this.hadSpace[i];
                    fArray5[i] = this.spaceWidth[i];
                    stringBufferArray[i] = this.content[i];
                    nArray[i] = this.fontSize[i];
                    nArray3[i] = this.writingMode[i];
                    nArray2[i] = this.textLength[i];
                    blArray[i] = this.isUsed[i];
                    nArray4[i] = this.moveType[i];
                }
                this.f_x1 = fArray;
                this.f_colorTag = stringArray;
                this.hadSpace = blArray2;
                this.f_x2 = fArray2;
                this.f_y1 = fArray3;
                this.f_y2 = fArray4;
                this.isUsed = blArray;
                this.fontSize = nArray;
                this.writingMode = nArray3;
                this.textLength = nArray2;
                this.spaceWidth = fArray5;
                this.content = stringBufferArray;
                this.moveType = nArray4;
                this.f_x1[this.nextSlot] = f;
                this.f_colorTag[this.nextSlot] = string;
                this.f_x2[this.nextSlot] = f2;
                this.f_y1[this.nextSlot] = f3;
                this.f_y2[this.nextSlot] = f4;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[n2];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[n2];
                nArray2[this.nextSlot] = n3;
                this.content[this.nextSlot] = stringBuffer2;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[n2];
                this.moveType[this.nextSlot] = n;
                ++this.nextSlot;
            }
        }
    }

    private void mergeTableRows(int n) {
        String string = "\n";
        string = "</tr>\n<tr>";
        if (!this.isXHTML) {
            string = "\n";
        }
        this.master = ((Vector_Int)this.lines.elementAt(this.line_order[0])).elementAt(0);
        for (int i = 1; i < this.max_rows; ++i) {
            int n2 = ((Vector_Int)this.lines.elementAt(this.line_order[i])).elementAt(0);
            if (this.content[this.master] == null) {
                this.master = n2;
                continue;
            }
            if (this.content[n2] == null) continue;
            this.merge(this.master, n2, string, false);
        }
        if (this.isXHTML) {
            if (n == 0) {
                this.content[this.master].insert(0, "<TABLE>\n<tr>");
                this.content[this.master].append("</tr>\n</TABLE>\n");
            } else {
                StringBuffer stringBuffer = new StringBuffer("<TABLE border='");
                stringBuffer.append(String.valueOf(n));
                stringBuffer.append("'>\n<tr>");
                stringBuffer.append(this.content[this.master]);
                this.content[this.master] = stringBuffer;
                this.content[this.master].append("</tr>\n</TABLE>\n");
            }
        }
    }

    private final int[] getsortedUnusedFragments(boolean bl, boolean bl2) {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.isUsed[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        int[] nArray3 = null;
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        int[] nArray6 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            nArray2[i] = n3 = nArray[i];
            nArray4[i] = (int)this.f_x1[n3];
            nArray5[i] = (int)this.f_y1[n3];
            nArray6[i] = (int)this.f_y2[n3];
        }
        nArray3 = !bl ? (bl2 ? Sorts.quicksort(nArray5, nArray4, nArray2) : Sorts.quicksort(nArray6, nArray4, nArray2)) : Sorts.quicksort(nArray4, nArray5, nArray2);
        return nArray3;
    }

    private void createTableRows(boolean bl, boolean bl2, int n) throws PdfException {
        float f;
        boolean bl3;
        int n2;
        int n3;
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (oldTextExtraction | n == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n == 3) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n == 2) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            n3 = 0;
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!((float)n3 < fArray[n2])) continue;
                n3 = (int)fArray[n2];
            }
            ++n3;
            for (n2 = 0; n2 < fArray2.length; ++n2) {
                fArray[n2] = (float)n3 - fArray[n2];
                fArray2[n2] = (float)n3 - fArray2[n2];
            }
        } else {
            throw new PdfException("Illegal value " + n + "for currentWritingMode");
        }
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[this.max_rows];
        Vector_Int[] vector_IntArray = new Vector_Int[this.max_rows];
        Vector_String vector_String = new Vector_String();
        Vector_Float vector_Float = new Vector_Float();
        Vector_Float vector_Float2 = new Vector_Float();
        String string = "";
        String string2 = "&nbsp;";
        if (!this.isXHTML) {
            string = "\",\"";
            string2 = "";
        }
        int[] nArray2 = new int[this.max_rows];
        for (n2 = 0; n2 < this.max_rows; ++n2) {
            nArray2[n2] = ((Vector_Int)this.lines.elementAt(n2)).size() - 1;
            n5 += nArray2[n2];
            nArray[n2] = 0;
            vector_IntArray[n2] = new Vector_Int(20);
        }
        do {
            float f2 = 9999.0f;
            float f3 = 9999.0f;
            float f4 = 9999.0f;
            f = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 9999.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            ++n4;
            bl3 = true;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            String string3 = "center";
            if (n6 >= n5) continue;
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                if (nArray2[n2] <= nArray[n2]) continue;
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f = fArray[n3];
                f5 = fArray2[n3];
                if (f < f2) {
                    f2 = f;
                }
                if (!(f5 < f3)) continue;
                f3 = f5;
            }
            vector_Float2.addElement(f2);
            f4 = f3;
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f6 = fArray[n3];
                if (f6 >= f2 & f6 < f3 & (f8 = fArray2[n3]) > f4) {
                    f4 = f8;
                }
                if (nArray[n2] >= nArray2[n2] || !((f = fArray[n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2] + 1)]) > f3 & f < f7)) continue;
                f7 = f;
            }
            if (f7 == 9999.0f) {
                f7 = f4;
            }
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f6 = fArray[n3];
                if (!(f6 >= f2 & f6 < f3 & (f8 = fArray2[n3]) <= f7)) continue;
                f10 += f6;
                f11 += f8;
                f9 += 1.0f;
            }
            if (n2 == 0) {
                f12 = f2;
            }
            f13 = f7 == -1.0f ? 0.0f : (float)((int)((f7 - f4) / 2.0f));
            int n7 = (int)(f4 - f2 + f13 + f12);
            f12 = f13;
            vector_Float.addElement(n7);
            float f14 = f10 / f9 - f2;
            float f15 = f4 - f11 / f9;
            if (f14 < 1.0f) {
                string3 = "left";
            } else if (f15 < 1.0f) {
                string3 = "right";
            }
            vector_String.addElement(string3);
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                this.master = ((Vector_Int)this.lines.elementAt(n2)).elementAt(0);
                if (nArray2[n2] > nArray[n2]) {
                    n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                    f6 = fArray[n3];
                    f8 = fArray2[n3];
                    bl3 = false;
                } else {
                    n3 = -1;
                    f6 = -1.0f;
                    f8 = -1.0f;
                }
                if (n3 == -1 & n6 <= n5) {
                    vector_IntArray[n2].addElement(-1);
                    continue;
                }
                if (f6 >= f2 & f6 < f4) {
                    vector_IntArray[n2].addElement(n3);
                    int n8 = n2;
                    nArray[n8] = nArray[n8] + 1;
                    ++n6;
                    continue;
                }
                if (!(f6 > f4)) continue;
                vector_IntArray[n2].addElement(-1);
            }
        } while (!bl3);
        for (int i = 0; i < this.max_rows; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            int n9 = vector_IntArray[i].size() - 1;
            this.master = ((Vector_Int)this.lines.elementAt(i)).elementAt(0);
            for (n2 = 0; n2 < n9; ++n2) {
                n3 = vector_IntArray[i].elementAt(n2);
                if (this.isXHTML) {
                    f = vector_Float.elementAt(n2);
                    String string4 = vector_String.elementAt(n2);
                    int n10 = -1;
                    int n11 = 1;
                    int n12 = n2 + 1;
                    if (n3 != -1) {
                        while (!((n10 = vector_IntArray[i].elementAt(n2 + 1)) != -1 | n9 == n2 + 1) && !(nArray2[i] > 1 & vector_Float2.elementAt(n2 + 1) > fArray2[n3])) {
                            --n9;
                            vector_IntArray[i].removeElementAt(n2 + 1);
                            ++n11;
                            f += vector_Float.elementAt(n12);
                            ++n12;
                        }
                    }
                    stringBuffer.append("<td");
                    if (bl) {
                        stringBuffer.append(" align='");
                        stringBuffer.append(string4);
                        stringBuffer.append('\'');
                        if (n11 > 1) {
                            stringBuffer.append(" colspan='").append(n11).append('\'');
                        }
                    }
                    if (bl2) {
                        stringBuffer.append(" width='").append((int)f).append('\'');
                    }
                    stringBuffer.append(" nowrap>");
                    if (n3 == -1) {
                        stringBuffer.append(string2);
                    } else {
                        stringBuffer.append(this.content[n3]);
                    }
                    stringBuffer.append("</td>");
                } else if (n3 == -1) {
                    stringBuffer.append("\"\",");
                } else {
                    stringBuffer.append('\"');
                    stringBuffer.append(this.content[n3]);
                    stringBuffer.append("\",");
                }
                if (n3 == -1 || this.master == n3) continue;
                this.merge(this.master, n3, string, false);
            }
            this.content[this.master] = stringBuffer;
        }
    }

    private Vector_Object createLinesInTable(int n, int[] nArray, boolean bl, int n2) throws PdfException {
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (!oldTextExtraction && n2 == 1) {
            nArray = this.reverse(nArray);
        }
        if (oldTextExtraction | n2 == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n2 == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n2 == 3) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n2 == 2) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            nArray = this.getsortedUnusedFragments(false, true);
            nArray = this.reverse(nArray);
        } else {
            throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
        }
        Vector_Int vector_Int = new Vector_Int(20);
        String string = "";
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            int n5 = -1;
            int n6 = n4;
            float f = -1.0f;
            if (this.isUsed[n4] || !(this.writingMode[n4] == n2 | oldTextExtraction)) continue;
            vector_Int = new Vector_Int(20);
            vector_Int.addElement(n4);
            this.lineY2.addElement((int)fArray4[n4]);
            while (true) {
                for (int j = 0; j < n; ++j) {
                    float f2;
                    int n7 = nArray[j];
                    if (this.isUsed[n7] || n7 == n4 || !(this.writingMode[n4] == n2 | oldTextExtraction) || !((fArray[n7] > fArray[n4] && n2 != 2 | oldTextExtraction) | (fArray[n7] < fArray[n4] && !oldTextExtraction && n2 == 2))) continue;
                    float f3 = fArray[n7] - fArray2[n4];
                    if (!oldTextExtraction && n2 == 1 | n2 == 2) {
                        f3 = -f3;
                    }
                    if (f3 < 0.0f & f3 > -2.0f) {
                        f3 = 0.0f;
                    }
                    if (!((f2 = (fArray3[n7] + fArray4[n7]) / 2.0f) < fArray3[n4]) || !(f2 > fArray4[n4]) || !(f < 0.0f | f3 < f)) continue;
                    f = f3;
                    n5 = n7;
                }
                if (n5 == -1) break;
                float f4 = fArray[n5] - fArray2[n6];
                float f5 = fArray[n5] - fArray2[n4];
                float f6 = 1.5f * ((fArray2[n5] - fArray[n5]) / (float)this.textLength[n5]);
                float f7 = 1.5f * ((fArray2[n6] - fArray[n6]) / (float)this.textLength[n6]);
                if (!oldTextExtraction && n2 == 1 | n2 == 2) {
                    f5 = -f5;
                    f4 = -f4;
                    f6 = -f6;
                    f7 = -f7;
                }
                if (f4 < f6 & f4 < f7) {
                    string = this.isGapASpace(n5, n6, f5, bl, n2);
                    this.merge(n6, n5, string, true);
                } else {
                    vector_Int.addElement(n5);
                    n6 = n5;
                }
                this.isUsed[n5] = true;
                n5 = -1;
                f = 1000000.0f;
                ++n3;
            }
            this.lines.addElement(vector_Int);
            vector_Int = new Vector_Int(20);
            ++this.max_rows;
        }
        return this.lines;
    }

    public final Map extractTextAsTable(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n6, boolean bl5) throws PdfException {
        this.validateCoordinates(n, n2, n3, n4);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        LogWriter.writeLog("extracting Text As Table");
        this.isXHTML = !bl;
        this.lines = new Vector_Object(20);
        this.lineY2 = new Vector_Int(20);
        this.max_rows = 0;
        this.copyToArrays(n, n4, n3, n2, bl2, false, true, null, false);
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int n7 = nArray.length;
        if (n7 == 0) {
            return hashtable;
        }
        int n8 = this.getWritingMode(nArray, n7);
        String string = "Table Merging algorithm being applied " + n7 + " items";
        LogWriter.writeLog(string);
        if (n7 > 1) {
            this.createLinesInTable(n7, nArray, this.isXHTML, n8);
            int n9 = 1;
            if (oldTextExtraction | n8 == 0 | n8 == 2) {
                n9 = -1;
            }
            this.line_order = new int[this.max_rows];
            int[] nArray2 = new int[this.max_rows];
            for (int i = 0; i < this.max_rows; ++i) {
                nArray2[i] = n9 * this.lineY2.elementAt(i);
                this.line_order[i] = i;
            }
            this.line_order = Sorts.quicksort(nArray2, this.line_order);
            this.createTableRows(bl4, bl3, n8);
            this.mergeTableRows(n6);
        }
        this.content[this.master] = this.cleanup(this.content[this.master]);
        String string2 = this.content[this.master].toString();
        if (string2 != null) {
            if (!bl) {
                string2 = Fonts.cleanupTokens(string2);
            }
            hashtable.put("content", string2);
            hashtable.put("x1", String.valueOf(n));
            hashtable.put("x2", String.valueOf(n3));
            hashtable.put("y1", String.valueOf(n2));
            hashtable.put("y2", String.valueOf(n4));
        }
        return hashtable;
    }

    private void validateCoordinates(int n, int n2, int n3, int n4) throws PdfException {
        if (n > n3 | n2 < n4) {
            String string = "Invalid parameters for text rectangle. ";
            if (n > n3) {
                string = string + "x1 value (" + n + ") must be LESS than x2 (" + n3 + "). ";
            }
            if (n2 < n4) {
                string = string + "y1 value (" + n2 + ") must be MORE than y2 (" + n4 + "). ";
            }
            throw new PdfException(string);
        }
    }

    public final Vector extractTextAsWordlist(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, String string) throws PdfException {
        this.validateCoordinates(n, n2, n3, n4);
        if (bl2) {
            this.copyToArrays(n, n4, n3, n2, true, true, false, string, true);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(true);
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int n6 = nArray.length;
        if (n6 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n7 = this.getWritingMode(nArray, n6);
        this.createLines(n6, nArray, n7, true, false, false);
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (useUnrotatedCoords | oldTextExtraction | n7 == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n7 == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n7 == 3) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n7 == 2) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            if (this.colorExtracted && PdfDecoder.isXMLExtraction()) {
                if (!this.content[i].toString().toLowerCase().startsWith("<color ")) {
                    this.content[i].insert(0, this.f_colorTag[this.master]);
                }
                if (!this.content[i].toString().toLowerCase().endsWith("</color>")) {
                    this.content[i].append("</color>");
                }
            }
            if (PdfDecoder.isXMLExtraction()) {
                vector.add(this.content[i].toString());
            } else {
                vector.add(Strip.convertToText(this.content[i].toString()));
            }
            if (!useUnrotatedCoords && n7 == 2) {
                vector.add(String.valueOf(this.pdf_data.maxY - fArray[i]));
                vector.add(String.valueOf(fArray3[i]));
                vector.add(String.valueOf(this.pdf_data.maxY - fArray2[i]));
                vector.add(String.valueOf(fArray4[i]));
                continue;
            }
            if (!useUnrotatedCoords && n7 == 3) {
                vector.add(String.valueOf(fArray[i]));
                vector.add(String.valueOf(this.pdf_data.maxX - fArray4[i]));
                vector.add(String.valueOf(fArray2[i]));
                vector.add(String.valueOf(this.pdf_data.maxX - fArray3[i]));
                continue;
            }
            vector.add(String.valueOf(fArray[i]));
            vector.add(String.valueOf(fArray3[i]));
            vector.add(String.valueOf(fArray2[i]));
            vector.add(String.valueOf(fArray4[i]));
        }
        LogWriter.writeLog("Text extraction as wordlist completed");
        return vector;
    }

    private void reset() {
        this.isXHTML = true;
        this.nextSlot = 0;
        this.lineBreaks = new Vector_Int();
        this.max_rows = 0;
        this.master = 0;
        this.colorExtracted = false;
        this.tease = null;
        this.endX = 0.0f;
    }

    public final String extractTextInRectangle(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) throws PdfException {
        this.reset();
        if (bl2 && !this.pdf_data.IsEmbedded()) {
            throw new PdfException("[PDF] Request to breakfragments and width not added. Please add call to init(true) of PdfDecoder to your code.");
        }
        this.validateCoordinates(n, n2, n3, n4);
        String string = "";
        int n6 = 0;
        int n7 = 0;
        if (bl2) {
            this.copyToArrays(n, n4, n3, n2, PdfDecoder.isXMLExtraction(), false, false, null, false);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray = this.getsortedUnusedFragments(true, false);
        n7 = nArray.length;
        if (n7 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n8 = this.getWritingMode(nArray, n7);
        this.createLines(n7, nArray, n8, false, true, false);
        n6 = this.mergeLinesTogether(n8, bl, n, n3, n2, n4);
        if (PdfDecoder.isXMLExtraction()) {
            this.content[n6] = new StringBuffer(Fonts.cleanupTokens(this.content[n6].toString()));
            this.content[n6].insert(0, "<p>");
            this.content[n6].append("</p>");
        }
        LogWriter.writeLog("Text extraction completed");
        return this.cleanup(this.content[n6]).toString();
    }

    private StringBuffer cleanup(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return stringBuffer;
        }
        return stringBuffer;
    }

    private int getWritingMode(int[] nArray, int n) {
        int n2 = this.writingMode[nArray[0]];
        if (n2 == 0 | n2 == 1) {
            return n2;
        }
        for (int i = 1; i < n; ++i) {
            int n3 = nArray[i];
            if (this.isUsed[n3] || !(this.writingMode[n3] == 0 | this.writingMode[n3] == 1)) continue;
            n2 = this.writingMode[n3];
            i = n;
            LogWriter.writeLog("Text of multiple orientations found. Only horizontal text used.");
        }
        return n2;
    }

    private int mergeLinesTogether(int n, boolean bl, int n2, int n3, int n4, int n5) throws PdfException {
        int n6;
        int[] nArray;
        boolean bl2 = false;
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (oldTextExtraction | n == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
            nArray = this.getsortedUnusedFragments(false, true);
            n6 = (n2 + n3) / 2;
        } else if (n == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
            nArray = this.getsortedUnusedFragments(false, true);
            n6 = (n2 + n3) / 2;
        } else if (n == 3) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
            nArray = this.getsortedUnusedFragments(true, true);
            nArray = this.reverse(nArray);
            n6 = (n4 + n5) / 2;
        } else if (n == 2) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray4 = this.f_x2;
            fArray3 = this.f_x1;
            nArray = this.getsortedUnusedFragments(true, true);
            n6 = (n4 + n5) / 2;
        } else {
            throw new PdfException("Illegal value " + n + "for currentWritingMode");
        }
        int n7 = n6 / 2;
        int n8 = nArray.length;
        int n9 = nArray[n8 - 1];
        Object var18_17 = null;
        Object var19_18 = null;
        for (int i = n8 - 2; i > -1; --i) {
            int n10 = nArray[i];
            String string = "";
            int n11 = this.getLastChar(this.content[n10]);
            if (n11 == -1) continue;
            this.addAlignmentFormatting(bl, n6, fArray, fArray2, n7, n10);
            String string2 = "</p>\n<p>";
            if (PdfDecoder.isXMLExtraction()) {
                string2 = "\n";
            }
            float f = fArray4[n9] - fArray3[n10];
            float f2 = fArray3[n10] - fArray4[n10];
            if (!oldTextExtraction && n == 3) {
                f = -f;
                f2 = -f2;
            }
            if (f > f2 & f2 > 0.0f) {
                while (f > f2) {
                    string = string + string2;
                    f -= f2;
                }
                string = PdfDecoder.isXMLExtraction() ? string + "</p>\n<p>" : "\n";
            } else if (bl) {
                int n12 = this.getFirstChar(this.content[n10]);
                int n13 = this.getLastChar(this.content[n9]);
                if ((n13 == 46 || n13 == 34) && n12 >= 65 && n12 <= 90) {
                    string = PdfDecoder.isXMLExtraction() ? "</p>\n<p>" : "\n";
                }
            } else if (this.IS_LEGACY) {
                if (PdfDecoder.isXMLExtraction()) {
                    this.content[n10].insert(0, "</p>\n<p>");
                } else {
                    this.content[n10].append('\n');
                }
            } else if (PdfDecoder.isXMLExtraction()) {
                this.content[n10].insert(0, "</p>\n<p>");
            } else {
                this.content[n10].append('\n');
            }
            this.merge(n9, n10, string, false);
        }
        return n9;
    }

    private int getFirstChar(StringBuffer stringBuffer) {
        int n = -1;
        boolean bl = false;
        int n2 = stringBuffer.length();
        int n3 = 32;
        for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            if (!bl && (c == '<' || PdfDecoder.isXMLExtraction() && c == '&')) {
                bl = true;
                n3 = c;
                if (n3 == 38) {
                    if (i + 1 == n2) {
                        n = 38;
                        i = n2;
                    } else {
                        char c2 = stringBuffer.charAt(i + 1);
                        if (c2 != '#' && c2 != 'g' && c2 != 'l') {
                            n = 38;
                            i = n2;
                        }
                    }
                }
            }
            if (!bl && c != ' ') {
                n = c;
                i = n2;
            }
            if (bl && n3 == 38 && c == ' ') {
                n = n3;
                i = n2;
                continue;
            }
            if (!bl || c != '>' && (!PdfDecoder.isXMLExtraction() || n3 != 38 || c != ';')) continue;
            if (c == ';' && n3 == 38 && i > 2 & stringBuffer.charAt(i - 1) == 't') {
                if (stringBuffer.charAt(i - 2) == 'l') {
                    n = 60;
                    i = n2;
                } else if (stringBuffer.charAt(i - 2) == 'g') {
                    n = 62;
                    i = n2;
                }
            }
            bl = false;
        }
        return n;
    }

    private int getLastChar(StringBuffer stringBuffer) {
        int n = -1;
        boolean bl = false;
        int n2 = stringBuffer.length();
        int n3 = n2--;
        int n4 = 32;
        while (n2 > -1) {
            char c = stringBuffer.charAt(n2);
            if (bl && n4 == 59 && c == ';') {
                n = 59;
                n2 = -1;
            }
            if (!bl && (c == '>' || PdfDecoder.isXMLExtraction() && c == ';')) {
                bl = true;
                n4 = c;
            }
            if (!bl && c != ' ') {
                n = c;
                n2 = -1;
            }
            if (c == '<' || PdfDecoder.isXMLExtraction() && n4 == 59 && c == '&') {
                bl = false;
                if (c == '&' && n2 + 3 < n3 & stringBuffer.charAt(n2 + 2) == 't' && stringBuffer.charAt(n2 + 3) == ';') {
                    if (stringBuffer.charAt(n2 + 1) == 'l') {
                        n = 60;
                        n2 = -1;
                    } else if (stringBuffer.charAt(n2 + 1) == 'g') {
                        n = 62;
                        n2 = -1;
                    }
                }
            }
            if (bl && n4 == 59 && c == ' ') {
                n2 = -1;
                n = 59;
            }
            --n2;
        }
        return n;
    }

    private int[] reverse(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[n - i - 1];
        }
        return nArray2;
    }

    private void addAlignmentFormatting(boolean bl, int n, float[] fArray, float[] fArray2, int n2, int n3) {
        float f = (float)n - fArray[n3];
        float f2 = fArray2[n3] - (float)n;
        if (!bl && PdfDecoder.isXMLExtraction() && f > 0.0f && f2 > 0.0f && fArray[n3] > (float)n2 && fArray[n3] < (float)(n + n2)) {
            float f3 = f / f2;
            if (f3 > 1.0f) {
                f3 = 1.0f / f3;
            }
            if ((double)f3 > 0.95) {
                this.content[n3] = new StringBuffer(Fonts.cleanupTokens(this.content[n3].toString()));
                this.content[n3].insert(0, "<center>");
                this.content[n3].append("</center>\n");
            } else if (f2 < 10.0f & f > 30.0f) {
                this.content[n3] = new StringBuffer(Fonts.cleanupTokens(this.content[n3].toString()));
                this.content[n3].insert(0, "<right>");
                this.content[n3].append("</right>\n");
            }
        }
    }

    private void createLines(int n, int[] nArray, int n2, boolean bl, boolean bl2, boolean bl3) throws PdfException {
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (!oldTextExtraction && n2 == 1 | n2 == 2) {
            nArray = this.reverse(nArray);
        }
        if (oldTextExtraction | n2 == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n2 == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n2 == 3) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n2 == 2) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
        }
        block0: for (int i = 0; i < n; ++i) {
            int n3 = -1;
            int n4 = nArray[i];
            float f = -1.0f;
            float f2 = 0.0f;
            if (this.isUsed[n4] || !(this.writingMode[n4] == n2 | oldTextExtraction)) continue;
            while (true) {
                for (int j = 0; j < n; ++j) {
                    float f3;
                    int n5 = nArray[j];
                    if (this.isUsed[n5]) continue;
                    int n6 = (int)(fArray4[n5] - fArray4[n4]);
                    if (n6 < 0) {
                        n6 = -n6;
                    }
                    if (bl3 && n6 > 3 || n5 == n4 || !((fArray[n5] > fArray[n4] && n2 != 2 | oldTextExtraction) | (fArray[n5] < fArray[n4] && !oldTextExtraction && n2 == 2)) || !(this.writingMode[n4] == n2 | oldTextExtraction)) continue;
                    f2 = fArray[n5] - fArray2[n4];
                    if (!oldTextExtraction && n2 == 1 | n2 == 2) {
                        f2 = -f2;
                    }
                    if (f2 < 0.0f & f2 > -2.0f) {
                        f2 = 0.0f;
                    }
                    if (!((f3 = (fArray3[n5] + fArray4[n5]) / 2.0f) < fArray3[n4]) || !(f3 > fArray4[n4]) || !(f < 0.0f | f2 < f)) continue;
                    f = f2;
                    n3 = n5;
                }
                if (n3 == -1) continue block0;
                float f4 = fArray[n3] - fArray2[n4];
                if (!oldTextExtraction && n2 == 1 | n2 == 2) {
                    f4 = -f4;
                }
                String string = this.isGapASpace(n4, n3, f4, bl2, n2);
                if (bl && this.hadSpace != null && this.hadSpace[n4] | string.startsWith(" ")) continue block0;
                this.merge(n4, n3, string, true);
                n3 = -1;
                f = 1000000.0f;
            }
        }
    }

    public List findMultipleTermsInRectangle(int n, int n2, int n3, int n4, final int n5, int n6, String[] stringArray, boolean bl, boolean bl2, int n7, SearchListener searchListener) throws PdfException {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (searchListener.isCanceled()) break;
            float[] fArray = this.findTextInRectangle(n, n4, n3 + n, n2, n6, string, bl, true);
            if (fArray == null) continue;
            int n8 = fArray.length;
            for (int j = 0; j < n8; j += 2) {
                int n9 = (int)fArray[j];
                int n10 = (int)fArray[j + 1];
                int n11 = (int)this.endPoints[j];
                int n12 = (int)this.endPoints[j + 1];
                Rectangle rectangle = new Rectangle(n9, n12, n11 - n9, n10 - n12);
                arrayList.add(rectangle);
            }
        }
        if (bl2) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    Rectangle rectangle = (Rectangle)object;
                    Rectangle rectangle2 = (Rectangle)object2;
                    if (n5 == 0 || n5 == 180) {
                        if (rectangle.y == rectangle2.y) {
                            if (rectangle.x > rectangle2.x) {
                                return 1;
                            }
                            return -1;
                        }
                        if (rectangle.y > rectangle2.y) {
                            return -1;
                        }
                        return 1;
                    }
                    if (rectangle.x == rectangle.x) {
                        if (rectangle.y > rectangle2.y) {
                            return 1;
                        }
                        return -1;
                    }
                    if (rectangle.x > rectangle2.x) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        return arrayList;
    }

    public final float[] findTextInRectangle(int n, int n2, int n3, int n4, int n5, String string) throws PdfException {
        return this.findTextInRectangle(n, n2, n3, n4, n5, string, true, false);
    }

    public final float[] findTextInRectangle(int n, int n2, int n3, int n4, int n5, String string, boolean bl, boolean bl2) throws PdfException {
        int n6;
        if (string == null) {
            return null;
        }
        string = this.removeDuplicateSpaces(string);
        StringBuffer[] stringBufferArray = null;
        if (string.length() == 0) {
            return null;
        }
        float[] fArray = null;
        float[] fArray2 = null;
        this.validateCoordinates(n, n2, n3, n4);
        this.copyToArrays();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int n7 = nArray.length;
        if (n7 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n8 = this.getWritingMode(nArray, n7);
        if (this.includeTease) {
            int n9 = this.content.length;
            stringBufferArray = new StringBuffer[n9];
            for (int i = 0; i < n9; ++i) {
                if (this.content[i] == null) continue;
                stringBufferArray[i] = new StringBuffer(this.content[i].toString());
                if (!(this.moveType[i] == 0 | (this.moveType[i] == 2 && i < n9 - 1 && this.f_x1[i] < this.f_x2[i + 1] && this.f_x2[i] > this.f_x1[i + 1]))) continue;
                this.content[i].append("<link:");
                this.content[i].append(i + 1);
                this.content[i].append('>');
            }
        }
        this.createLines(n7, nArray, n8, true, false, true);
        float[] fArray3 = null;
        float[] fArray4 = null;
        float[] fArray5 = null;
        float[] fArray6 = null;
        boolean bl3 = false;
        if (oldTextExtraction | n8 == 0) {
            fArray3 = this.f_x1;
            fArray4 = this.f_x2;
            fArray5 = this.f_y1;
            fArray6 = this.f_y2;
        } else if (n8 == 1) {
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            fArray5 = this.f_y1;
            fArray6 = this.f_y2;
        } else if (n8 == 3) {
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
            fArray5 = this.f_x2;
            fArray6 = this.f_x1;
            bl3 = true;
        } else if (n8 == 2) {
            fArray3 = this.f_y2;
            fArray4 = this.f_y1;
            fArray6 = this.f_x1;
            fArray5 = this.f_x2;
            bl3 = true;
        } else {
            throw new PdfException("Illegal value " + n8 + "for currentWritingMode");
        }
        int[] nArray2 = this.getsortedUnusedFragments(false, true);
        n7 = nArray2.length;
        float f = -1.0f;
        int n10 = 0;
        Vector_Int vector_Int = new Vector_Int(20);
        Vector_Int vector_Int2 = new Vector_Int(20);
        Vector_String vector_String = new Vector_String(20);
        block1: for (n6 = n7 - 1; n6 > -1; --n6) {
            int n11 = nArray2[n6];
            if (this.content[n11] == null) continue;
            int n12 = n;
            while (n12 < n3) {
                f = this.scanLineForValue(stringBufferArray, this.removeDuplicateSpaces(this.content[n11]), string, n12, bl);
                if (f > (float)n && f < (float)n3 && (float)n2 > fArray5[n11] && (float)n4 < fArray6[n11] && f != -1.0f) {
                    String string2 = Strip.stripXML(PdfGroupingAlgorithms.removeHiddenMarkers(this.content[n11].toString())).toString();
                    if (bl3) {
                        if (n8 == 3) {
                            vector_Int.addElement((int)fArray6[n11]);
                            vector_Int.addElement((int)this.endX);
                            vector_Int2.addElement((int)fArray5[n11]);
                            vector_Int2.addElement((int)f);
                        } else {
                            vector_Int.addElement((int)fArray6[n11]);
                            vector_Int.addElement((int)f);
                            vector_Int2.addElement((int)fArray5[n11]);
                            vector_Int2.addElement((int)this.endX);
                        }
                    } else {
                        vector_Int.addElement((int)f);
                        vector_Int.addElement((int)fArray5[n11]);
                        vector_Int2.addElement((int)this.endX);
                        vector_Int2.addElement((int)fArray6[n11]);
                    }
                    if (this.includeTease) {
                        vector_String.addElement(this.tease.toString());
                    }
                    ++n10;
                    if (!bl2) {
                        n6 = n7;
                        n3 = n12;
                    }
                }
                if (n11 == n7 | f == -1.0f) continue block1;
                n12 = (int)f + 1;
            }
        }
        stringBufferArray = null;
        if (n10 > 0) {
            fArray = new float[n10 * 2];
            for (n6 = 0; n6 < n10 * 2; ++n6) {
                fArray[n6] = vector_Int.elementAt(n6);
            }
            fArray2 = new float[n10 * 2];
            for (n6 = 0; n6 < n10 * 2; ++n6) {
                fArray2[n6] = vector_Int2.elementAt(n6);
            }
            if (this.includeTease) {
                this.teasers = new String[n10];
                for (n6 = 0; n6 < n10; ++n6) {
                    this.teasers[n6] = vector_String.elementAt(n6);
                }
            }
        }
        LogWriter.writeLog("Text scan completed");
        this.endPoints = fArray2;
        return fArray;
    }

    private String removeDuplicateSpaces(String string) {
        if (string.indexOf("  ") != -1) {
            StringBuffer stringBuffer = this.removeDuplicateSpaces(new StringBuffer(string));
            string = stringBuffer.toString();
        }
        return string;
    }

    private StringBuffer removeDuplicateSpaces(StringBuffer stringBuffer) {
        if (stringBuffer.indexOf("  ") != -1) {
            int n = stringBuffer.length() - 1;
            for (int i = 0; i < n; ++i) {
                if (stringBuffer.charAt(i) != ' ' || stringBuffer.charAt(i + 1) != ' ') continue;
                stringBuffer.deleteCharAt(i + 1);
                --n;
                --i;
            }
        }
        return stringBuffer;
    }

    public float[] getEndPoints() {
        return this.endPoints;
    }

    public String[] getTeasers() {
        return this.teasers;
    }

    public void generateTeasers() {
        this.includeTease = true;
    }
}

