/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.decoding;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.decoding.OverStream;
import org.jpedal.objects.acroforms.decoding.images.FormXObject;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class FormStream
extends OverStream {
    private static boolean CHECKVITALVALUES = true;
    private FormXObject appearanceObject = null;
    protected Map currentField;
    protected int formPage = -1;
    protected int keySize;
    protected String[] commands;
    private static boolean messageShown = false;
    Map actions = new HashMap();
    private static final int FTint = 0;
    private static final int Ffint = 1;
    private String[] commandStrings = new String[]{"FT", "Ff"};

    protected FormStream() {
    }

    public FormStream(PdfObjectReader pdfObjectReader) {
        this.type = 2;
        this.currentPdfFile = pdfObjectReader;
        this.init();
    }

    protected void init() {
        String[] stringArray = new String[]{"E", "X", "D", "U", "Fo", "BI", "PO", "PC", "PV", "PI", "O", "C1", "K", "F", "V", "C2", "DC", "WS", "DS", "WP", "DP"};
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22};
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.actions.put(stringArray[i], new Integer(nArray[i]));
        }
    }

    private FormObject createAppearanceString(FormObject formObject, Map map) {
        this.currentField = map;
        Object object = this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect"));
        if (object != null && !this.addItem(this.formPage + " " + object)) {
            return null;
        }
        this.parseStream(formObject);
        if (this.type != 1) {
            this.decodeStream(formObject);
        }
        return formObject;
    }

    public FormObject createAppearanceString(Map map, PdfObjectReader pdfObjectReader, int n) {
        FormObject formObject = new FormObject();
        this.currentPdfFile = pdfObjectReader;
        this.currentField = map;
        this.formPage = n;
        Object object = this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect"));
        if (object != null && !this.addItem(this.formPage + " " + object)) {
            return null;
        }
        this.parseStream(formObject);
        if (this.type != 1) {
            this.decodeStream(formObject);
        }
        return formObject;
    }

    protected void parseStream(FormObject formObject) {
        formObject.setBorder(null);
        this.currentField.remove("P");
        String string = (String)this.currentField.get("obj");
        formObject.setPDFRef(string);
        if (CHECKVITALVALUES) {
            Object object;
            Iterator iterator;
            Object object2 = this.currentPdfFile.resolveToMapOrString("Parent", this.currentField.get("Parent"));
            Map map = object2 instanceof Map ? (Map)object2 : (object2 == null ? null : null);
            Map map2 = null;
            if (this.currentField.containsKey("Kids") && (iterator = this.currentPdfFile.resolveToMapOrString("Kids", this.currentField.get("Kids"))) instanceof Map) {
                map2 = (Map)((Object)iterator);
            }
            this.navigateToFindCommand(0, formObject, map, map2);
            this.navigateToFindCommand(1, formObject, map, map2);
            if (map != null) {
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object.equals("Kids") || this.currentField.containsKey(object)) continue;
                    this.currentField.put(object, map.get(object));
                }
            }
            this.createOrderedCommandArray();
            for (int i = 0; i < this.commands.length; ++i) {
                object = this.commands[i];
                Object object3 = this.currentPdfFile.resolveToMapOrString((String)object, this.currentField.get(object));
                this.parseCommand((String)object, object3, formObject);
            }
        } else {
            String string2;
            this.createOrderedCommandArray();
            for (int i = 0; i < this.commands.length; ++i) {
                string2 = this.commands[i];
                Object object = this.currentPdfFile.resolveToMapOrString(string2, this.currentField.get(string2));
                this.parseCommand(string2, object, formObject);
            }
            if (formObject.getFieldName() == null) {
                Object object = this.currentPdfFile.resolveToMapOrString("Parent", this.currentField.get("Parent"));
                if (object instanceof Map) {
                    string2 = (String)this.currentPdfFile.resolveToMapOrString("T", ((Map)object).get("T"));
                    formObject.setFieldName(string2);
                } else if (object != null) {
                    // empty if block
                }
            }
        }
    }

    private void navigateToFindCommand(int n, FormObject formObject, Map map, Map map2) {
        if (this.currentField.containsKey(this.commandStrings[n])) {
            if (n == 1) {
                this.commandFf(formObject, this.currentPdfFile.resolveToMapOrString(this.commandStrings[n], this.currentField.get(this.commandStrings[n])));
            } else if (n == 0) {
                this.resolveFTcommand(this.currentPdfFile.resolveToMapOrString("FT", this.currentField.get("FT")), formObject);
            }
        } else if (map != null) {
            if (map.containsKey(this.commandStrings[n])) {
                Object v = map.get(this.commandStrings[n]);
                if (n == 1) {
                    this.commandFf(formObject, this.currentPdfFile.resolveToMapOrString(this.commandStrings[n], v));
                } else if (n == 0) {
                    this.resolveFTcommand(this.currentPdfFile.resolveToMapOrString("FT", v), formObject);
                }
                this.currentField.put(this.commandStrings[n], v);
                map.remove(this.commandStrings[n]);
            }
        } else if (map2 == null || map2.containsKey(this.commandStrings[n])) {
            // empty if block
        }
    }

    private void createOrderedCommandArray() {
        Iterator iterator = this.currentField.keySet().iterator();
        this.keySize = this.currentField.keySet().size();
        this.commands = new String[this.keySize];
        int n = this.keySize - 1;
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("AP")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            if (string.equals("Kids")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            if (string.equals("H")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            if (string.equals("I")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            if (string.equals("AA")) {
                this.commands[n] = string;
                --n;
                continue;
            }
            this.commands[n2] = string;
            ++n2;
        }
    }

    protected boolean parseCommand(String string, Object object, FormObject formObject) {
        boolean bl = false;
        if (string.equals("Parent")) {
            Map map;
            if (object instanceof Map && (map = (Map)object).containsKey("V")) {
                this.commandV(object, formObject);
            }
        } else if (string.equals("V")) {
            this.commandV(object, formObject);
        } else if (string.equals("Q")) {
            formObject.setHorizontalAlign(object);
        } else if (!string.equals("AP") && !string.equals("DA")) {
            if (string.equals("TU")) {
                formObject.setUserName((String)object);
                LogWriter.writeFormLog("{stream} userName NOT IMPLEMENTED=" + object, false);
            } else if (string.equals("T")) {
                if (this.currentField.containsKey("Parent")) {
                    String string2 = this.searchAndAdd("Parent", this.currentField, "T");
                    formObject.setFieldName(string2);
                } else {
                    formObject.setFieldName((String)object);
                }
            } else if (string.equals("TM")) {
                formObject.setMapName((String)object);
                LogWriter.writeFormLog("{stream} mapName NOT IMPLEMENTED=" + object, false);
            } else if (string.equals("AS")) {
                String string3 = null;
                if (object instanceof Map) {
                    Map map = (Map)object;
                    map.remove("PageNumber");
                    if (map.containsKey("rawValue")) {
                        string3 = (String)this.currentPdfFile.resolveToMapOrString("rawValue", map.get("rawValue"));
                        if (map.size() > 1) {
                            LogWriter.writeFormLog("{stream} AS IS MAP UNKNOWN field=" + object, false);
                        }
                    } else {
                        LogWriter.writeFormLog("{stream} AS IS MAP field=" + object, false);
                    }
                } else {
                    string3 = (String)object;
                }
                string3 = Strip.checkRemoveLeadingSlach(string3);
                formObject.setDefaultState(string3);
            } else if (string.equals("F")) {
                this.workOutCharachteristic((String)object, formObject);
            } else if (!string.equals("Kids")) {
                if (string.equals("Opt")) {
                    HashMap hashMap = new HashMap();
                    String[] stringArray = object instanceof String ? this.populateItemsArrayWithValues((String)object, hashMap) : this.populateItemsArrayWithValues((String)this.currentPdfFile.resolveToMapOrString("rawValue", ((Map)object).get("rawValue")), hashMap);
                    if (hashMap.size() < 1) {
                        formObject.setValuesMap(null);
                    } else {
                        formObject.setValuesMap(hashMap);
                    }
                    formObject.setlistOfItems(stringArray);
                } else if (string.equals("BS")) {
                    formObject.setBorder(object);
                } else if (string.equals("Ti")) {
                    formObject.setTopIndex(new int[]{Integer.parseInt((String)object)});
                } else if (string.equals("MaxLen")) {
                    formObject.setMaxTextLength(Integer.parseInt((String)object));
                } else if (string.equals("Rect")) {
                    this.createBoundsRectangle((String)this.currentPdfFile.resolveToMapOrString("Rect", this.currentField.get("Rect")), formObject);
                } else if (string.equals("FT")) {
                    String string4 = null;
                    if (object instanceof Map) {
                        Map map = (Map)object;
                        map.remove("PageNumber");
                        if (map.containsKey("rawValue")) {
                            string4 = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("rawValue", map.get("rawValue")));
                            if (map.size() > 1) {
                                LogWriter.writeFormLog("{stream} type IS MAP UNKNOWN field=" + object, false);
                            }
                        } else {
                            LogWriter.writeFormLog("{stream} type IS MAP field=" + object, false);
                        }
                    } else {
                        string4 = Strip.checkRemoveLeadingSlach((String)object);
                    }
                    if (string4 != null) {
                        if (string4.equals("Btn")) {
                            formObject.setType(0);
                        } else if (string4.equals("Tx")) {
                            formObject.setType(2);
                        } else if (string4.equals("Ch")) {
                            formObject.setType(1);
                        } else if (string4.equals("Sig")) {
                            formObject.setType(3);
                        }
                    }
                } else if (string.equals("MK")) {
                    this.commandMK((Map)object, formObject);
                } else if (string.equals("Ff")) {
                    this.commandFf(formObject, object);
                } else if (string.equals("AA")) {
                    this.resolveAdditionalAction(object, formObject);
                } else if (!string.equals("Type")) {
                    if (string.equals("Subtype")) {
                        if (!object.equals("/Widget")) {
                            bl = true;
                        }
                    } else if (string.equals("PageNumber")) {
                        formObject.setPageNumber(object);
                    } else if (string.equals("StructParent")) {
                        LogWriter.writeFormLog("{stream} CHECK 'StructParent' NOT Implemented", false);
                    } else if (string.equals("A")) {
                        this.commandA(object, formObject);
                    } else if (string.equals("DV")) {
                        if (object instanceof String) {
                            formObject.setDefaultValue((String)object);
                        } else if (object instanceof Map) {
                            Map map = (Map)object;
                            if (map.containsKey("rawValue")) {
                                formObject.setDefaultValue((String)this.currentPdfFile.resolveToMapOrString("rawValue", map.get("rawValue")));
                            } else if (!map.containsKey("PageNumber")) {
                                LogWriter.writeFormLog("{stream} unknown entry as Map DV command NOT IMPLEMENTED field=" + map, false);
                            }
                        } else {
                            LogWriter.writeFormLog("{stream} unknown DV command NOT IMPLEMENTED field=" + object, false);
                        }
                    } else if (!string.equals("I") && !string.equals("H")) {
                        if (string.equals("DR")) {
                            if (object instanceof Map) {
                                LogWriter.writeFormLog("{stream} DR command this Must have a Font entry used for the default font with text map UNIMPLEMENTED field", false);
                            } else {
                                LogWriter.writeFormLog("{stream} DR command this Must have a Font entry used for the default font with text non map UNIMPLEMENTED field", false);
                            }
                        } else if (string.equals("Lock")) {
                            LogWriter.writeFormLog("{stream} Lock command UNIMPLEMENTED only needed for signiture fields, field=" + object, false);
                        } else if (!string.equals("NeedAppearances")) {
                            if (string.equals("NM")) {
                                this.commandNM(formObject, object);
                            } else if (!string.equals("obj")) {
                                LogWriter.writeFormLog("{stream} UNIMPLEMENTED command - " + string + " in form Stream=\n\t" + object, false);
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    private String searchAndAdd(String string, Map map, String string2) {
        Object object = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
        String string3 = null;
        if (object instanceof Map) {
            Object object2;
            Map map2 = (Map)object;
            if (map2.containsKey(string)) {
                string3 = this.searchAndAdd(string, map2, string2);
            }
            if (map2.containsKey(string2) && (object2 = this.currentPdfFile.resolveToMapOrString(string2, map2.get(string2))) instanceof String) {
                string3 = string3 == null ? (String)object2 : string3 + "." + object2;
            }
        }
        return string3;
    }

    private void resolveFTcommand(Object object, FormObject formObject) {
        String string = null;
        if (object instanceof Map) {
            Map map = (Map)object;
            map.remove("PageNumber");
            if (map.containsKey("rawValue")) {
                string = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("rawValue", map.get("rawValue")));
                if (map.size() > 1) {
                    LogWriter.writeFormLog("{stream} type IS MAP UNKNOWN field=" + object, false);
                }
            } else {
                LogWriter.writeFormLog("{stream} type IS MAP field=" + object, false);
            }
        } else {
            string = Strip.checkRemoveLeadingSlach((String)object);
        }
        if (string != null) {
            if (string.equals("Btn")) {
                formObject.setType(0);
            } else if (string.equals("Tx")) {
                formObject.setType(2);
            } else if (string.equals("Ch")) {
                formObject.setType(1);
            } else if (string.equals("Sig")) {
                formObject.setType(3);
            }
        }
    }

    protected void commandA(Object object, FormObject formObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("A", object);
        this.resolveAdditionalAction(hashMap, formObject);
    }

    private void commandFf(FormObject formObject, Object object) {
        String string = (String)object;
        if (string != null) {
            int n = Integer.parseInt(string);
            boolean[] blArray = new boolean[32];
            blArray[1] = (n & 1) == 1;
            blArray[2] = (n & 2) == 2;
            blArray[3] = (n & 4) == 4;
            blArray[12] = (n & 0x1000) == 4096;
            blArray[13] = (n & 0x2000) == 8192;
            blArray[14] = (n & 0x4000) == 16384;
            blArray[15] = (n & 0x8000) == 32768;
            blArray[16] = (n & 0x10000) == 65536;
            blArray[17] = (n & 0x20000) == 131072;
            blArray[18] = (n & 0x40000) == 262144;
            blArray[19] = (n & 0x80000) == 524288;
            blArray[20] = (n & 0x100000) == 0x100000;
            blArray[21] = (n & 0x200000) == 0x200000;
            blArray[22] = (n & 0x400000) == 0x400000;
            blArray[23] = (n & 0x800000) == 0x800000;
            blArray[24] = (n & 0x1000000) == 0x1000000;
            blArray[25] = (n & 0x2000000) == 0x2000000;
            blArray[25] = (n & 0x2000000) == 0x2000000;
            blArray[26] = (n & 0x4000000) == 0x4000000;
            formObject.setFlags(blArray);
            if (blArray[3] || blArray[22] || blArray[24] || blArray[26]) {
                LogWriter.writeFormLog("{stream} new flags (3 22 24 26) UNIMPLEMENTED flags - 3=" + blArray[3] + " 22=" + blArray[22] + " 24=" + blArray[24] + " 26= " + blArray[26], false);
            }
        }
    }

    protected void commandNM(FormObject formObject, Object object) {
        formObject.setFieldName((String)object);
    }

    private void commandV(Object object, FormObject formObject) {
        Object object2;
        String string = null;
        if (object instanceof Map) {
            object2 = (Map)object;
            if (object2.containsKey("rawValue")) {
                string = (String)this.currentPdfFile.resolveToMapOrString("rawValue", object2.get("rawValue"));
            } else if (!object2.containsKey("Type") || !Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("Type", object2.get("Type"))).equals("Sig")) {
                LogWriter.writeFormLog("{stream} V Map UNKNOWN=" + object, false);
            }
        } else {
            string = (String)object;
        }
        if (string != null) {
            object2 = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("FT", this.currentField.get("FT")));
            if (((String)object2).equals("Btn")) {
                String string2 = (String)this.currentPdfFile.resolveToMapOrString("Ff", this.currentField.get("Ff"));
                if (string2 != null) {
                    int n = Integer.parseInt(string2);
                    if ((n & 0x8000) == 32768) {
                        formObject.setChildOnState(string);
                    } else if ((n & 0x10000) != 65536) {
                        formObject.setCurrentState(string);
                    }
                } else {
                    formObject.setCurrentState(string);
                }
            } else if (((String)object2).equals("Tx")) {
                int n = string.length();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '\\') {
                        if ((c = string.charAt(++i)) == 't') {
                            stringBuffer.append('\t');
                            continue;
                        }
                        if (c == 'n') {
                            stringBuffer.append('\n');
                            continue;
                        }
                        if (c == 'r') {
                            stringBuffer.append('\r');
                            continue;
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    stringBuffer.append(c);
                }
                formObject.setTextValue(stringBuffer.toString());
            } else if (((String)object2).equals("Ch")) {
                String string3 = (String)this.currentPdfFile.resolveToMapOrString("V", string);
                formObject.setSelectedItem(string3);
            } else if (((String)object2).equals("Sig")) {
                LogWriter.writeFormLog("{stream} value - signiture value NOT IMPLEMENTED field=" + string, false);
            } else {
                LogWriter.writeFormLog("{stream} NOT IMPLEMENTED command=V field=" + string + " currentField=" + ConvertToString.convertMapToString(this.currentField, this.currentPdfFile), false);
            }
        }
    }

    private void resolveAdditionalAction(Object object, FormObject formObject) {
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object2;
                String string = (String)iterator.next();
                Object v = this.actions.get(string);
                if (v != null) {
                    int n = (Integer)v;
                    object2 = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    continue;
                }
                if (string.equals("A")) {
                    Object object3 = map.get("A");
                    if (object3 instanceof String) {
                        object3 = this.currentPdfFile.readObject((String)object3, false, null);
                    }
                    if ((object2 = this.currentPdfFile.resolveToMapOrString("A", object3)) instanceof Map) {
                        object2 = this.resolveCompleteMap((Map)object2, this.currentPdfFile);
                    }
                    formObject.setAaction(object2);
                    continue;
                }
                if (string.equals("C")) {
                    Object object4 = this.currentPdfFile.resolveToMapOrString("C", map.get("C"));
                    continue;
                }
                if (string.equals("PageNumber")) continue;
                LogWriter.writeFormLog("{stream} " + string + " NOT IMPLEMENTED in FormStream.resolveAdditionalAction field=" + this.currentPdfFile.resolveToMapOrString(string, map.get(string)), false);
            }
        } else {
            LogWriter.writeFormLog("{stream} AdditionAction is String UNIMPLEMENTED", false);
        }
    }

    private Map resolveCompleteMap(Map map, PdfObjectReader pdfObjectReader) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            String string = (String)iterator.next();
            Object object = pdfObjectReader.resolveToMapOrString(string, v = map.get(string));
            if (object instanceof Map) {
                object = this.resolveCompleteMap((Map)object, pdfObjectReader);
            }
            map.put(string, object);
        }
        return map;
    }

    private void trickleThroughMaps(Map map, String string, boolean bl, boolean bl2, FormObject formObject) {
        if (string.equals("N")) {
            this.N(map, bl, bl2, formObject);
        } else if (string.equals("D")) {
            this.D(map, bl, bl2, formObject);
        } else if (string.equals("R")) {
            this.R(map, bl, bl2, formObject);
        } else {
            LogWriter.writeFormLog("{stream} NOT SINGLED in Trickle " + string + '=', bl2);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string2 = (String)iterator.next();
                Object object2 = this.currentPdfFile.resolveToMapOrString(string2, map.get(string2));
                if (object2 instanceof Map) {
                    object = (Map)object2;
                    this.trickleThroughMaps((Map)object, string2, bl, bl2, formObject);
                    continue;
                }
                if (string2.equals("SW")) {
                    object = Strip.checkRemoveLeadingSlach((String)object2);
                    if (((String)object).equals("N")) continue;
                    LogWriter.writeFormLog("{stream} UNIMPLEMENTED SW field=" + object2, bl2);
                    continue;
                }
                if (string2.equals("PageNumber")) continue;
                LogWriter.writeFormLog("{stream} NON SINGLED command=" + string2 + " field=" + object2, bl2);
            }
        }
    }

    protected boolean commandAP(Map map, FormObject formObject) {
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
            if (!(object instanceof Map)) continue;
            this.trickleThroughMaps((Map)object, string, false, false, formObject);
        }
        bl = true;
        return bl;
    }

    private void resolveKidsArray(Object object, boolean bl, boolean bl2, FormObject formObject) {
        boolean bl3 = false;
        StringTokenizer stringTokenizer = null;
        Map map = null;
        Iterator iterator = null;
        HashMap<String, FormObject> hashMap = new HashMap<String, FormObject>();
        if (object instanceof String) {
            bl3 = true;
        }
        if (!bl3) {
            map = (Map)object;
            iterator = map.keySet().iterator();
        } else {
            stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object), "R");
        }
        while (!bl3 && iterator.hasNext() || bl3 && stringTokenizer.hasMoreTokens()) {
            Object object2;
            String string;
            if (!bl3) {
                string = (String)iterator.next();
                object2 = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
            } else {
                string = stringTokenizer.nextToken().trim() + " R";
                object2 = this.currentPdfFile.readObject(string, false, null);
            }
            if (!(object2 instanceof Map)) continue;
            FormObject formObject2 = formObject.duplicate();
            hashMap.put(string, this.createAppearanceString(formObject2, (Map)object2));
        }
        formObject.setKidData(hashMap);
    }

    private BufferedImage rotate(BufferedImage bufferedImage, double d) {
        if (bufferedImage == null) {
            return null;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = (int)Math.round((double)n2 * Math.abs(Math.sin(d)) + (double)n * Math.abs(Math.cos(d)));
        int n4 = (int)Math.round((double)n2 * Math.abs(Math.cos(d)) + (double)n * Math.abs(Math.sin(d)));
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((n3 - n) / 2, (n4 - n2) / 2);
        affineTransform.rotate(d, n / 2, n2 / 2);
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private void N(Map map, boolean bl, boolean bl2, FormObject formObject) {
        block13: {
            Object object;
            block12: {
                if (map.containsKey("MK")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString("MK", map.get("MK"));
                    this.commandMK((Map)object, formObject);
                }
                if (map.containsKey("CachedStream")) {
                    this.currentPdfFile.readStreamIntoMemory(map);
                }
                if (!map.containsKey("DecodedStream")) break block12;
                if (formObject.hasNormalOff()) break block13;
                if (this.appearanceObject == null) {
                    this.appearanceObject = new FormXObject(this.currentPdfFile);
                }
                formObject.setNormalAppOff(this.rotate(this.appearanceObject.decode(map), (double)formObject.getRotation() * Math.PI / 180.0), null);
                if (!showIconsOnCreate) break block13;
                ShowGUIMessage.showGUIMessage("N normalAppImage", formObject.getNormalOffImage(), "normalAppImage");
                break block13;
            }
            object = map.keySet().iterator();
            while (object.hasNext()) {
                Object object2;
                String string = (String)object.next();
                if (string.equals("Off")) {
                    object2 = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOff(this.rotate(this.appearanceObject.decode((Map)object2), (double)formObject.getRotation() * Math.PI / 180.0), string);
                    if (!showIconsOnCreate) continue;
                    ShowGUIMessage.showGUIMessage("N normalAppOff", formObject.getNormalOffImage(), "normalAppOff");
                    continue;
                }
                if (string.equals("On")) {
                    object2 = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOn(this.rotate(this.appearanceObject.decode((Map)object2), (double)formObject.getRotation() * Math.PI / 180.0), string);
                    if (showIconsOnCreate) {
                        ShowGUIMessage.showGUIMessage("normalAppOn", formObject.getNormalOnImage(), "normalAppOn");
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setNormalAppOff(OpaqueImage, null);
                    continue;
                }
                if (string.equals("PageNumber")) continue;
                formObject.setStateToCheck(string);
                object2 = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                if (object2 instanceof Map) {
                    Map map2 = (Map)object2;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOn(this.rotate(this.appearanceObject.decode(map2), (double)formObject.getRotation() * Math.PI / 180.0), string);
                    if (showIconsOnCreate) {
                        ShowGUIMessage.showGUIMessage("N normalAppOn", formObject.getNormalOnImage(), "normalAppOn");
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setNormalAppOff(OpaqueImage, null);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.N stateTocheck=" + string + " field=" + object2, bl2);
            }
        }
    }

    private void R(Map map, boolean bl, boolean bl2, FormObject formObject) {
        if (map.containsKey("MK")) {
            LogWriter.writeFormLog("{stream} MK command in Rollover appearance field=" + this.currentPdfFile.resolveToMapOrString("MK", map.get("MK")), bl2);
        }
        if (map.containsKey("CachedStream")) {
            this.currentPdfFile.readStreamIntoMemory(map);
        }
        if (map.containsKey("DecodedStream")) {
            if (this.appearanceObject == null) {
                this.appearanceObject = new FormXObject(this.currentPdfFile);
            }
            formObject.setRolloverAppOff(this.rotate(this.appearanceObject.decode(map), (double)formObject.getRotation() * Math.PI / 180.0));
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                if (string.equals("Off")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOff(this.rotate(this.appearanceObject.decode((Map)object), (double)formObject.getRotation() * Math.PI / 180.0));
                    continue;
                }
                if (string.equals("On")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOn(this.rotate(this.appearanceObject.decode((Map)object), (double)formObject.getRotation() * Math.PI / 180.0));
                    if (formObject.hasRolloverOff()) continue;
                    formObject.setRolloverAppOff(OpaqueImage);
                    continue;
                }
                if (string.equals("PageNumber")) continue;
                object = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                if (object instanceof Map) {
                    Map map2 = (Map)object;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setRolloverAppOn(this.rotate(this.appearanceObject.decode(map2), (double)formObject.getRotation() * Math.PI / 180.0));
                    if (formObject.hasRolloverOff()) continue;
                    formObject.setRolloverAppOff(OpaqueImage);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.R stateTocheck=" + string + " field=" + object, bl2);
            }
        }
    }

    private void D(Map map, boolean bl, boolean bl2, FormObject formObject) {
        if (map.containsKey("MK")) {
            LogWriter.writeFormLog("{stream} MK command in Down appearance field=" + this.currentPdfFile.resolveToMapOrString("MK", map.get("MK")), bl2);
        }
        if (map.containsKey("CachedStream")) {
            this.currentPdfFile.readStreamIntoMemory(map);
        }
        if (map.containsKey("DecodedStream")) {
            if (this.appearanceObject == null) {
                this.appearanceObject = new FormXObject(this.currentPdfFile);
            }
            formObject.setDownAppOff(this.rotate(this.appearanceObject.decode(map), (double)formObject.getRotation() * Math.PI / 180.0));
        } else {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                if (string.equals("Off")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOff(this.rotate(this.appearanceObject.decode((Map)object), (double)formObject.getRotation() * Math.PI / 180.0));
                    continue;
                }
                if (string.equals("On")) {
                    object = (Map)this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOn(this.rotate(this.appearanceObject.decode((Map)object), (double)formObject.getRotation() * Math.PI / 180.0));
                    if (formObject.hasDownOff()) continue;
                    formObject.setDownAppOff(OpaqueImage);
                    continue;
                }
                if (string.equals("PageNumber")) continue;
                object = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
                if (object instanceof Map) {
                    Map map2 = (Map)object;
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setDownAppOn(this.rotate(this.appearanceObject.decode(map2), (double)formObject.getRotation() * Math.PI / 180.0));
                    if (formObject.hasDownOff()) continue;
                    formObject.setDownAppOff(OpaqueImage);
                    continue;
                }
                LogWriter.writeFormLog("{stream} String NOT IMPLEMENTED in FormStream.D stateTocheck=" + string + " field=" + object, bl2);
            }
        }
    }

    protected void commandMK(Map map, FormObject formObject) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            Object object2 = this.currentPdfFile.resolveToMapOrString(string, map.get(string));
            if (string.equals("CA")) {
                formObject.setNormalCaption((String)object2);
                continue;
            }
            if (string.equals("BC")) {
                object = this.generateColorFromString((String)object2);
                formObject.setBorderColor((Color)object);
                continue;
            }
            if (string.equals("BG")) {
                object = this.generateColorFromString((String)object2);
                formObject.setBackgroundColor((Color)object);
                continue;
            }
            if (string.equals("R")) {
                formObject.setRotation(Integer.parseInt((String)object2));
                continue;
            }
            if (string.equals("RC")) {
                formObject.setRolloverCaption((String)object2);
                continue;
            }
            if (string.equals("AC")) {
                formObject.setDownCaption((String)object2);
                continue;
            }
            if (string.equals("I")) {
                if (object2 instanceof Map) {
                    if (this.appearanceObject == null) {
                        this.appearanceObject = new FormXObject(this.currentPdfFile);
                    }
                    formObject.setNormalAppOff(this.rotate(this.appearanceObject.decode((Map)object2), (double)formObject.getRotation() * Math.PI / 180.0), null);
                    if (!showIconsOnCreate) continue;
                    ShowGUIMessage.showGUIMessage("MKI normalAppImage", formObject.getNormalOffImage(), "normalAppImage");
                    continue;
                }
                LogWriter.writeFormLog("{stream} MK I NOT implemented field=" + object2, false);
                continue;
            }
            if (string.equals("RI")) {
                LogWriter.writeFormLog("{stream} MK RI NOT implemented field=" + object2, false);
                continue;
            }
            if (string.equals("IX")) {
                LogWriter.writeFormLog("{stream} MK IX NOT implemented field=" + object2, false);
                continue;
            }
            if (string.equals("IF")) {
                if (object2 instanceof Map) {
                    object = (Map)object2;
                    if (object.containsKey("SW")) {
                        String string2 = Strip.checkRemoveLeadingSlach((String)this.currentPdfFile.resolveToMapOrString("SW", object.get("SW")));
                        if (string2.equals("A")) {
                            formObject.setWhenToScaleIcon("A");
                            continue;
                        }
                        if (string2.equals("N")) {
                            formObject.setWhenToScaleIcon("N");
                            continue;
                        }
                        LogWriter.writeFormLog("{stream} MK IF Map Unimplemented command=" + string2 + " field=" + object2, false);
                        continue;
                    }
                    if (object.size() < 1) continue;
                    LogWriter.writeFormLog("{stream} MK IF unknown command type field=" + object, false);
                    continue;
                }
                LogWriter.writeFormLog("{stream} MK IF String NOT implemented field=" + object2, false);
                continue;
            }
            if (string.equals("TP")) {
                formObject.setTextPosition(Integer.parseInt((String)object2));
                continue;
            }
            if (string.equals("PageNumber")) continue;
            LogWriter.writeFormLog("{stream} MK command NOT IMPLEMENTED command=" + string, false);
        }
    }

    private String[] populateItemsArrayWithValues(String string, Map map) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]()\\", true);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = null;
        String string2 = null;
        String[] stringArray2 = new String[2];
        int n4 = 0;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("\\") && !bl2) {
                bl2 = true;
                continue;
            }
            bl2 = false;
            if (string2.equals("(")) {
                if (++n2 == 1) {
                    bl = true;
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(string2);
                continue;
            }
            if (string2.equals(")")) {
                if (--n2 == 0) {
                    bl = false;
                    if (n3 < 2) {
                        stringArray[n++] = stringBuffer.toString();
                        continue;
                    }
                    if (n4 >= 2) continue;
                    stringArray2[n4++] = stringBuffer.toString();
                    continue;
                }
                stringBuffer.append(string2);
                continue;
            }
            if (!bl && string2.equals("[")) {
                ++n3;
                continue;
            }
            if (n3 > 1 && string2.equals("]")) {
                if (--n3 != 1) continue;
                if (n4 == 2) {
                    map.put(stringArray2[0], stringArray2[1]);
                    n4 = 0;
                }
                stringArray[n++] = stringBuffer.toString();
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(string2);
        }
        if (n2 != 0) {
            stringArray[n++] = stringBuffer.toString();
        }
        String[] stringArray3 = new String[n];
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            stringArray3[n] = stringArray[n].trim();
        }
        stringArray = stringArray3;
        return stringArray;
    }

    protected void decodeStream(FormObject formObject) {
        for (int i = 0; i < this.keySize; ++i) {
            String string = this.commands[i];
            Object object = this.currentPdfFile.resolveToMapOrString(string, this.currentField.get(string));
            this.decodeFormCommand(string, object, formObject);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean decodeFormCommand(String string, Object object, FormObject formObject) {
        if (object == null) {
            return false;
        }
        boolean bl = false;
        if (string.equals("AP")) {
            boolean bl2 = this.commandAP((Map)object, formObject);
            if (bl2) return bl;
        }
        if (string.equals("I")) {
            String string2 = Strip.removeArrayDeleminators((String)object);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
            }
            formObject.setTopIndex(nArray);
            return bl;
        } else if (string.equals("H")) {
            this.commandH(object, formObject);
            return bl;
        } else if (string.equals("Kids")) {
            this.resolveKidsArray(object, false, false, formObject);
            return bl;
        } else {
            void var5_14;
            Object object2;
            Object object3;
            if (!string.equals("DA")) return true;
            byte[] byArray = new byte[]{};
            if (object instanceof Map) {
                object3 = (Map)object;
                object3.remove("PageNumber");
                if (object3.containsKey("rawValue")) {
                    object2 = this.currentPdfFile.resolveToMapOrString("rawValue", object3.get("rawValue"));
                    if (object2 instanceof byte[]) {
                        Object object4 = object2;
                    } else {
                        byte[] byArray2 = ((String)object2).getBytes();
                    }
                    this.decodeFontCommandObj((String)this.currentPdfFile.resolveToMapOrString("rawValue", object3.get("rawValue")), formObject);
                    if (object3.size() > 1) {
                        LogWriter.writeFormLog("{stream} type IS MAP UNKNOWN field=" + object, false);
                    }
                } else {
                    LogWriter.writeFormLog("{stream} DA IS MAP field=" + object, false);
                }
            } else if (object instanceof byte[]) {
                byte[] byArray3 = (byte[])object;
            } else {
                byte[] byArray4 = ((String)object).getBytes();
                this.decodeFontCommandObj((String)object, formObject);
            }
            object3 = formObject.getContents();
            if (object3 == null) return bl;
            object2 = ((String)object3).getBytes();
            int n = ((void)var5_14).length;
            byte[] byArray5 = new byte[n + ((byte[])object2).length];
            for (int i = 0; i < byArray5.length; ++i) {
                byArray5[i] = i < n ? var5_14[i] : object2[i - n];
            }
            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder();
            pdfStreamDecoder.decodeStreamIntoObjects(byArray5);
            StringBuffer stringBuffer = pdfStreamDecoder.getlastTextStreamDecoded();
            if (stringBuffer == null) return bl;
            formObject.setTextValue(stringBuffer.toString());
        }
        return bl;
    }

    protected void commandH(Object object, FormObject formObject) {
        String string = Strip.checkRemoveLeadingSlach((String)object);
        if (string.equals("T") || string.equals("P")) {
            if (!formObject.hasDownImage()) {
                formObject.setOffsetDownApp();
            }
        } else if (string.equals("N")) {
            formObject.setNoDownIcon();
        } else if (string.equals("I")) {
            formObject.setInvertForDownIcon();
        } else if (!string.equals("O")) {
            LogWriter.writeFormLog("{FormStream.commandH} H command NOT IMPLEMENTED field=" + object, false);
        }
    }
}

