/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.decoding;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.fonts.PdfFont;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.decoding.FormDecoder;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class OverStream
implements FormDecoder {
    public static final boolean debugUnimplemented = false;
    public static final boolean debug = false;
    public static final boolean exitOnError = false;
    protected static boolean showIconsOnCreate = false;
    protected int type;
    public static final int READONLY = 1;
    public static final int REQUIRED = 2;
    public static final int NOEXPORT = 4;
    public static final int MULTILINE = 4096;
    public static final int PASSWORD = 8192;
    public static final int NOTOGGLETOOFF = 16384;
    public static final int RADIO = 32768;
    public static final int PUSHBUTTON = 65536;
    public static final int COMBO = 131072;
    public static final int EDIT = 262144;
    public static final int SORT = 524288;
    public static final int FILESELECT = 0x100000;
    public static final int MULTISELECT = 0x200000;
    public static final int DONOTSPELLCHECK = 0x400000;
    public static final int DONOTSCROLL = 0x800000;
    public static final int COMB = 0x1000000;
    public static final int RADIOINUNISON = 0x2000000;
    public static final int RICHTEXT = 0x2000000;
    public static final int COMMITONSELCHANGE = 0x4000000;
    protected static final BufferedImage OpaqueImage = new BufferedImage(20, 20, 2);
    protected PdfObjectReader currentPdfFile;
    private static Map currentItems = new HashMap();

    protected OverStream() {
    }

    public OverStream(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
    }

    public boolean doesItemExist(Object object) {
        if (object == null) {
            return false;
        }
        return currentItems.containsKey(object);
    }

    public boolean addItem(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.doesItemExist(object = Strip.removeArrayDeleminators(object.toString()))) {
            currentItems.put(object, "x");
            return true;
        }
        return false;
    }

    public void resetItems() {
        currentItems = new HashMap();
    }

    protected Rectangle createBoundsRectangle(String string, FormObject formObject) {
        double d;
        string = Strip.removeArrayDeleminators(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        double d2 = Float.parseFloat(stringTokenizer.nextToken());
        double d3 = Float.parseFloat(stringTokenizer.nextToken());
        double d4 = Float.parseFloat(stringTokenizer.nextToken());
        double d5 = Float.parseFloat(stringTokenizer.nextToken());
        if (d2 > d4) {
            d = d2;
            d2 = d4;
            d4 = d;
        }
        if (d3 > d5) {
            d = d3;
            d3 = d5;
            d5 = d;
        }
        Rectangle rectangle = new Rectangle((int)d2, (int)d3, (int)(d4 - d2), (int)(d5 - d3));
        if (formObject == null) {
            return rectangle;
        }
        formObject.setBoundingRectangle(rectangle);
        return null;
    }

    protected Color generateColorFromString(String string) {
        Object object;
        string = Strip.removeArrayDeleminators(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "() ,");
        String[] stringArray = new String[4];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            stringArray[n] = object;
            ++n;
        }
        object = null;
        if (n == 0) {
            LogWriter.writeFormLog("{stream} CHECK transparent color", false);
            object = new Color(0, 0, 0, 0);
        } else if (n == 1) {
            float f = Float.parseFloat(stringArray[0]);
            object = f <= 1.0f ? new Color(f, f, f) : new Color((int)f, (int)f, (int)f);
        } else if (n == 3) {
            float f = Float.parseFloat(stringArray[0]);
            float f2 = Float.parseFloat(stringArray[1]);
            float f3 = Float.parseFloat(stringArray[2]);
            object = f <= 1.0f && f2 <= 1.0f && f3 <= 1.0f ? new Color(f, f2, f3) : new Color((int)f, (int)f2, (int)f3);
        } else if (n == 4) {
            LogWriter.writeFormLog("{stream} CHECK cmyk color=" + stringArray[0] + ' ' + stringArray[1] + ' ' + stringArray[2] + ' ' + stringArray[3], false);
            DeviceCMYKColorSpace deviceCMYKColorSpace = new DeviceCMYKColorSpace();
            deviceCMYKColorSpace.setColor(stringArray, 3);
            object = (Color)((Object)deviceCMYKColorSpace.getColor());
        } else {
            LogWriter.writeFormLog("{stream} ERROR i=" + n + " toks=" + ConvertToString.convertArrayToString(stringArray), false);
        }
        return object;
    }

    public void workOutCharachteristic(String string, FormObject formObject) {
        if (string != null) {
            int n = Integer.parseInt(string);
            if ((n & 1) == 1) {
                formObject.setCharacteristic(1);
            }
            if ((n & 2) == 2) {
                formObject.setCharacteristic(2);
            }
            if ((n & 4) == 4) {
                formObject.setCharacteristic(3);
            }
            if ((n & 8) == 8) {
                formObject.setCharacteristic(4);
            }
            if ((n & 0x10) == 16) {
                formObject.setCharacteristic(5);
            }
            if ((n & 0x20) == 32) {
                formObject.setCharacteristic(6);
            }
            if ((n & 0x40) == 64) {
                formObject.setCharacteristic(7);
            }
            if ((n & 0x80) == 128) {
                formObject.setCharacteristic(8);
            }
            if ((n & 0x100) == 256) {
                formObject.setCharacteristic(9);
            }
        }
    }

    public void decodeFontCommandObj(String string, FormObject formObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "() ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        for (n2 = n - 1; n2 > -1; --n2) {
            float f;
            if (stringArray[n2].equals("g")) {
                --n2;
                f = 0.0f;
                try {
                    f = Float.parseFloat(stringArray[n2]);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating g value " + stringArray[n2]);
                }
                formObject.setTextColor(new Color(f, f, f));
                continue;
            }
            if (stringArray[n2].equals("Tf")) {
                --n2;
                int n3 = 8;
                try {
                    n3 = (int)Float.parseFloat(stringArray[n2]);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating Tf size " + stringArray[n2]);
                }
                --n2;
                String string2 = null;
                try {
                    string2 = stringArray[n2];
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating Tf font " + stringArray[n2]);
                }
                PdfFont pdfFont = new PdfFont();
                formObject.setTextFont(pdfFont.setFont(string2, n3));
                formObject.setTextSize(n3);
                continue;
            }
            if (stringArray[n2].equals("rg")) {
                f = Float.parseFloat(stringArray[--n2]);
                float f2 = Float.parseFloat(stringArray[--n2]);
                float f3 = Float.parseFloat(stringArray[--n2]);
                formObject.setTextColor(new Color(f3, f2, f));
                continue;
            }
            if (stringArray[n2].equals("Sig")) {
                LogWriter.writeFormLog("Sig-  UNIMPLEMENTED=" + string + "< " + n2, false);
                continue;
            }
            if (stringArray[n2].equals("\\n")) continue;
            LogWriter.writeFormLog("{stream} Unknown FONT command " + stringArray[n2] + ' ' + n2 + " string=" + string, false);
        }
    }

    public FormObject createAppearanceString(Map map, PdfObjectReader pdfObjectReader, int n) {
        return null;
    }
}

